var canvasDiv = document.getElementById('canvasDiv');
canvas = document.createElement('canvas');
canvas.setAttribute('width', window.innerWidth);
canvas.setAttribute('height',  window.innerHeight);
canvas.setAttribute('id', 'canvas'); 
canvasDiv.appendChild(canvas);
if(typeof G_vmlCanvasManager != 'undefined') {
	canvas = G_vmlCanvasManager.initElement(canvas);
}
context = canvas.getContext("2d"); 

function resize() {
	context.canvas.width = window.innerWidth;
	context.canvas.height = window.innerHeight;
} 

$(window).resize(function(e) {
	context.canvas.width = window.innerWidth;
	context.canvas.height = window.innerHeight;
	redraw();
});


//------------------------------Arrays & Variables--------------------------------------------------//
var clickColor = new Array();
var clickSize = new Array();
var clickX = new Array();
var clickY = new Array();
var clickDrag = new Array();

var lastColor = '#0066cc';
var currentColor = '#0066cc';
var currentImg = 'images/1.png';
var currentSize = 20;
var paint;
var currentTool = 'marker'

//------------------------------CREATING CANVAS DYNAMICALLY--------------------------------------------------//





var img = new Image();   // Create new img element

img.addEventListener('load', function() { 

	context.drawImage(img, (window.innerWidth/2)-210, (window.innerHeight/2)-250, 380, 380);

}, false);

img.src = currentImg; // Set source path 


//------------------------------FUNCTIONS--------------------------------------------------//

function addClick(x, y, dragging)
{	
	// var leftLimit = context.canvas.width*.055;
	// leftLimit = leftLimit.toFixed(0);
	// console.log(leftLimit) 
	// if(x>leftLimit){
		clickX.push(x);

		clickY.push(y);
		clickDrag.push(dragging);
	//adding eraser
	if(currentTool == 'eraser'){ 
		clickColor.push('#fff');
	}else{
		clickColor.push(currentColor);
	}
	
	clickSize.push(currentSize);
// }
}

function undo(){
	// alert(clickY.length)
	for(var i=0; i < clickY.length; i++) {	
		// for(var i2=0; i2 < clickY.length; i2++) {	
			clickX.splice(-1,1)
			clickY.splice(-1,1)
			clickDrag.splice(-1,1)
			clickSize.splice(-1,1)
			clickColor.splice(-1,1)
		// }
	}
	redraw()
}

function redraw(){

  context.clearRect(0, 0, context.canvas.width, context.canvas.height); // Clears the canvas
  
  context.strokeStyle = currentColor;
  context.lineJoin = "round";
  context.lineWidth = currentSize;

  for(var i=0; i < clickX.length; i++) {		
  	context.beginPath();
  	if(clickDrag[i] && i){
  		context.moveTo(clickX[i-1], clickY[i-1]);
  	}else{
  		context.moveTo(clickX[i]-1, clickY[i]);
  	}
  	context.lineTo(clickX[i], clickY[i]);
  	context.closePath();
  	context.strokeStyle = clickColor[i];
  	context.lineWidth = clickSize[i];
  	context.stroke();
  }
  context.drawImage(img, (window.innerWidth/2)-210, (window.innerHeight/2)-250, 380, 380);

}

//------------------------------EVENTS--------------------------------------------------//
$('#canvas').mousedown(function(e){
	var mouseX = e.pageX - this.offsetLeft;
	var mouseY = e.pageY - this.offsetTop;

	paint = true;
	addClick(e.pageX - this.offsetLeft, e.pageY - this.offsetTop);
	redraw();
	// alert(mouseX)
});

$('#canvas').mouseleave(function(e){
	paint = false;
});

$('#canvas').mouseup(function(e){
	paint = false;
});

$('#canvas').mousemove(function(e){
	if(paint){
		addClick(e.pageX - this.offsetLeft, e.pageY - this.offsetTop, true);
		redraw();
	}
});


$(document).ready(function(){
	$("body").css("cursor", "url(images/aim.png) 17 16, auto");

});
/*
window.addEventListener('click', function(e){
	paint = 1;
	mouseX = e.x;
	mouseY = e.y; 
//alert(this.offsetLeft)	

});
*/
//-------------------------------------Custom FUnctions
$(".myColorPicker").click(function(){
	$(".selectedColor").css("background", $(this).attr("id"));
	currentColor = $(this).attr("id"); 
	// var red = hexToRgb(currentColor).r;
	// var green = hexToRgb(currentColor).g;
	// var blue = hexToRgb(currentColor).b;
	// $(".slider").css("background", "rgba("+red+", "+green+", "+blue+", .5)");
});

$(".customcolor").change(function(){
	$(".selectedColor").css("background", $(this).val());
	currentColor = $(this).val(); 
});

$(".myImgPicker").click(function(){ 
	$("#selectedImg").html('<img src="images/'+$(this).attr("id")+'.png" style="width:100%; height: 100%; border-radius: 100px;">');
	img.src = 'images/'+$(this).attr("id")+'.png'; 


	clickColor = [];
	clickSize = [];
	clickX = [];
	clickY = [];
	clickDrag = [];

	redraw();
});

$("#myRange").change(function(){
	currentSize = $(this).val();
});

$(".Selecteraser").click(function(){ 
	$(".myerasor").html('<i class="fa fa-eraser" style="color:#fff;"></i>');
	
	currentTool = 'eraser';
	//replacing other unselected icons
	$(".mybrush").html('<i class="fa fa-paint-brush"></i>');
});

$(".Selectbrush").click(function(){ 
	$(".mybrush").html('<i class="fa fa-paint-brush" style="color:#fff;"></i>');
	currentTool = 'marker'; 
	//replacing other unselected icons
	$(".myerasor").html('<i class="fa fa-eraser"></i>');
});

// $(".saveBtn").click(function(){ 
// 	link.href = canvas.toDataURL();
// 	link.download = "mypainting.png";

// });

var link = document.createElement('a');
link.innerHTML = '<i class="fa fa-save"></i>  Save';
link.addEventListener('click', function(ev) {

		//get the current ImageData for the canvas.
		//data = context.getImageData(0, 0, w, h);

        // //store the current globalCompositeOperation
        // var compositeOperation = context.globalCompositeOperation;

        // //set to draw behind current content
        // context.globalCompositeOperation = "destination-over";

        // // //set background color
        // // context.fillStyle = '#fff';

        // // //draw background / rect on entire canvas
        // // context.fillRect(0,0,window.innerWidth,window.innerHeight);

        link.href = canvas.toDataURL();
        link.download = "mypainting.png";
        img.src = link.href;

        

    }, false);
$(".saveBtn").html(link);

$(".undoBtn").click(function(){
	undo();
});

hexToRgb = function (hex) {
	var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
	return result ? {
		r: parseInt(result[1], 16),
		g: parseInt(result[2], 16),
		b: parseInt(result[3], 16)
	} : null;
}

// $(document).ready(function(){
// 	$(document).bind("contextmenu",function(e){
// 		return false;
// 	});
// });
