var canvasDiv = document.getElementById('canvasDiv');
canvas = document.createElement('canvas');
canvas.setAttribute('width', window.innerWidth);
canvas.setAttribute('height',  window.innerHeight);
canvas.setAttribute('id', 'canvas'); 
canvasDiv.appendChild(canvas);
if(typeof G_vmlCanvasManager != 'undefined') {
	canvas = G_vmlCanvasManager.initElement(canvas);
}
context = canvas.getContext("2d");
canvas.setAttribute('crossOrigin', '');


context.fillStyle = "rgb(255,0,0)"; 
context.fillRect(0, 0, 50, 50);
context.fillStyle = "rgb(0,0,255)";
context.fillRect(55, 0, 50, 50);

var img = new Image();   // Create new img element

img.addEventListener('load', function() { 

	context.drawImage(img, 100, 100);

}, false);

img.src = 'images/tree2.jpeg'; // Set source path 



$('#canvas').mousedown(function(e){
	var pos = findPos(this);
	var mouseX = e.pageX - pos.x;
	var mouseY = e.pageY - pos.y;
	var c = this.getContext('2d');
	var imgData = context.getImageData(mouseX, mouseY, 1, 1);

	//var newColor = [51, 153, 51, 255];
	
	paintAt(imgData, mouseX, mouseY, imgData.data[0], imgData.data[1], imgData.data[2]);

});

function paintAt(imgData, x, y, red, green, blue){
	outlineLayerData = context.getImageData(0, 0, window.innerWidth, window.innerHeight);

	pixelPos = (y*window.innerWidth + x) * 4;

	// alert( outlineLayerData.data[pixelPos])
	console.log('pix = '+pixelPos+' color = '+outlineLayerData.data[pixelPos]);
	console.log('pix = '+(pixelPos+1)+' color = '+outlineLayerData.data[pixelPos]);
	
}

// function paintAt(imgData, mouseX, mouseY, red, green, blue){
// 	// Go upwards as far as the pixel matches
// 	var x = mouseX;
// 	var y = mouseY;
// 	var paint_true = 1;


// 	//Go up as far as can
// 	do{
// 		var is = pixelMatch(x, y, red, green, blue, imgData);
// 		// console.log(is);
// 		// console.log('r: '+imgData.data[0]+' g: '+imgData.data[1]+' b: '+imgData.data[2]+' at y = '+y);

// 		for (var i = 0; i < imgData.data.length; i += 4) {
// 			imgData.data[i]     = 51  ;
// 			imgData.data[i + 1] = 153 ;
// 			imgData.data[i + 2] = 33  ;
// 		}
// 		context.putImageData(imgData, mouseX, y);

// 		//go right
// 		var pointX = x+1;
// 		do{	

// 			var pointX_match = pixelMatch(pointX, y, red, green, blue); 

// 			for (var i = 0; i < imgData.data.length; i += 4) {
// 				imgData.data[i]     = 51  ;
// 				imgData.data[i + 1] = 153 ;
// 				imgData.data[i + 2] = 33  ; 
// 			}
// 			context.putImageData(imgData, pointX, y);
// 			pointX = pointX + 1;
// 		}while(pointX_match == true && pointX <= 9999);


// 		y --;
// 	}while(is == true && y >= 0);
// }

function fill_side(x, y, red, green, blue, imgData){

}

//check if pixel match
function pixelMatch(pixelX, pixelY, red, green, blue){

	var pixelData = context.getImageData(pixelX, pixelY, 1, 1).data;
	if(pixelData[0] == red && pixelData[1] == green && pixelData[2] == blue){
		return true;
		// return 'R: '+pixelData[0]+' G: '+pixelData[1]+' B: '+pixelData[2]+' AT Y = '+pixelY;
	}else{
		// return pixelY;
		return 'R: '+pixelData[0]+' G: '+pixelData[1]+' B: '+pixelData[2]+' AT Y = '+pixelY;
	}

}

function findPos(obj) {
	var curleft = 0, curtop = 0;
	if (obj.offsetParent) {
		do {
			curleft += obj.offsetLeft;
			curtop += obj.offsetTop;
		} while (obj = obj.offsetParent);
		return { x: curleft, y: curtop };
	}
	return undefined;
}

$(window).resize(function(e) {
	canvas.width = window.innerWidth;
	canvas.height = window.innerHeight;
	context.drawImage(img, 100, 100);
});