var canvas = this.__canvas = new fabric.Canvas('c', {
    isDrawingMode: true,
    width: window.innerWidth - 50,
    height: window.innerHeight - 160,

});

canvas.backgroundColor = '#fff';
canvas.freeDrawingBrush.color = '#0066cc';
canvas.freeDrawingBrush.width = parseInt(10, 11);
var context = canvas.getContext('2d');

addImage(base_url + 'images/drawing/'+first_img);
function addImage(imgLink) {
    canvas.clear();
    canvas.backgroundColor = '#fff';
    fabric.Image.fromURL(imgLink, function (img) {

        img.scaleToWidth(canvas.width * .6);
        img.scaleToHeight(canvas.height * .6);
        canvas.centerObject(img);

        var objs = canvas.getObjects();
        canvas.renderAll();
        if (objs.length) {
            objs.forEach(function (e) {
                if (e && e.type === 'image') {
                    e._element.src = imgLink;
                    canvas.renderAll();
                }
            });
        } else
            canvas.setOverlayImage(img, canvas.renderAll.bind(canvas));
        canvas.add(img);
    });

}

$("#myRange").change(function () {
    canvas.freeDrawingBrush.width = parseInt($(this).val(), 11);
});

$(".myColorPicker").click(function () {
//    $(".mybrush").html('<i class="fa fa-paint-brush" style="color:#fff;"></i>');
    $(".myerasor").html('<i class="fa fa-eraser"></i>');

    $(".selectedColor").css("background", $(this).attr("id"));

    var red = hexToRgb($(this).attr("id")).r;
    var green = hexToRgb($(this).attr("id")).g;
    var blue = hexToRgb($(this).attr("id")).b;

    canvas.freeDrawingBrush.color = $(this).attr("id");
    $('#cur-clr').val($(this).attr("id"));
    var clr = $(this).attr("id");
    if(clr === '#ffffff'){
        clr = 'rgba(0,0,0,.5)';
    }
    $(".mybrush").html('<i class="fa fa-paint-brush" style="color:'+clr+'"></i>');
    $(".myerasor").html('<i class="fa fa-eraser"></i>');
});

$(".customcolor").change(function () {
    $(".mybrush").html('<i class="fa fa-paint-brush" style="color:#fff;"></i>');
    $(".myerasor").html('<i class="fa fa-eraser"></i>');

    $(".selectedColor").css("background", $(this).val());
    canvas.freeDrawingBrush.color = $(this).val();
});

$(".myImgPicker").click(function () {

    addImage(base_url + "images/drawing/" + $(this).attr("id"));

});

fabric.PencilBrush.prototype.onMouseMove = (function (onMouseMove) {
    return function (pointer) {
        updateModifications(true);
        onMouseMove.call(this, pointer);
        var context = this.canvas.contextTop;
        context.save();
        this.canvas._renderOverlay(context);
        context.restore();

    };
})(fabric.PencilBrush.prototype.onMouseMove);

var state = [];
var mods = 0;


function updateModifications(savehistory) {
    if (savehistory === true) {
        myjson = JSON.stringify(canvas);
        state.push(myjson);
    }
}

undo = function undo() {
    console.log(state)
    if (mods < state.length) {
        canvas.clear().renderAll();
        canvas.loadFromJSON(state[state.length - 1 - mods - 1]);
        canvas.renderAll();
        mods += 50;
    }
}

var link = document.createElement('a');
link.innerHTML = '<i class="fa fa-save"></i>  Save';
link.addEventListener('click', function (ev) {
    link.href = canvas.toDataURL();
    var dt = new Date();
    var time = dt.getDate() + "-" + dt.getMonth() + "-" + dt.getFullYear() + " " + dt.getHours() + ":" + dt.getMinutes() + ":" + dt.getSeconds();
    link.download = "Deen " + time + ".png";
}, false);
$(".saveBtn").html(link);

//----------------------Additional Non Functional Methods-----------------------------------------//
hexToRgb = function (hex) {
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;
}

$(".Selecteraser").click(function () {
    $(".myerasor").html('<i class="fa fa-eraser" style="color:blue;"></i>');

    canvas.freeDrawingBrush.color = '#fff';
    //replacing other unselected icons
    $(".mybrush").html('<i class="fa fa-paint-brush"></i>');
});
$(".Selectbrush").click(function () {
    $(".myerasor").html('<i class="fa fa-eraser"></i>');

    canvas.freeDrawingBrush.color = $('#cur-clr').val();
    var clr = $('#cur-clr').val();
    if(clr === '#ffffff'){
        clr = 'rgba(0,0,0,.5)';
    }
    //replacing other unselected icons
    $(".mybrush").html('<i class="fa fa-paint-brush" style="color:'+clr+'"></i>');
});


