<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'home';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

$route['membership'] = "home/membership";
$route['about'] = "home/about";
$route['donate'] = "home/donate";
$route['contact'] = "home/contact";
$route['contact/send'] = "home/contact_send";
$route['forgot-password'] = "home/forgot_password";
$route['reset-password/(:any)'] = "home/reset_password/$1";
$route['reset-password'] = "home/reset_password";
$route['confirm-account/(:any)'] = "home/account_confirmation/$1";
$route['confirm-account'] = "home/account_confirmation";
$route['login'] = "home/login";
$route['privacy'] = "home/privacy";
$route['support'] = "home/support";
$route['terms-conditions'] = "home/terms_conditions";
$route['payment'] = "home/membership_form";
$route['logout'] = "home/logout";
$route['primary-school'] = "home/primary_school";


$route['dashboard'] = "dashboard";
$route['dashboard/create-child'] = "dashboard/create_child";
$route['dashboard/store-child'] = "dashboard/store_child";
$route['dashboard/childern'] = "dashboard/childern";
$route['dashboard/delete-child/(:num)'] = "dashboard/delete_child/$1";
$route['dashboard/edit-child/(:num)'] = "dashboard/edit_child/$1";
$route['dashboard/update-child'] = "dashboard/update_child";
$route['dashboard/choose-child/(:num)'] = "dashboard/choose_child/$1";
$route['dashboard/unchoose-child'] = "dashboard/unchoose_child";
$route['dashboard/save-progress'] = "dashboard/save_progress";
$route['dashboard/progress/(:num)'] = "dashboard/progress/$1";
$route['dashboard/packages']="dashboard/packages";
$route['dashboard/update-package-info']="dashboard/update_package_info";
$route['dashboard/update-package']="dashboard/update_package";


$route['dashboard/truefalse/(:num)'] = "dashboard/truefalse_subcategories/$1";
$route['dashboard/truefalse/(:num)/(:num)'] = "dashboard/load_truefalse/$1/$2";
$route['dashboard/multiple-choice'] = "dashboard/mcq";
$route['dashboard/multiple-choice/(:num)'] = "dashboard/mcq_subcategories/$1";
$route['dashboard/multiple-choice/(:num)/(:num)'] = "dashboard/load_mcq/$1/$2";
$route['dashboard/sequence'] = "dashboard/sequence";
$route['dashboard/sequence/(:num)'] = "dashboard/sequence_subcategories/$1";
$route['dashboard/sequence/(:num)/(:num)'] = "dashboard/load_sequence/$1/$2";
$route['dashboard/crossword'] = "dashboard/crossword";
$route['dashboard/crossword/(:num)'] = "dashboard/crossword_subcategories/$1";
$route['dashboard/crossword/(:num)/(:num)'] = "dashboard/load_crossword/$1/$2";

//$route['language/(:any)'] = "LanguageSwitcher/switchLanguage/$1";


/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

/////////////////////////   Admin Panel  ////////////////////////////

/////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

$route['admin'] = "admin/signin";
$route['admin/signin/secure'] = "admin/signin/signin";
$route['admin/dashboard'] = "admin/home";

$route['admin/content/primary-school-home'] = "admin/content/primary_school_home";
$route['admin/content/primary-school-home/save'] = "admin/content/primary_school_home_save";
$route['admin/content/home-page'] = "admin/content/home_page";
$route['admin/content/home-page/save'] = "admin/content/home_page_save";
$route['admin/content/about-page'] = "admin/content/about_page";
$route['admin/content/about-page/save'] = "admin/content/about_page_save";
$route['admin/content/contact-page'] = "admin/content/contact_page";
$route['admin/content/contact-page/save'] = "admin/content/contact_page_save";
$route['admin/content/membership-plans'] = "admin/content/membership_plan";
$route['admin/content/membership-plans/save'] = "admin/content/membership_plan_save";
$route['admin/content/videos'] = "admin/content/videos";
$route['admin/content/videos/edit/:num'] = "admin/content/videos_edit/$$1";
$route['admin/content/videos/edit/save'] = "admin/content/edit_video_save";

$route['admin/quiz/multiple-choice'] = "admin/home/multiple_choice";
$route['admin/quiz/multiple-choice/add'] = "admin/home/add_multiple_choice";
$route['admin/quiz/multiple-choice/edit/:num'] = "admin/home/edit_multiple_choice/$1";
$route['admin/quiz/multiple-choice/edit/save'] = "admin/home/edit_multiple_choice_save";
$route['admin/quiz/multiple-choice/add/save'] = "admin/home/add_multiple_choice_save";
$route['admin/quiz/multiple-choice/delete'] = "admin/home/delete_multiple_choice";
$route['admin/quiz/true-false'] = "admin/home/true_false";
$route['admin/quiz/true-false/add'] = "admin/home/add_true_false";
$route['admin/quiz/true-false/edit/:num'] = "admin/home/edit_true_false/$1";
$route['admin/quiz/true-false/edit/save'] = "admin/home/edit_true_false_save";
$route['admin/quiz/true-false/add/save'] = "admin/home/add_true_false_save";
$route['admin/quiz/true-false/delete'] = "admin/home/delete_true_false";
$route['admin/quiz/sequence'] = "admin/home/sequence";
$route['admin/quiz/sequence/add'] = "admin/home/add_sequence";
$route['admin/quiz/sequence/edit/:num'] = "admin/home/edit_sequence/$1";
$route['admin/quiz/sequence/edit/save'] = "admin/home/edit_sequence_save";
$route['admin/quiz/sequence/add/save'] = "admin/home/add_sequence_save";
$route['admin/quiz/sequence/delete'] = "admin/home/delete_sequence";
$route['admin/quiz/crossword'] = "admin/home/crossword";
$route['admin/quiz/crossword/add'] = "admin/home/add_crossword";
$route['admin/quiz/crossword/add/save'] = "admin/home/add_crossword_save";

$route['admin/users'] = "admin/home/get_users";
$route['admin/users/admins'] = "admin/home/get_admins";
$route['admin/users/admins/add'] = "admin/home/add_admin";
$route['admin/users/admins/add/save'] = "admin/home/add_admin_save";

$route['admin/kindergarten/islamic-manners'] = "admin/home/islamic_manners";
$route['admin/kindergarten/islamic-manners/add'] = "admin/home/add_islamic_manners";
$route['admin/kindergarten/islamic-manners/add/save'] = "admin/home/add_islamic_manners_save";
$route['admin/kindergarten/islamic-manners/edit/:num'] = "admin/home/edit_islamic_manners/$1";
$route['admin/kindergarten/islamic-manners/edit/save'] = "admin/home/edit_islamic_manners_save";
$route['admin/kindergarten/quran'] = "admin/home/quran";
$route['admin/kindergarten/quran/add'] = "admin/home/add_quran";
$route['admin/kindergarten/quran/add/save'] = "admin/home/add_quran_save";
$route['admin/kindergarten/quran/edit/:num'] = "admin/home/edit_quran/$1";
$route['admin/kindergarten/quran/edit/save'] = "admin/home/edit_quran_save";
$route['admin/kindergarten/prayers'] = "admin/home/prayers";
$route['admin/kindergarten/prayers/add'] = "admin/home/add_prayers";
$route['admin/kindergarten/prayers/add/save'] = "admin/home/add_prayers_save";
$route['admin/kindergarten/prayers/edit/:num'] = "admin/home/edit_prayers/$1";
$route['admin/kindergarten/prayers/edit/save'] = "admin/home/edit_prayers_save";
$route['admin/kindergarten/islamic-words'] = "admin/home/islamic_words";
$route['admin/kindergarten/islamic-words/add'] = "admin/home/add_islamic_words";
$route['admin/kindergarten/islamic-words/add/save'] = "admin/home/add_islamic_words_save";
$route['admin/kindergarten/islamic-words/edit/:num'] = "admin/home/edit_islamic_words/$1";
$route['admin/kindergarten/islamic-words/edit/save'] = "admin/home/edit_islamic_words_save";
$route['admin/kindergarten/paint'] = "admin/home/drawing";
$route['admin/kindergarten/paint/save'] = "admin/home/drawing_save";


/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

//////////////////////////////   API  ///////////////////////////////

/////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

$route['demo/multiple-choice/'] = "API/demo/multipleChoice";
$route['demo/multiple-choice/(:num)/(:num)'] = "API/demo/multipleChoice/$1/$2";

$route['demo/true-false/'] = "API/demo/truefalse";
$route['demo/true-false/(:num)/(:num)'] = "API/demo/truefalse/$1/$2";

$route['demo/sequence/'] = "API/demo/sequence";
$route['demo/sequence/(:num)/(:num)'] = "API/demo/sequence/$1/$2";

$route['demo/crossword/'] = "API/demo/crossword";
$route['demo/crossword/(:num)/(:num)'] = "API/demo/crossword/$1/$2";