<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

    public function __construct() {

        parent::__construct();
        if (!$this->session->userdata('logged_in')) {

            $this->session->set_flashdata('no_access', 'Please login to access this page.');

            redirect('login');

        }
        if($this->input->get('lang')){
               define('LANG', $this->input->get('lang'));
        }
        else{
            define('LANG', 'en');
        }

    }

    public function create_child(){

       $data['dashboard_title'] = "Create Child - Deen";

       $data['dash_view'] = LANG."/dashboard/create_child_view";
       $this->load->model('child_model');
        // $this->child_model->save_child();
       $data['school'] =  $this->child_model->school();

       $this->load->view( LANG.'/layouts/dashboard', $data);
    }

    public function store_child(){
      $this->load->model('child_model');
        $this->child_model->save_child();
        $this->index();
    }

    public function childern(){
      $data['dashboard_title'] = "Childern - Deen";
      $data['dash_view'] = LANG."/dashboard/childern_view";
      $this->load->model('child_model');
      $data['childern'] = $this->child_model->childern();
      // dd($data['childern']);
      $this->load->view(LANG.'/layouts/dashboard', $data);
    }

    public function delete_child($id){
      // dd('hello');
      $this->load->model('child_model');
      $this->child_model->delete_child($id);
      $this->childern();
    }

    public function edit_child($id){
      $this->load->model('child_model');
      $data['dashboard_title'] = "Edit Child - Deen";
      $data['dash_view'] = LANG."/dashboard/edit_child_view";
      $data['child'] = $this->child_model->get_child($id);
      $data['school'] = $this->child_model->school();
      $this->load->view(LANG.'/layouts/dashboard', $data);
    }
    public function update_child(){
      $this->load->model('child_model');
      $this->child_model->update_child();
      $this->childern();
    }

    public function choose_child($id){
      $this->load->model('child_model');
      $this->child_model->choose_child($id);
      $this->childern();
    }

    public function unchoose_child(){
      $this->load->model('child_model');
      $this->child_model->unchoose_child();
      $this->childern();
    }

    public function save_progress(){
      $this->load->model('child_model');
      $this->child_model->save_progress();
    }

    public function packages(){
      $this->load->model('content_model');
              $data['content'] = $this->content_model->get_view_content('membership-plan');
    
        if(LANG == 'no'){
            $data['dashboard_title'] = 'Medlemskap' . $this->lang->line("msg_website_title");
            
        }
        else{
            $data['dashboard_title'] = $this->lang->line("msg_membership_title") . $this->lang->line("msg_website_title");
            
        }
        
        $data['dash_view'] = LANG . "/dashboard/package_view";
        $this->load->view(LANG . '/layouts/dashboard', $data);
    }
    public function update_package_info(){
      $plan = $this->input->get('plan');
      // dd($plan);  
      $data['pkg'] = $plan;
      $this->load->model('content_model');
      $data['content'] = $this->content_model->get_view_content('membership-plan');
      if(LANG == 'no')
        $data['dashboard_title'] = "Oppdateringspakke - Deen";
      else
        $data['dashboard_title'] = "Update Package - Deen";

      $data['dash_view'] = LANG."/dashboard/payment_view";
      $this->load->view(LANG.'/layouts/dashboard', $data);

     }
     public function update_package(){

        $this->load->model('user_model');
        $result = $this->user_model->update_package();
       
        if($result == 1){
          if(LANG =='en')
            $this->session->set_flashdata('account_updated', 'Account successfully updated.');
          else
            $this->session->set_flashdata('account_updated', 'Kontoen er opprettet.');
          $data['dashboard_title'] = "Dashboard - Deen";
      $data['dash_view'] = LANG."/dashboard/home_view";
      $this->load->view( LANG.'/layouts/dashboard', $data); 
        }
    }

    public function progress($id){
      $this->load->model('child_model');
      $data['child'] = $this->child_model->get_child($id);
      $data['progress'] = $this->child_model->progress($id);
      
      if(LANG == 'no')
        $data['dashboard_title'] = "Fremdriftsrapport - Deen";
      else
        $data['dashboard_title'] = "Progress Report - Deen";

      $data['dash_view'] = LANG."/dashboard/progress_child_view";
      $this->load->view(LANG.'/layouts/dashboard', $data);
    }

    public function index() {
      $data['dashboard_title'] = "Dashboard - Deen";
      $data['dash_view'] = LANG."/dashboard/home_view";
      $this->load->view( LANG.'/layouts/dashboard', $data);
    }

    public function mcq() {

        if(!$data['categories'] = $this->content_model->get_categories('2')){
            redirect('dashboard/multiple-choice');
        }
       $data['dashboard_title'] = "Multiple Choice - Deen";
       $data['dash_view'] = LANG."/dashboard/mcq_categories_view";
       $this->load->view( LANG.'/layouts/dashboard', $data);
    }

    public function mcq_subcategories($id) {

        if(!$data['categories'] = $this->content_model->get_sub_categories($id)){

            redirect('dashboard/multiple-choice');

        }

        $data['dashboard_title'] = "Multiple Choice - Deen";

       $data['dash_view'] = LANG."/dashboard/mcq_subcategories_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function load_mcq() {

        $data['dashboard_title'] = "Multiple Choice - Deen";

       $data['dash_view'] = LANG."/dashboard/mcq_view";

       $this->load->view( LANG.'/layouts/game-dashboard', $data);

    }

    public function truefalse() {

        if(!$data['categories'] = $this->content_model->get_categories('2')){

            redirect('dashboard/truefalse');

        }

        $data['dashboard_title'] = "True False - Deen";

       $data['dash_view'] = LANG."/dashboard/truefalse_categories_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function truefalse_subcategories($id) {

        if(!$data['categories'] = $this->content_model->get_sub_categories($id)){

            redirect('dashboard/truefalse');

        }

        $data['dashboard_title'] = "True False - Deen";

       $data['dash_view'] = LANG."/dashboard/truefalse_subcategories_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function load_truefalse() {

        $data['dashboard_title'] = "True False - Deen";

       $data['dash_view'] = LANG."/dashboard/truefalse_view";

       $this->load->view( LANG.'/layouts/game-dashboard', $data);

    }

    public function sequence() {

        if(!$data['categories'] = $this->content_model->get_categories('2')){

            redirect('dashboard/sequence');

        }

        $data['dashboard_title'] = "Organize in Correct Order - Deen";

       $data['dash_view'] = LANG."/dashboard/sequence_categories_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function sequence_subcategories($id) {

        if(!$data['categories'] = $this->content_model->get_sub_categories($id)){

            redirect('dashboard/sequence');

        }

        $data['dashboard_title'] = "Organize in Correct Order - Deen";

       $data['dash_view'] = LANG."/dashboard/sequence_subcategories_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function load_sequence() {

        $data['dashboard_title'] = "Organize in Correct Order - Deen";

       $data['dash_view'] = LANG."/dashboard/sequence_view";

       $this->load->view( LANG.'/layouts/game-dashboard', $data);

    }

    public function quran() {

        $quran = $data['quran'] = $this->content_model->get_quran();

        $data['dashboard_title'] = "Quran - Deen";

       $data['dash_view'] = LANG."/dashboard/quran_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function islamicmanners() {

        $data['manners'] = $this->content_model->get_manners();

        $data['dashboard_title'] = "Islamic Manners - Deen";

       $data['dash_view'] = LANG."/dashboard/islamic_manners_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function islamicwords() {

        $data['words'] = $this->content_model->get_islamic_words();

        $data['dashboard_title'] = "Islamic Words - Deen";

       $data['dash_view'] = LANG."/dashboard/islamic_words_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function prayers() {

        $data['prayers'] = $this->content_model->get_prayers();

        $data['dashboard_title'] = "Islamic Prayers - Deen";

       $data['dash_view'] = LANG."/dashboard/prayers_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function paint() {

        $data['drawings'] = $this->db->get('drawings')->result();

        $data['dashboard_title'] = "Paint - Deen";

       $this->load->view( LANG.'/dashboard/paint_view',$data);

    }

    public function arabicletters() {

        $data['dashboard_title'] = "Arabic Letters Game - Deen";

       $data['dash_view'] = LANG."/dashboard/game_view";

       $this->load->view( LANG.'/dashboard/game_view', $data);

    }

    public function crossword() {

        if(!$data['categories'] = $this->content_model->get_categories('2')){

            redirect('dashboard/crossword');

        }

        $data['dashboard_title'] = "Crossword - Deen";

       $data['dash_view'] = LANG."/dashboard/crossword_categories_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function crossword_subcategories($id) {

        if(!$data['categories'] = $this->content_model->get_sub_categories($id)){

            redirect('dashboard/crossword');

        }

        $data['dashboard_title'] = "Crossword - Deen";

       $data['dash_view'] = LANG."/dashboard/crossword_subcategories_view";

       $this->load->view( LANG.'/layouts/dashboard', $data);

    }

    public function load_crossword() {

        $data['dashboard_title'] = "Crossword - Deen";

       $data['dash_view'] = LANG."/dashboard/crossword_view";

       $this->load->view( LANG.'/layouts/game-dashboard', $data);

    }

}

