<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {


        public function __construct() {

        parent::__construct();

            if($this->input->get('lang')){
               define('LANG', $this->input->get('lang'));
        }
        else{
            define('LANG', 'en');
        }

    }

    public function index() {
        $data['content'] = $this->content_model->get_view_content('home-page');
        $data["page_title"] = $this->lang->line("msg_home_title");
        $data['videos'] = $this->content_model->get_view_videos();
        $data['main_view'] = LANG . "/public/home_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function membership() {
        $data['content'] = $this->content_model->get_view_content('membership-plan');
        // dd($data['content']);
        $data['show_page_header'] = TRUE;
        // $data["page_title"] = $this->lang->line("msg_membership_title") . $this->lang->line("msg_website_title");
        if(LANG == 'no'){
            $data["page_title"] = 'Medlemskap' . $this->lang->line("msg_website_title");
            $data["page_title_header"] = 'Medlemskap';
            $data["breadcrumbs"] = '<a href="' . base_url() . '"> Hjem </a>&ensp;>&ensp;<a href="' . site_url('membership') . '">Medlemskap</a>';
        }
        else{
            $data["page_title"] = $this->lang->line("msg_membership_title") . $this->lang->line("msg_website_title");
            $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('membership') . '">' . $this->lang->line("msg_membership_title") . '</a>';
        $data["page_title_header"] = $this->lang->line("msg_membership_title");
        }
        // $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('membership') . '">' . $this->lang->line("msg_membership_title") . '</a>';
        // $data["page_title_header"] = $this->lang->line("msg_membership_title");
        $data['main_view'] = LANG . "/public/membership_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function about() {
        $data['content'] = $this->content_model->get_view_content('about-page');
        $data['show_page_header'] = TRUE;

        if(LANG == 'no'){
                    $data["page_title"] = 'Om oss' . $this->lang->line("msg_website_title");
        
        $data["page_title_header"] = 'Om oss';
        $data["breadcrumbs"] = '<a href="' . base_url() . '">Hjem</a>&ensp;>&ensp;<a href="' . site_url('about') . '">Om oss</a>';
        }
        else{
                    $data["page_title"] = $this->lang->line("msg_about_title") . $this->lang->line("msg_website_title");
        
        $data["page_title_header"] = $this->lang->line("msg_about_title");
        $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('about') . '">' . $this->lang->line("msg_about_title") . '</a>';
        }




        // $data["page_title"] = $this->lang->line("msg_about_title") . $this->lang->line("msg_website_title");
        
        // $data["page_title_header"] = $this->lang->line("msg_about_title");
        // $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('about') . '">' . $this->lang->line("msg_about_title") . '</a>';
        $data['main_view'] = LANG . "/public/about_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function donate() {
        $data['show_page_header'] = TRUE;


if(LANG == 'no'){
        $data["page_title"] = 'Donasjoner' . $this->lang->line("msg_website_title");
        $data["breadcrumbs"] = '<a href="' . base_url() . '">Hjem</a>&ensp;>&ensp;<a href="' . site_url('donate') . '">Donasjoner </a>';
        $data["page_title_header"] = 'Donasjoner';
        }
        else{
        $data["page_title"] = $this->lang->line("msg_donate_title") . $this->lang->line("msg_website_title");
        $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('donate') . '">' . $this->lang->line("msg_donate_title") . '</a>';
        $data["page_title_header"] = $this->lang->line("msg_donate_title");
        }






        // $data["page_title"] = $this->lang->line("msg_donate_title") . $this->lang->line("msg_website_title");
        // $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('donate') . '">' . $this->lang->line("msg_donate_title") . '</a>';
        // $data["page_title_header"] = $this->lang->line("msg_donate_title");
        $data['main_view'] = LANG . "/public/donate_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function contact() {
        $data['content'] = $this->content_model->get_view_content('contact-page');
        $data['show_page_header'] = TRUE;
       
    if(LANG == 'no'){
        $data["page_title"] = 'Kontakt oss' . $this->lang->line("msg_website_title");
        $data["page_title_header"] = 'Kontakt oss';
        $data["breadcrumbs"] = '<a href="' . base_url() . '">Hjem</a>&ensp;>&ensp;<a href="' . site_url('contact') . '">Kontakt oss</a>';
        }
        else{
        $data["page_title"] = $this->lang->line("msg_contact_title") . $this->lang->line("msg_website_title");
        $data["page_title_header"] = $this->lang->line("msg_contact_title");
        $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('contact') . '">' . $this->lang->line("msg_contact_title") . '</a>';
        }
    






        // $data["page_title"] = $this->lang->line("msg_contact_title") . $this->lang->line("msg_website_title");
        // $data["page_title_header"] = $this->lang->line("msg_contact_title");
        // $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('contact') . '">' . $this->lang->line("msg_contact_title") . '</a>';
        $data['main_view'] = LANG . "/public/contact_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function contact_send() {
        $htmlContent = "<h2>New Contact Form Submitted on Deen.no</h2>";
        $htmlContent .= "<p><b>Navn: </b> ".$this->input->post('name')."</p>";
        $htmlContent .= "<p><b>E-post: </b> ".$this->input->post('email')."</p>";
        $htmlContent .= "<p><b>Telefon: </b> ".$this->input->post('phone')."</p>";
        $htmlContent .= "<p><b>Beskjed: </b> ".$this->input->post('message')."</p>";
        
        $this->email->to(Contact_Email);
        $this->email->from(EMAIL_FROM_SMTP, 'Deen Contact');
        $this->email->subject('Deen Contact Form Request');
        $this->email->message($htmlContent);
        $this->email->send();
        
        $return_data = array(
            status => "true"
        );
        
        return json_encode($return_data);
    }

    public function forgot_password() {
        if ($this->session->userdata('logged_in')) {
            redirect('dashboard');
        }
        $data["page_title"] = $this->lang->line("msg_forgot_password_title") . $this->lang->line("msg_website_title");
        $data["page_title_header"] = $this->lang->line("msg_forgot_password_title");
        $data['main_view'] = LANG . "/public/forgot-password_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function login() {
        if ($this->session->userdata('logged_in')) {
            redirect('dashboard');
        }
        $data["page_title"] = $this->lang->line("msg_login_title") . $this->lang->line("msg_website_title");
        $data["page_title_header"] = $this->lang->line("msg_login_title");
        $data['main_view'] = LANG . "/public/login_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function privacy() {
        $data['show_page_header'] = TRUE;
        $data["page_title"] = $this->lang->line("msg_privacy_title") . $this->lang->line("msg_website_title");
        $data["page_title_header"] = $this->lang->line("msg_privacy_title");
        $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('privacy') . '">' . $this->lang->line("msg_privacy_title") . '</a>';
        $data['main_view'] = LANG . "/public/privacy_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function support() {
        $data['show_page_header'] = TRUE;
        $data["page_title"] = $this->lang->line("msg_support_title") . $this->lang->line("msg_website_title");
        $data["page_title_header"] = $this->lang->line("msg_support_title");
        $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('support') . '">' . $this->lang->line("msg_support_title") . '</a>';
        $data['main_view'] = LANG . "/public/support_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function terms_conditions() {
        $data['show_page_header'] = TRUE;
        $data["page_title"] = $this->lang->line("msg_terms_conditions_title") . $this->lang->line("msg_website_title");
        $data["page_title_header"] = $this->lang->line("msg_terms_conditions_title");
        $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('terms-conditions') . '">' . $this->lang->line("msg_terms_conditions_title") . '</a>';
        $data['main_view'] = LANG . "/public/terms-conditions_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function membership_form() {
         if ($this->session->userdata('logged_in')) {
             redirect('dashboard');
        }
        $data['show_page_header'] = TRUE;
        $data['content'] = $this->content_model->get_view_content('membership-plan');
        $data["page_title"] = $this->lang->line("msg_membership_form_title") . $this->lang->line("msg_website_title");
        $data["page_title_header"] = $this->lang->line("msg_membership_form_title");
        $data["breadcrumbs"] = '<a href="' . base_url() . '">' . $this->lang->line("msg_home") . '</a>&ensp;>&ensp;<a href="' . site_url('payment') . '">' . $this->lang->line("msg_membership_form_title") . '</a>';
        $data['main_view'] = LANG . "/public/membership-form_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function logout() {
        $this->session->sess_destroy();
        if(LANG == 'en')
            redirect();
        else
            redirect('?lang=no');
    }

    public function account_confirmation($secret_code = '') {
        if ($this->session->userdata('logged_in')) {
            redirect('dashboard');
        }
        if ($secret_code == '') {
            $this->session->set_flashdata('account_confirm_failed', 'Invalid Reset Link!');
            redirect();
        }
        $this->load->model('user_model');
        if ($this->user_model->user_check_secret_code($secret_code)) {
            if ($this->user_model->user_confirmation($secret_code)) {
                $this->session->set_flashdata('account_confirmed', 'Your account is confirmed!');
                redirect();
            } else {
                $this->session->set_flashdata('account_confirm_failed', 'Something went wrong!');
                redirect();
            }
        } else {
            $this->session->set_flashdata('account_confirm_failed', 'Invalid Reset Link!');
            redirect();
        }
    }

    public function reset_password($secret_code = '') {
        if ($this->session->userdata('logged_in')) {
            redirect('dashboard');
        }
        if ($secret_code == '') {
            redirect();
        }
        $data["valid_secret"] = FALSE;
        $this->load->model('user_model');
        if ($this->user_model->user_check_secret_code($secret_code)) {
            $data["valid_secret"] = TRUE;
        } else {
            $this->session->set_flashdata('no_access', 'Invalid Reset Link! Please try again.');
            $data["valid_secret"] = FALSE;
        }
        $data['secret'] = $secret_code;
        $data["page_title"] = "Reset Password" . $this->lang->line("msg_website_title");
        $data["page_title_header"] = "Reset Password";
        $data['main_view'] = LANG . "/public/reset-password_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

    public function primary_school() {
        $data['content'] = $this->content_model->get_view_content('primary-school-home');
        $data["page_title"] = "Deen Primary School" . $this->lang->line("msg_website_title");
        $data["page_title_header"] = "Deen Barneskole";
        $data['main_view'] = LANG . "/public/primary_school_view";
        $this->load->view(LANG . '/layouts/main', $data);
    }

}
