<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Payments extends CI_Controller {

    public function __construct() {

        parent::__construct();

        if ($this->session->userdata('logged_in')) {

            redirect('dashboard');
        }
        if($this->input->get('lang')){
               define('LANG', $this->input->get('lang'));
        }
        else{
            define('LANG', 'en');
        }
    }

    public function index() {

        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|is_unique[users.email]');
        $this->form_validation->set_message('is_unique', 'Email already exists!');
        $this->form_validation->set_rules('first_name', 'First Name', 'trim|required|alpha|min_length[2]');
        $this->form_validation->set_rules('last_name', 'Last Name', 'trim|required|alpha|min_length[2]');
        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[8]');
        $this->form_validation->set_rules('no_of_children', 'no_of_children', 'trim|required');
        $this->form_validation->set_rules('plan', 'Plan', 'trim|required');

        if (!$this->form_validation->run()) {
            $data["page_title"] = $this->lang->line("msg_membership_form_title") . $this->lang->line("msg_website_title");
            $data['main_view'] = LANG."/public/membership-form_view";

            $this->load->view(LANG.'/layouts/main', $data);
        } else {
            $this->load->model('user_model');
            $secret_code = random_string('sha1');
            if ($this->user_model->create_user($secret_code)) {

                $htmlContent = '<h1>Welcome to Deen.no</h1>';
                $htmlContent .= '<p>Click on the link below to activate to your account</p>';
                $htmlContent .= '<p><a href="'. base_url().'confirm-account/'.$secret_code.'">Confirm</a></p>';
                
                $this->email->to($this->input->post('email'));
                $this->email->from(EMAIL_FROM_SMTP, 'Deen');
                $this->email->subject('Deen account confirmation');
                $this->email->message($htmlContent);
                $this->email->send();
                
                $this->session->set_flashdata('signup_success', 'Account successfully created.');
                redirect('login');
            } else {
                
            }
        }
    }


}
