<?php



defined('BASEPATH') OR exit('No direct script access allowed');



class Signin extends CI_Controller {



    public function __construct() {



        


        parent::__construct();

            if($this->input->get('lang')){
               define('LANG', $this->input->get('lang'));
        }
        else{
            define('LANG', 'en');
        }

    


        if ($this->session->userdata('logged_in')) {



            redirect('dashboard');

        }

    }



    public function index() {



        $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');

        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[8]');

        if (!$this->form_validation->run()) {

            $data['main_view'] = LANG . "/public/login_view";

            $this->load->view(LANG . '/layouts/main', $data);

        } else {

            $email = $this->input->post('email');

            $password = $this->input->post('password');

            $this->load->model('user_model');

            if ($user = $this->user_model->login_user($email, $password)) {

                if ($user->active) {
                            // dd(LANG);
                    $userdata = array(

                        'user_id' => $user->user_id,

                        'first_name' => $user->first_name,

                        'last_name' => $user->last_name,

                        'no_of_children' => $user->no_of_children,

                        'plan' => $user->plan,

                        'logged_in' => true

                    );

                    $this->session->set_userdata($userdata);


                    if(LANG == 'no')    
                        redirect('dashboard?lang=no');
                    else
                        redirect('dashboard');

                } else {

                    $this->session->set_flashdata('no_access', 'Your account is not activated.');

                    redirect('login');

                }

            } else {

                $this->session->set_flashdata('no_access', 'Invalid Email / Password.');

                redirect('login');

            }

        }

    }



    public function forgot_password() {

        $email = $this->input->post('email');

        $this->load->model('user_model');

        if ($secret = $this->user_model->user_forgot_password($email)) {

            $htmlContent = '<h1>Deen.no Reset Password Request</h1>';

            $htmlContent .= '<p>Click on the link below to reset your password.</p>';

            $htmlContent .= '<p><a href="' . base_url() . 'reset-password/' . $secret . '">Reset Password</a></p>';

            

            $this->email->to($this->input->post('email'));

            $this->email->from(EMAIL_FROM_SMTP, 'Deen');

            $this->email->subject('Deen Reset Password Request');

            $this->email->message($htmlContent);

            $this->email->send();

            $this->session->set_flashdata('signup_success', 'Reset password link has been sent. Check your inbox.');

            redirect('login');

        } else {

            $this->session->set_flashdata('no_access', 'Invalid Email! Please try again.');

            redirect('forgot-password');

        }

    }



    public function reset_password() {

        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[8]');

        $this->form_validation->set_rules('cpassword', 'Confirm Password', 'matches[password]');

        if (!$this->form_validation->run()) {

            $data = array(

                'password' => form_error('password'),

                'cpassword' => form_error('cpassword')

            );

            $this->session->set_flashdata($data);

            redirect($_SERVER['HTTP_REFERER']);

        }

        $this->load->model('user_model');

        if ($this->user_model->user_reset_password($this->input->post('hash'))) {



            $this->session->set_flashdata('signup_success', 'Password reset successfully!');

            redirect('login');

        } else {

            $this->session->set_flashdata('no_access', 'Something went wrong! Please try again.');

            redirect($_SERVER['HTTP_REFERER']);

        }

    }



}

