<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

    public function __construct() {

        parent::__construct();

        if (!$this->session->userdata('admin_logged_in')) {

            redirect('admin');
        }
    }

    public function index() {
        $data['sidebar_menu'] = $this->content_model->getcategories();
        $data["page_title_header"] = "Dashboard";
        $data['userscount'] = $this->db->count_all('users');
        $data['mcqcount'] = $this->db->count_all('multiplechoice');
        $data['truefalsecount'] = $this->db->count_all('truefalse');
        $data['sequencecount'] = $this->db->count_all('sequence');
        $data['main_view'] = "admin/home_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function multiple_choice() {

        $data["page_title_header"] = "Multiple Choice Questions";
        $data['main_view'] = "admin/quiz/multiple_choice_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_multiple_choice() {

        $data["page_title_header"] = "Add Multiple Choice Question";
        $data['main_view'] = "admin/quiz/add_multiple_choice_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_multiple_choice_save() {
        $this->load->model('admin/admin_model');
        $this->admin_model->add_multiple_choice();
    }

    public function edit_multiple_choice() {
        $last = $this->uri->total_segments();
        $id = $this->uri->segment($last);
        if (is_numeric($id) && $data['ques'] = $this->content_model->get_question($id, 'multiplechoice')) {
            
        } else {
            redirect('admin/quiz/multiple-choice');
        }
        $data["page_title_header"] = "Edit Multiple Choice Question";
        $data['main_view'] = "admin/quiz/edit_multiple_choice_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function edit_multiple_choice_save() {
        $this->load->model('admin/admin_model');
        $this->admin_model->edit_multiple_choice();
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function delete_multiple_choice() {
        $this->load->model('admin/admin_model');
        $this->admin_model->delete_multiple_choice();
    }

    public function true_false() {

        $data["page_title_header"] = "True False Questions";
        $data['main_view'] = "admin/quiz/true_false_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_true_false() {

        $data["page_title_header"] = "Add True False Question";
        $data['main_view'] = "admin/quiz/add_true_false_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_true_false_save() {
        $this->load->model('admin/admin_model');
        $this->admin_model->add_true_false();
    }

    public function edit_true_false() {
        $last = $this->uri->total_segments();
        $id = $this->uri->segment($last);
        if (is_numeric($id) && $data['ques'] = $this->content_model->get_question($id, 'truefalse')) {
            
        } else {
            redirect('admin/quiz/multiple-choice');
        }
        $data["page_title_header"] = "Edit True False Question";
        $data['main_view'] = "admin/quiz/edit_true_false_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function edit_true_false_save() {
        $this->load->model('admin/admin_model');
        $this->admin_model->edit_true_false();
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function delete_true_false() {
        $this->load->model('admin/admin_model');
        $this->admin_model->delete_true_false();
    }

    public function sequence() {
        $data["page_title_header"] = "Organize in Correct Order Questions";
        $data['main_view'] = "admin/quiz/sequence_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_sequence() {
        $data["page_title_header"] = "Add Organize in Correct Order Question";
        $data['main_view'] = "admin/quiz/add_sequence_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_sequence_save() {
        $this->load->model('admin/admin_model');
        $this->admin_model->add_sequence();
    }

    public function edit_sequence() {
        $last = $this->uri->total_segments();
        $id = $this->uri->segment($last);
        if (is_numeric($id) && $data['ques'] = $this->content_model->get_question($id, 'sequence')) {
            
        } else {
            redirect('admin/quiz/multiple-choice');
        }
        $data["page_title_header"] = "Edit Organize in Correct Order Question";
        $data['main_view'] = "admin/quiz/edit_sequence_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function edit_sequence_save() {
        $this->load->model('admin/admin_model');
        $this->admin_model->edit_sequence();
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function delete_sequence() {
        $this->load->model('admin/admin_model');
        $this->admin_model->delete_sequence();
    }

    public function getcategories() {
        $school_id = $this->input->post('school_id');
        $cats = $this->content_model->get_categories($school_id);
        foreach ($cats as $cat) {
            echo '<option value="' . $cat->main_category_id . '">' . $cat->main_category_name . '</option>';
        }
    }

    public function getsubcategories() {
        $cat_id = $this->input->post('cat_id');
        $cats = $this->content_model->get_sub_categories($cat_id);
        foreach ($cats as $cat) {
            echo '<option value="' . $cat->category_id . '">' . $cat->category_name . '</option>';
        }
    }

    public function getquestionscount() {
        $school_id = $this->input->post('school_id');
        $cat_id = $this->input->post('cat_id');
        $subcat_id = $this->input->post('subcat_id');
        $quiz = $this->input->post('quiz');
        $count = $this->content_model->get_questions_count($school_id, $cat_id, $subcat_id, $quiz);
        $this->db->where('type', 'quiz');
        $limit = $this->db->get('counts')->row();
        if($limit->count > $count){
            echo TRUE;
        } else{
            echo FALSE;
        }
    }

    public function getquestions() {
        $school_id = $this->input->post('school_id');
        $cat_id = $this->input->post('cat_id');
        $subcat_id = $this->input->post('subcat_id');
        $quiz = $this->input->post('quiz');
        $result = $this->content_model->get_questions($school_id, $cat_id, $subcat_id, $quiz);
        echo json_encode($result);
    }

    public function add_sequances() {
        $st = array("1 statement", "2 statement", "3 statement", "4 statement"); //posted array
        $correct = "";
        $arr = array('stmt1', 'stmt2', 'stmt3', 'stmt4', 'stmt5', 'stmt6');
        $arr1 = array_slice($arr, 0, count($st));

        $new = array();
        foreach ($st as $r) {
            $val = array_rand($arr1, 1);
            $correct .= ($val + 1) . ',';
            $new[$arr1[$val]] = $r;
            unset($arr1[$val]);
        }
        $correct = trim($correct, ',');
        echo $correct . '<br><pre>';
        print_r($new);
    }

    public function get_users() {
        $this->load->model('admin/admin_model');
        $data["page_title_header"] = "Deen Users";
        $data['main_view'] = "admin/users_view";
        $data['users'] = $this->admin_model->get_users();
        $this->load->view('admin/layouts/main', $data);
    }

    public function changeuserstatus() {
        $this->load->model('admin/admin_model');
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $this->admin_model->change_user_status($id, $status);
    }

    public function changeadminstatus() {
        $this->load->model('admin/admin_model');
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $this->admin_model->change_admin_status($id, $status);
    }

    public function get_admins() {
        if (!$this->session->userdata('super_admin_logged_in')) {
            redirect('admin');
        }
        $this->load->model('admin/admin_model');
        $data["page_title_header"] = "Deen Admins";
        $data['main_view'] = "admin/admin_view";
        $data['admins'] = $this->admin_model->get_admins();
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_admin() {
        $data["page_title_header"] = "Add New Admin";
        $data['main_view'] = "admin/add_admin_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_admin_save() {
        $this->load->model('admin/admin_model');
        $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|is_unique[admin.email]');
        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[8]');
        if (!$this->form_validation->run()) {
            $this->session->set_flashdata('add_admin_fail', 'Email Already Exist.');
            $data["page_title_header"] = "Add New Admin";
            $data['main_view'] = "admin/add_admin_view";
            $this->load->view('admin/layouts/main', $data);
        } else {
            if ($this->admin_model->add_new_admin()) {
                $this->session->set_flashdata('add_admin_success', 'Account successfully created.');
            } else {
                $this->session->set_flashdata('add_admin_fail', 'Email Already Exist.');
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public function quran() {
        $this->load->model('admin/admin_model');
        $data["page_title_header"] = "Kindergarten Quran";
        $data['main_view'] = "admin/kindergarten/quran_view";
        $data['quran'] = $this->admin_model->get_quran();
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_quran() {
        $data["page_title_header"] = "Add New Surah";
        $data['main_view'] = "admin/kindergarten/add_quran_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function edit_quran($id) {
        $this->load->model('admin/admin_model');
        $last = $this->uri->total_segments();
        $id = $this->uri->segment($last);
        if (is_numeric($id) && $data['quran'] = $this->admin_model->get_surah($id)) {
            
        } else {
            redirect('admin/kindergarten/quran');
        }
        $data["page_title_header"] = "Edit " . $data['quran']->surah_name;
        $data['main_view'] = "admin/kindergarten/edit_quran_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_quran_save() {
        $config['upload_path'] = "./audios/surah/";
        $config['allowed_types'] = 'wav|aac|mp3|aiff|wma|ogg';
        $config['max_size'] = '999999999999';
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('surah_audio')) {
            
        }
        $this->load->model('admin/admin_model');

        if ($this->admin_model->add_quran_surah()) {
            $this->session->set_flashdata('success', '');
        } else {
            $this->session->set_flashdata('fail', '');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function edit_quran_save() {
        $config['upload_path'] = "./audios/surah/";
        $config['allowed_types'] = 'wav|aac|mp3|aiff|wma|ogg';
        $config['max_size'] = '999999999999';
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('surah_audio')) {
            
        }
        $this->load->model('admin/admin_model');

        if ($this->admin_model->edit_quran_surah()) {
            $this->session->set_flashdata('success', 'Surah updated successfully');
        } else {
            $this->session->set_flashdata('fail', '');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function changequranstatus() {
        $this->load->model('admin/admin_model');
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $this->admin_model->change_surah_status($id, $status);
    }

    public function islamic_manners() {
        $this->load->model('admin/admin_model');
        $data["page_title_header"] = "Kindergarten Islamic Manners";
        $data['main_view'] = "admin/kindergarten/islamic_manners_view";
        $data['manners'] = $this->admin_model->get_manners();
        $this->load->view('admin/layouts/main', $data);
    }

    public function edit_islamic_manners() {
        $this->load->model('admin/admin_model');
        $last = $this->uri->total_segments();
        $id = $this->uri->segment($last);
        if (is_numeric($id) && $data['manners'] = $this->admin_model->get_manner($id)) {
            
        } else {
            redirect('admin/kindergarten/islamic-manners');
        }
        $data["page_title_header"] = "Edit Islamic Manners";
        $data['main_view'] = "admin/kindergarten/edit_islamic_manners_view";
        $data['categories'] = $this->content_model->get_categories('0');
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_islamic_manners() {
        $data["page_title_header"] = "Add New Islamic Manner";
        $data['categories'] = $this->content_model->get_categories('0');
        $data['main_view'] = "admin/kindergarten/add_islamic_manners_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_islamic_manners_save() {
        $config['upload_path'] = "./images/islamic-manners/";
        $config['allowed_types'] = 'jpg|jpeg|png|gif';
        $config['max_size'] = '9999999';
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('manners_image')) {
            
        }
        $this->load->model('admin/admin_model');

        if ($this->admin_model->add_islamic_manner()) {
            $this->session->set_flashdata('success', '');
        } else {
            $this->session->set_flashdata('fail', '');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function edit_islamic_manners_save() {
        $config['upload_path'] = "./images/islamic-manners/";
        $config['allowed_types'] = 'jpg|jpeg|png|gif';
        $config['max_size'] = '9999999';
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('manners_image')) {
            
        }
        $this->load->model('admin/admin_model');

        $this->admin_model->edit_islamic_manner();
        $this->session->set_flashdata('success', ' ');
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function prayers() {
        $this->load->model('admin/admin_model');
        $data["page_title_header"] = "Kindergarten Dua / Prayers";
        $data['main_view'] = "admin/kindergarten/prayers_view";
        $data['prayers'] = $this->admin_model->get_prayers();
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_prayers() {
        $data["page_title_header"] = "Add New Prayer";
        $data['categories'] = $this->content_model->get_categories('0');
        $data['main_view'] = "admin/kindergarten/add_prayers_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function edit_prayers() {
        $this->load->model('admin/admin_model');
        $last = $this->uri->total_segments();
        $id = $this->uri->segment($last);
        if (is_numeric($id) && $data['prayers'] = $this->admin_model->get_prayer($id)) {
            
        } else {
            redirect('admin/kindergarten/prayers');
        }
        $data["page_title_header"] = "Edit Prayer";
        $data['main_view'] = "admin/kindergarten/edit_prayers_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_prayers_save() {
        $config['upload_path'] = "./audios/prayers/";
        $config['allowed_types'] = 'wav|aac|mp3|aiff|wma|ogg';
        $config['max_size'] = '999999999999';
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('audio')) {
            
        }
        $this->load->model('admin/admin_model');

        if ($this->admin_model->add_prayers()) {
            $this->session->set_flashdata('success', '');
        } else {
            $this->session->set_flashdata('fail', '');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function edit_prayers_save() {
        $config['upload_path'] = "./audios/prayers/";
        $config['allowed_types'] = 'wav|aac|mp3|aiff|wma|ogg';
        $config['max_size'] = '999999999999';
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('audio')) {
            
        }
        $this->load->model('admin/admin_model');

        if ($this->admin_model->edit_prayers()) {
            $this->session->set_flashdata('success', ' ');
        } else {
            $this->session->set_flashdata('fail', ' ');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function islamic_words() {
        $this->load->model('admin/admin_model');
        $data["page_title_header"] = "Kindergarten Islamic Words";
        $data['main_view'] = "admin/kindergarten/islamic_words_view";
        $data['words'] = $this->admin_model->get_islamic_words();
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_islamic_words() {
        $data["page_title_header"] = "Add New Islamic Word";
        $data['categories'] = $this->content_model->get_sub_categories('0');
        $data['main_view'] = "admin/kindergarten/add_islamic_words_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_islamic_words_save() {
        $config['upload_path'] = "./images/islamic-words/";
        $config['allowed_types'] = 'jpg|jpeg|png|gif';
        $config['max_size'] = '9999999';
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('image')) {
            
        }
        $this->load->model('admin/admin_model');

        if ($this->admin_model->add_islamic_words()) {
            $this->session->set_flashdata('success', '');
        } else {
            $this->session->set_flashdata('fail', '');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function edit_islamic_words($id) {
        $this->load->model('admin/admin_model');
        $last = $this->uri->total_segments();
        $id = $this->uri->segment($last);
        if (is_numeric($id) && $data['words'] = $this->admin_model->get_islamic_word($id)) {
            
        } else {
            redirect('admin/kindergarten/islamic-words');
        }
        $data['categories'] = $this->content_model->get_sub_categories('0');
        $data["page_title_header"] = "Edit Islamic Word";
        $data['main_view'] = "admin/kindergarten/edit_islamic_words_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function edit_islamic_words_save() {
        $config['upload_path'] = "./images/islamic-words/";
        $config['allowed_types'] = 'jpg|jpeg|png|gif';
        $config['max_size'] = '9999999';
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('image')) {
            
        }
        $this->load->model('admin/admin_model');

        $this->admin_model->edit_islamic_words();
        $this->session->set_flashdata('success', ' ');
        redirect($_SERVER['HTTP_REFERER']);
    }
    
    public function drawing() {
        $data["page_title_header"] = "Drawings";
        $data['drawings'] = $this->db->get('drawings');
        $data['main_view'] = "admin/kindergarten/drawing_view";
        $this->load->view('admin/layouts/main', $data);
    }
    
    public function drawing_save() {
        $config['upload_path'] = "./images/drawing/";
        $config['allowed_types'] = 'jpg|jpeg|png|gif';
        $config['max_size'] = '9999999';
        $this->upload->initialize($config);
        foreach ($_FILES as $key => $value) {
            if(!$this->upload->do_upload($key)){
                
            }
        }
        $this->load->model('admin/admin_model');

        if ($this->admin_model->update_drawings()) {
            $this->session->set_flashdata('success', '');
        } else {
            $this->session->set_flashdata('fail', '');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    
    public function crossword() {

        $data["page_title_header"] = "Crosswords";
        $data['main_view'] = "admin/quiz/crossword_view";
        $this->load->view('admin/layouts/main', $data);
    }
    
    public function getcrosswordcount() {
        $school_id = $this->input->post('school_id');
        $cat_id = $this->input->post('cat_id');
        $subcat_id = $this->input->post('subcat_id');
        $this->db->where('school_id',$school_id);
        $this->db->where('main_category_id',$cat_id);
        $this->db->where('category_id',$subcat_id);
        $total = $this->db->from('crossword')->count_all_results();
        if($total){
            $result = $this->content_model->get_crossword($school_id, $cat_id, $subcat_id);
            $result->hints = $this->content_model->getcrossword_hints($result->id);
            echo json_encode($result);
        } else{
            echo FALSE;
        }
    }
    
    public function add_crossword() {
        $data["page_title_header"] = "Add Crossword";
        $data['main_view'] = "admin/quiz/add_crossword_view";
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_crossword_save() {
        // dd($this->input->post());
        $this->load->model('admin/admin_model');
        $this->admin_model->add_crossword();
    }
    
    public function getcrossword() {
        $school_id = $this->input->post('school_id');
        $cat_id = $this->input->post('cat_id');
        $subcat_id = $this->input->post('subcat_id');
        $result = $this->content_model->get_crossword($school_id, $cat_id, $subcat_id);
        echo json_encode($result);
    }
    
    public function deletecrossword() {
        $this->load->model('admin/admin_model');
        $id = $this->input->post('id');
        $this->admin_model->delete_crossword($id);
    }

}
