<?php



defined('BASEPATH') OR exit('No direct script access allowed');



class Signin extends CI_Controller {



    public function __construct() {



        parent::__construct();



        if ($this->session->userdata('admin_logged_in')) {



            redirect('admin/dashboard');

        }

    }



    public function index() {

        $data["page_title"] = "Deen - Admin Panel";

        $data['main_view'] = "admin/login_view";

        $this->load->view('admin/login_view', $data);

    }

    

    public function signin() {



        $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');

        $this->form_validation->set_rules('password', 'Password', 'trim|required');

        if (!$this->form_validation->run()) {

            $data["page_title"] = "Deen - Admin Panel";

            $this->load->view('admin/login_view', $data);

        } else {

            $email = $this->input->post('email');

            $password = $this->input->post('password');

            $this->load->model('admin/admin_model');

            if ($admin = $this->admin_model->login_user($email, $password)) {

                

                    $userdata = array(

                        'admin_id' => $admin->admin_id,

                        'name' => $admin->name,

                        'admin_logged_in' => true,

                        'super_admin_logged_in' => $admin->type

                    );

                    $this->session->set_userdata($userdata);



                    redirect('admin/dashboard');

            } else {

                $this->session->set_flashdata('no_admin_access', 'Invalid Email / Password.');

                redirect('admin');

            }

        }

    }



    public function forgot_password() {

        $email = $this->input->post('email');

        $this->load->model('user_model');

        if ($secret = $this->user_model->user_forgot_password($email)) {

            $htmlContent = '<h1>Deen.no Reset Password Request</h1>';

            $htmlContent .= '<p>Click on the link below to reset your password.</p>';

            $htmlContent .= '<p><a href="' . base_url() . 'reset-password/' . $secret . '">Reset Password</a></p>';

            

            $this->email->to($this->input->post('email'));

            $this->email->from(EMAIL_FROM_SMTP, 'Deen');

            $this->email->subject('Deen Reset Password Request');

            $this->email->message($htmlContent);

            $this->email->send();

            $this->session->set_flashdata('signup_success', 'Reset password link has been sent. Check your inbox.');

            redirect('login');

        } else {

            $this->session->set_flashdata('no_access', 'Invalid Email! Please try again.');

            redirect('forgot-password');

        }

    }



    public function reset_password() {

        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[8]');

        $this->form_validation->set_rules('cpassword', 'Confirm Password', 'matches[password]');

        if (!$this->form_validation->run()) {

            $data = array(

                'password' => form_error('password'),

                'cpassword' => form_error('cpassword')

            );

            $this->session->set_flashdata($data);

            redirect($_SERVER['HTTP_REFERER']);

        }

        $this->load->model('user_model');

        if ($this->user_model->user_reset_password($this->input->post('hash'))) {



            $this->session->set_flashdata('signup_success', 'Password reset successfully!');

            redirect('login');

        } else {

            $this->session->set_flashdata('no_access', 'Something went wrong! Please try again.');

            redirect($_SERVER['HTTP_REFERER']);

        }

    }



}

