<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Content extends CI_Controller {

    public function __construct() {

        parent::__construct();

        if (!$this->session->userdata('admin_logged_in')) {

            redirect('admin');
        }
    }

    public function index() {
        $data['sidebar_menu'] = $this->content_model->getcategories();
        $data['main_view'] = "admin/content/primary_school_home_view";
        $this->load->view('admin/layouts/main', $data);
    }

    protected function do_upload() {

        if (!$this->upload->do_upload('primary_category_image_1')) {
             $error = array('error' => $this->upload->display_errors());
        } else {
            $data = array('upload_data' => $this->upload->data());
        }
    }

    public function primary_school_home() {
        $data['sidebar_menu'] = $this->content_model->getcategories();
        $data['content'] = $this->content_model->get_view_content('primary-school-home');
        $data["page_title_header"] = "Primary School Home Content";
        $data['main_view'] = "admin/content/primary_school_home_view";
        $this->load->view('admin/layouts/main', $data);
    }
    
    public function primary_school_home_save() {
        foreach ($_FILES as $key => $value) {
            if(!$this->upload->do_upload($key)){
                
            }
        }
            $this->load->model('admin/admin_model');
            
            $this->admin_model->update_content('primary-school-home');
            redirect($_SERVER['HTTP_REFERER']);
    }

    public function home_page() {
        $data['sidebar_menu'] = $this->content_model->getcategories();
        $data['content'] = $this->content_model->get_view_content('home-page');
        
        $data["page_title_header"] = "Home Page Content";
        $data['main_view'] = "admin/content/home_page_view";
        $this->load->view('admin/layouts/main', $data);
    }
    
    public function home_page_save() {
        foreach ($_FILES as $key => $value) {
            if(!$this->upload->do_upload($key)){
                
            }
        }
            $this->load->model('admin/admin_model');
            
            $this->admin_model->update_content('home-page');
            redirect($_SERVER['HTTP_REFERER']);
    }
    
    public function about_page() {
        $data['sidebar_menu'] = $this->content_model->getcategories();
        $data['content'] = $this->content_model->get_view_content('about-page');
        
        $data["page_title_header"] = "About Page Content";
        $data['main_view'] = "admin/content/about_page_view";
        $this->load->view('admin/layouts/main', $data);
    }
    
    public function about_page_save() {
        foreach ($_FILES as $key => $value) {
            if(!$this->upload->do_upload($key)){
                
            }
        }
            $this->load->model('admin/admin_model');
            
            $this->admin_model->update_content('about-page');
            redirect($_SERVER['HTTP_REFERER']);
    }
    
    public function contact_page() {
        $data['sidebar_menu'] = $this->content_model->getcategories();
        $data['content'] = $this->content_model->get_view_content('contact-page');
        $data["page_title_header"] = "Contact Us Page Content";
        $data['main_view'] = "admin/content/contact_page_view";
        $this->load->view('admin/layouts/main', $data);
    }
    
    public function contact_page_save() {
        foreach ($_FILES as $key => $value) {
            if(!$this->upload->do_upload($key)){
                
            }
        }
            $this->load->model('admin/admin_model');
            
            $this->admin_model->update_content('contact-page');
            redirect($_SERVER['HTTP_REFERER']);
    }
    
    public function membership_plan() {
        $data['sidebar_menu'] = $this->content_model->getcategories();
        $data['content'] = $this->content_model->get_view_content('membership-plan');
        $data["page_title_header"] = "Membership Plans Page Content";
        $data['main_view'] = "admin/content/membership_plan_view";
        $this->load->view('admin/layouts/main', $data);
    }
    
    public function membership_plan_save() {
        foreach ($_FILES as $key => $value) {
            if(!$this->upload->do_upload($key)){
                
            }
        }
            $this->load->model('admin/admin_model');
            
            $this->admin_model->update_content('membership-plan');
            redirect($_SERVER['HTTP_REFERER']);
    }
    
    public function videos() {
        $data['sidebar_menu'] = $this->content_model->getcategories();
        $data['videos'] = $this->content_model->get_view_videos();
        $data["page_title_header"] = "Content Videos";
        $data['main_view'] = "admin/content/videos_view";
        $this->load->view('admin/layouts/main', $data);
    }
    
    public function videos_edit($id) {
        $last = $this->uri->total_segments();
        $id = $this->uri->segment($last);
        if (is_numeric($id) && $data['video'] = $this->content_model->get_view_video($id)) {
            
        } else {
            redirect('admin/content/video');
        }
        $data["page_title_header"] = "Edit " . $data['video']->page_detail . " " . $data['video']->video_title ." Video";
        $data['main_view'] = "admin/content/video_edit_view";
        $this->load->view('admin/layouts/main', $data);
    }
    
    public function edit_video_save() {
        $config['upload_path'] = "./videos/";
        $config['allowed_types'] = 'mp4|WebM|ogg';
        $config['max_size'] = '9999999999999999';
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('video')) {
            
        }

        if ($this->content_model->edit_view_video()) {
            $this->session->set_flashdata('success', ' ');
        } else {
            $this->session->set_flashdata('fail', ' ');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

}
