<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
if (!function_exists('active_menu')) {

    function active_menu($uri = '', $css = '', $active = FALSE) {
        $class = "current";
        if ($active) {
            $class = "active";
        }
        if (!is_array($uri)) {
            $site_url = (!preg_match('!^\w+://! i', $uri)) ? site_url($uri) : $uri;
        } else {
            $site_url = site_url($uri);
        }

        $current_url = (!empty($_SERVER['HTTPS'])) ? "https://" . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'] : "http://" . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];

        return ($site_url == $current_url) ? ' class=" ' . $class . ' ' . $css . '"' : ' class="' . $css . '"';
    }

    function admin_active_menu($segs = array(), $uri = '') {

        if (in_array($uri, $segs)) {
            return 'active';
        }
    }

    function admin_active_sub_menu($segs, $main_uri, $uri = '') {
        if (in_array($uri, $segs) && in_array($main_uri, $segs)) {
            return 'active';
        }
    }

    function kindergarten_active_menu($segs) {
        $urls = array('islamicmanners', 'islamicwords', 'quran', 'prayers');
        foreach ($urls as $value) {
            if (in_array($value, $segs)) {
                return 'show';
                die;
            }
        }
    }

    function quiz_active_menu($segs) {
        $urls = array('truefalse', 'multiple-choice', 'sequence');
        foreach ($urls as $value) {
            if (in_array($value, $segs)) {
                return 'show';
                die;
            }
        }
    }

}
?>