<?php



class Content_model extends CI_model {



    public function get_view_content($page) {

        $this->db->where('page', $page);

        $result = $this->db->get('content');

        // dd($result->result());

        return $result;

    }



    public function getcategories() {

        $this->db->select('*');

        $this->db->from('main_category');

        $this->db->join('quiz_category', 'main_category.main_category_id=quiz_category.main_category_id');

        $query = $this->db->get();

        return $query->result();

    }



    public function getquiztitle($category_id) {

        $this->db->select('main_category.main_category_name, quiz_category.category_name, school.school_name');

        $this->db->from('main_category');

        $this->db->join('quiz_category', 'main_category.main_category_id=quiz_category.main_category_id');

        $this->db->join('school', 'school.school_id=main_category.school_id');

        $this->db->where('quiz_category.category_id', $category_id);

        $this->db->limit('1');

        $query = $this->db->get();

        return $query->result();

    }



    public function get_categories($scool_id) {

        $this->db->select('*');

        $this->db->from('main_category');

        $this->db->where('school_id', $scool_id);

        $query = $this->db->get();

        return $query->result();

    }



    public function get_sub_categories($cat_id) {

        $this->db->select('*');

        $this->db->from('quiz_category');

        $this->db->where('main_category_id', $cat_id);

        $query = $this->db->get();
// dd($query->result());
        return $query->result();

    }

    

    public function get_main_category_name($id) {

        $this->db->select('main_category_name');

        $this->db->from('main_category');

        $this->db->where('main_category_id', $id);

        $query = $this->db->get()->row();

        return $query->main_category_name;

    }



    public function get_questions_count($school_id, $cat_id, $subcat_id, $quiz) {

        $this->db->select('count(id) as total');

        $this->db->from($quiz);

        $this->db->where('school_id', $school_id);

        $this->db->where('main_category_id', $cat_id);

        $this->db->where('category_id', $subcat_id);

        $query = $this->db->get();

        $c = $query->row();

        return $c->total;

    }



    public function get_questions($school_id, $cat_id, $subcat_id, $quiz) {

        $this->db->select('*');

        $this->db->from($quiz);

        $this->db->where('school_id', $school_id);

        $this->db->where('main_category_id', $cat_id);

        $this->db->where('category_id', $subcat_id);

        $query = $this->db->get();

        return $query->result();

    }



    public function get_question($id, $quiz) {

        $this->db->select('*');

        $this->db->from($quiz);

        $this->db->where('id', $id);

        return $this->db->get()->row();

    }



    public function get_quran() {

        $this->db->select('*');

        $this->db->from('quran');

        return $this->db->get()->result();

    }



    public function get_islamic_words() {

        $this->db->select('*');

        $this->db->from('islamicwords');

        return $this->db->get()->result();

    }



    public function get_prayers() {

        $this->db->select('*');

        $this->db->from('prayers');

        return $this->db->get()->result();

    }



    public function get_manners() {

        $this->db->select('*');

        $this->db->from('islamicmanners');

        $this->db->join('main_category', 'main_category.main_category_id = islamicmanners.main_category_id');

        return $this->db->get()->result();

    }



    public function get_view_videos($page = '') {

        if ($page != '') {

            $this->db->where('page', $page);

        }

        $result = $this->db->get('videos')->result();

        return $result;

    }



    public function get_view_video($id) {

        $this->db->where('id',$id);

        $result = $this->db->get('videos')->row();

        return $result;

    }



    public function edit_view_video() {

        $data = array(

            'video' => $this->input->post('video_name')

        );

        $this->db->where('id', $this->input->post('id'));

        return $this->db->update('videos', $data);

        

    }

    

    public function get_crossword($school_id, $cat_id, $subcat_id) {

        $this->db->select('*');

        $this->db->from('crossword');

        $this->db->where('school_id', $school_id);

        $this->db->where('main_category_id', $cat_id);

        $this->db->where('category_id', $subcat_id);

        $query = $this->db->get();

        return $query->row();

    }

    

    public function getcrossword_hints($id) {

        $this->db->where('crossword_id', $id);

        $query = $this->db->get('crossword_hint');

        return $query->result();

    }



}



?>