<?php

class User_model extends CI_model {

    public function create_user($secret_code) {
        $options = ['cost' => 10];
        $encrypted_pass = password_hash($this->input->post('password'), PASSWORD_BCRYPT, $options);
        
        $data = array(
            'email' => $this->input->post('email'),
            'title' => $this->input->post('title'),
            'first_name' => $this->input->post('first_name'),
            'last_name' => $this->input->post('last_name'),
            'no_of_children' => $this->input->post('no_of_children'),
            'plan' => $this->input->post('plan'),
            'price_per_child' => $this->input->post('price_per_child'),
            'base_price' => $this->input->post('base_price'),
            'total_price' => $this->input->post('total'),
            'password' => $encrypted_pass,
            'secret_code' => $secret_code
        );

        return $this->db->insert('users', $data);
    }

    public function login_user($email, $password) {
        $this->db->where('email', $email);
        $result = $this->db->get('users');
        if ($result->num_rows()) {
            $db_password = $result->row(1)->password;

            if (password_verify($password, $db_password)) {
                return $result->row();
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function user_confirmation($secret_code) {
        $this->db->where('secret_code', $secret_code);
        $result = $this->db->get('users');
        if ($result->num_rows()) {
            $this->db->where('secret_code', $secret_code);
            $data = array(
                'secret_code' => '',
                'active' => 1
            );
            $this->db->update('users',$data);
        
            return TRUE;
        }
        else{
            return FALSE;
        }
    }
    

    public function user_forgot_password($email) {
        $this->db->where('email', $email);
        $result = $this->db->get('users');
        if ($result->num_rows()) {
            $secret_code = random_string('sha1');
            $data = array(
                    'secret_code' => $secret_code
                );
            $this->db->where('email', $email);
            $this->db->update('users',$data);
        
            return $secret_code;
        }
        else{
            return FALSE;
        }
    }
    
    public function user_check_secret_code($secret) {
        $this->db->where('secret_code', $secret);
        $result = $this->db->get('users');
        if ($result->num_rows()) {
            return TRUE;
        }
        else{
            return FALSE;
        }
    }
    
    public function user_reset_password($secret) {
        $options = ['cost' => 10];
        $encrypted_pass = password_hash($this->input->post('password'), PASSWORD_BCRYPT, $options);
        $data = array(
            'password' => $encrypted_pass,
            'secret_code' => ''
        );
        $this->db->where('secret_code', $secret);
        $this->db->update('users',$data);
        return $this->db->affected_rows();
    }

    public function update_package(){
        // dd($this->session->userdata());
        $data =  [

            'no_of_children' => $this->input->post('no_of_children'),
            'plan' => $this->input->post('plan')
        ];

        $this->db->where('user_id' , $this->session->userdata('user_id'));
        $this->db->update('users' , $data);
         if($this->db->affected_rows() == 1){
            $this->session->set_userdata('no_of_children' , $this->input->post('no_of_children'));
            $this->session->set_userdata('plan' , $this->input->post('plan'));
            return true;
        }
        else{
            return false;
        }

    }

    
    
}

?>