<?php

class Admin_model extends CI_model {

    public function login_user($email, $password) {
        $this->db->where('email', $email);
        $result = $this->db->get('admin');
        if ($result->num_rows()) {
            $db_password = $result->row(1)->password;

            if (password_verify($password, $db_password)) {
                return $result->row();
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function user_forgot_password($email) {
        $this->db->where('email', $email);
        $result = $this->db->get('users');
        if ($result->num_rows()) {
            $secret_code = random_string('sha1');
            $data = array(
                'secret_code' => $secret_code
            );
            $this->db->where('email', $email);
            $this->db->update('users', $data);

            return $secret_code;
        } else {
            return FALSE;
        }
    }

    public function user_check_secret_code($secret) {
        $this->db->where('secret_code', $secret);
        $result = $this->db->get('users');
        if ($result->num_rows()) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function user_reset_password($secret) {
        $options = ['cost' => 10];
        $encrypted_pass = password_hash($this->input->post('password'), PASSWORD_BCRYPT, $options);
        $data = array(
            'password' => $encrypted_pass,
            'secret_code' => ''
        );
        $this->db->where('secret_code', $secret);
        $this->db->update('users', $data);
        return $this->db->affected_rows();
    }

    /////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////   Content Functions   //////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////

    public function update_content($page) {

        $data = array();
        foreach ($_POST as $key => $value) {
            if ($value != "") {
                $new = array(
                    'name' => $key,
                    'value' => $value
                );
                array_push($data, $new);
            }
        }
        foreach ($_FILES as $key => $value) {
            if ($value['name'] != '') {
                $newimages = array(
                    'name' => $key,
                    'value' => $value['name']
                );
                array_push($data, $newimages);
            }
        }
        $this->db->where('page', $page);
        $this->db->update_batch('content', $data, 'name');
    }

    public function edit_multiple_choice() {
        $data = array(
            'question' => $this->input->post('question'),
            'opt1' => $this->input->post('opt1'),
            'opt2' => $this->input->post('opt2'),
            'opt3' => $this->input->post('opt3'),
            'opt4' => $this->input->post('opt4'),
            'answer' => $this->input->post($this->input->post('answer')),

            'question_no' => $this->input->post('question_no'),
            'opt1_no' => $this->input->post('opt1_no'),
            'opt2_no' => $this->input->post('opt2_no'),
            'opt3_no' => $this->input->post('opt3_no'),
            'opt4_no' => $this->input->post('opt4_no'),
            'answer_no' => $this->input->post($this->input->post('answer_no')),

        );
        $this->db->where('id', $this->input->post('id'));
        $this->db->update('multiplechoice', $data);
    }

    public function add_multiple_choice() {

        // dd($this->input->post());

        $data = array(
            'question' => $this->input->post('question'),
            'opt1' => $this->input->post('opt1'),
            'opt2' => $this->input->post('opt2'),
            'opt3' => $this->input->post('opt3'),
            'opt4' => $this->input->post('opt4'),
            'answer' => $this->input->post($this->input->post('answer')),

            'question_no' => $this->input->post('question_no'),
            'opt1_no' => $this->input->post('opt1_no'),
            'opt2_no' => $this->input->post('opt2_no'),
            'opt3_no' => $this->input->post('opt3_no'),
            'opt4_no' => $this->input->post('opt4_no'),
            'answer_no' => $this->input->post($this->input->post('answer_no')),


            'school_id' => $this->input->post('school_id'),
            'main_category_id' => $this->input->post('main_category_id'),
            'category_id' => $this->input->post('category_id'),
        );
        $this->db->insert('multiplechoice', $data);
    }

    public function delete_multiple_choice() {
        $this->db->where('id', $this->input->post('id'));
        $this->db->delete('multiplechoice');
    }

    public function edit_true_false() {
        $data = array(
            'question' => $this->input->post('question'),
            'answer' => $this->input->post('answer'),
        );
        $this->db->where('id', $this->input->post('id'));
        $this->db->update('truefalse', $data);
    }

    public function add_true_false() {
        $data = array(
            'question' => $this->input->post('question'),
            'question_no' => $this->input->post('question_no'),
            'answer' => $this->input->post('answer'),
            'school_id' => $this->input->post('school_id'),
            'main_category_id' => $this->input->post('main_category_id'),
            'category_id' => $this->input->post('category_id'),
        );
        $this->db->insert('truefalse', $data);
    }

    public function delete_true_false() {
        $this->db->where('id', $this->input->post('id'));
        $this->db->delete('truefalse');
    }

    public function edit_sequence() {

        $st = array_filter($this->input->post('stmt'), 'strlen'); //posted array
        $st_no = array_filter($this->input->post('stmt_no'), 'strlen'); //posted array
        $correct = "";
        $correct_no = "";
        $arr = array('stmt1', 'stmt2', 'stmt3', 'stmt4', 'stmt5', 'stmt6');
        $arr_no = array('stmt1_no', 'stmt2_no', 'stmt3_no', 'stmt4_no', 'stmt5_no', 'stmt6_no');
        $arr1 = array_slice($arr, 0, count($st));
        $arr1_no = array_slice($arr_no, 0, count($st_no));

        $new = array();
        foreach ($st as $r) {
            $val = array_rand($arr1, 1);
            $correct .= ($val + 1) . ',';
            $new[$arr1[$val]] = $r;
            unset($arr1[$val]);
        }
        foreach ($st_no as $r_no) {
            $val_no = array_rand($arr1_no, 1);
            $correct_no .= ($val_no + 1) . ',';
            $new[$arr1_no[$val_no]] = $r_no;
            unset($arr1_no[$val_no]);
        }
        $new['sorder'] = trim($correct, ',');
        $new['sorder_no'] = trim($correct_no, ',');
        $this->db->where('id', $this->input->post('id'));
        $this->db->update('sequence', $new);

    }

    public function add_sequence() {

        $st = array_filter($this->input->post('stmt'), 'strlen'); //posted array
        $st_no = array_filter($this->input->post('stmt_no'), 'strlen'); //posted array
        $correct = "";
        $correct_no = "";
        $arr = array('stmt1', 'stmt2', 'stmt3', 'stmt4', 'stmt5', 'stmt6');
        $arr_no = array('stmt1_no', 'stmt2_no', 'stmt3_no', 'stmt4_no', 'stmt5_no', 'stmt6_no');
        $arr1 = array_slice($arr, 0, count($st));
        $arr1_no = array_slice($arr_no, 0, count($st_no));

        $new = array();
        foreach ($st as $r) {
            $val = array_rand($arr1, 1);
            $correct .= ($val + 1) . ',';
            $new[$arr1[$val]] = $r;
            unset($arr1[$val]);
        }

        foreach ($st_no as $r_no) {
            $val_no = array_rand($arr1_no, 1);
            $correct_no .= ($val_no + 1) . ',';
            $new[$arr1_no[$val_no]] = $r_no;
            unset($arr1_no[$val_no]);
        }
        $new['sorder'] = trim($correct, ',');
        $new['sorder_no'] = trim($correct_no, ',');
        $new['school_id'] = $this->input->post('school_id');
        $new['main_category_id'] = $this->input->post('main_category_id');
        $new['category_id'] = $this->input->post('category_id');

        $this->db->insert('sequence', $new);
    }

    public function delete_sequence() {
        $this->db->where('id', $this->input->post('id'));
        $this->db->delete('sequence');
    }

    public function get_users() {
        return $this->db->get('users')->result();
    }

    public function get_admins() {
        return $this->db->where('type', '0')->get('admin')->result();
    }

    public function change_user_status($id, $status) {
        if ($status == '0') {
            $newstatus = 1;
        } else {
            $newstatus = 0;
        }
        $data = array(
            'active' => $newstatus
        );
        $this->db->where('user_id', $this->input->post('id'));
        $this->db->update('users', $data);
    }

    public function change_admin_status($id, $status) {
        if ($status == '0') {
            $newstatus = 1;
        } else {
            $newstatus = 0;
        }
        $data = array(
            'active' => $newstatus
        );
        $this->db->where('admin_id', $this->input->post('id'));
        $this->db->update('admin', $data);
    }

    public function add_new_admin() {
        $secret_code = random_string('sha1');
        $options = ['cost' => 10];
        $encrypted_pass = password_hash($this->input->post('password'), PASSWORD_BCRYPT, $options);
        $data = array(
            'email' => $this->input->post('email'),
            'name' => $this->input->post('name'),
            'password' => $encrypted_pass,
            'secret_code' => $secret_code
        );
        return $this->db->insert('admin', $data);
    }

    public function get_quran() {
        return $this->db->get('quran')->result();
    }

    public function get_surah($id) {
        $this->db->where('id', $id);
        return $this->db->get('quran')->row();
    }

    public function add_quran_surah() {
        $data = array(
            'surah_name' => $this->input->post('surah_name'),
            'surah_text' => $this->input->post('surah_text'),
            'surah_audio' => $this->input->post('surah_audio_name')
        );
        return $this->db->insert('quran', $data);
    }

    public function edit_quran_surah() {
        $data = array(
            'surah_name' => $this->input->post('surah_name'),
            'surah_text' => $this->input->post('surah_text'),
            'surah_audio' => $this->input->post('surah_audio_name')
        );
        $this->db->where('id', $this->input->post('id'));
        return $this->db->update('quran', $data);
    }

    public function change_surah_status($id, $status) {
        if ($status == '0') {
            $newstatus = 1;
        } else {
            $newstatus = 0;
        }
        $data = array(
            'active' => $newstatus
        );
        $this->db->where('id', $this->input->post('id'));
        $this->db->update('quran', $data);
    }

    public function get_islamic_words() {
        $this->db->select('*');
        $this->db->from('islamicwords');
        $this->db->join('quiz_category', 'quiz_category.category_id = islamicwords.category_id');
        return $this->db->get()->result();
    }

    public function get_islamic_word($id) {
        $this->db->select('*');
        $this->db->from('islamicwords');
        $this->db->join('quiz_category', 'quiz_category.category_id = islamicwords.category_id');
        $this->db->where('id', $id);
        return $this->db->get()->row();
    }

    public function add_islamic_words() {
        $data = array(
            'islamicword' => $this->input->post('islamicword'),
            'image' => $this->input->post('image_name'),
            'category_id' => $this->input->post('category_id')
        );
        return $this->db->insert('islamicwords', $data);
    }

    public function edit_islamic_words() {
        $data = array(
            'islamicword' => $this->input->post('islamicword'),
            'image' => $this->input->post('image_name'),
            'category_id' => $this->input->post('category_id')
        );
        $this->db->where('id', $this->input->post('id'));
        return $this->db->update('islamicwords', $data);
    }

    public function get_manners() {
        $this->db->select('*');
        $this->db->from('islamicmanners');
        $this->db->join('main_category', 'main_category.main_category_id = islamicmanners.main_category_id');
        return $this->db->get()->result();
    }

    public function get_manner($id) {
        $this->db->select('*');
        $this->db->from('islamicmanners');
        $this->db->join('main_category', 'main_category.main_category_id = islamicmanners.main_category_id');
        $this->db->where('id', $id);
        return $this->db->get()->row();
    }

    public function add_islamic_manner() {
        $data = array(
            'manners_title' => $this->input->post('manners_title'),
            'manners_text' => $this->input->post('manners_text'),
            'manners_image' => $this->input->post('manners_image_name'),
            'main_category_id' => $this->input->post('main_category_id')
        );
        return $this->db->insert('islamicmanners', $data);
    }

    public function edit_islamic_manner() {
        $data = array(
            'manners_title' => $this->input->post('manners_title'),
            'manners_text' => $this->input->post('manners_text'),
            'manners_title_no' => $this->input->post('manners_title_no'),
            'manners_text_no' => $this->input->post('manners_text_no'),
            'manners_image' => $this->input->post('manners_image_name'),
            'main_category_id' => $this->input->post('main_category_id')
        );
        $this->db->where('id', $this->input->post('id'));
        return $this->db->update('islamicmanners', $data);
    }

    public function get_prayers() {
        return $this->db->get('prayers')->result();
    }

    public function get_prayer($id) {
        $this->db->where('id', $id);
        return $this->db->get('prayers')->row();
    }

    public function add_prayers() {
        $data = array(
            'prayer' => $this->input->post('prayer'),
            'audio' => $this->input->post('audio_name')
        );
        return $this->db->insert('prayers', $data);
    }

    public function edit_prayers() {
        $data = array(
            'prayer' => $this->input->post('prayer'),
            'audio' => $this->input->post('audio_name')
        );
        $this->db->where('id', $this->input->post('id'));
        return $this->db->update('prayers', $data);
    }

    public function update_drawings() {
        $data = array();
        foreach ($_FILES as $key => $value) {
            if ($value['name'] != '') {
                $data[] = array(
                    'name' => $key,
                    'value' => $value['name']
                );
            }
        }
        $this->db->update_batch('drawings', $data, 'name');
    }

    public function add_crossword() {
        $id = $this->input->post('id');
        $data = array(
            'string' => $this->input->post('string'),
            'school_id' => $this->input->post('school_id'),
            'main_category_id' => $this->input->post('main_category_id'),
            'category_id' => $this->input->post('category_id'),
        );
        $hori = json_decode($this->input->post('hori'));
        $verti = json_decode($this->input->post('verti'));
        $hori_no = json_decode($this->input->post('hori_no'));
        $verti_no = json_decode($this->input->post('verti_no'));
        if ($id != '0') {
            $this->db->where('id', $id);
            $this->db->update('crossword', $data);
            foreach ($hori as $key => $value) {
                $horidata = array(
                    'hint' => $value
                );
                $this->db->where('crossword_id', $id);
                $this->db->where('hint_no', $key);
                $this->db->where('direction', 'hori');
                $this->db->update('crossword_hint', $horidata);
            }
            foreach ($verti as $key => $value) {
                $horidata = array(
                    'hint' => $value
                );
                $this->db->where('crossword_id', $id);
                $this->db->where('hint_no', $key);
                $this->db->where('direction', 'verti');
                $this->db->update('crossword_hint', $horidata);
            }
        } else {
            $this->db->insert('crossword', $data);
            $id = $this->db->insert_id();
            foreach ($hori as $key => $value) {
                $hintdata = array(
                    'hint' => $value,
                    'hint_no' => $key,
                    'direction' => 'hori',
                    'crossword_id' => $id
                );
                $this->db->insert('crossword_hint', $hintdata);
            }
            foreach ($hori_no as $key => $value) {
                $hintdata = array(
                    'hint' => $value,
                    'hint_no' => $key,
                    'direction' => 'hori',
                    'crossword_id' => $id
                );
                $this->db->insert('crossword_hint', $hintdata);
            }
            foreach ($verti as $key => $value) {
                $hintdata = array(
                    'hint' => $value,
                    'hint_no' => $key,
                    'direction' => 'verti',
                    'crossword_id' => $id
                );
                $this->db->insert('crossword_hint', $hintdata);
            }
            foreach ($verti_no as $key => $value) {
                $hintdata = array(
                    'hint' => $value,
                    'hint_no' => $key,
                    'direction' => 'verti',
                    'crossword_id' => $id
                );
                $this->db->insert('crossword_hint', $hintdata);
            }            
        }
    }
    
    public function delete_crossword($id) {
        $this->db->where('id',$id);
        $this->db->delete('crossword');
        $this->db->where('crossword_id',$id);
        $this->db->delete('crossword_hint');
    }

}

?>