<style>

    .ch-inputs{

        background-color: transparent;

        border: 0 none;

        font-size: 20px;

        height: 100%;

        padding: 0;

        text-align: center;

        text-transform: uppercase;

        width: 100%;

    }

    td{

        background-color: transparent;

        border-bottom: 1px solid #FFF;

        border-right: 1px solid #FFF;

        height: 40px;

        padding: 6px;

        text-align: left;

        vertical-align: top;

        width: 40px;

    }

    tr:first-child td {

        border-top: 1px solid #FFF

    }

    tr td:first-child {

        border-left: 1px solid #FFF

    }

    table{

        margin: 0 auto;

    }

    .crossword {

        background-color: #FFF;

        counter-reset: req;

        empty-cells: hide;

    }

    .crossword td[id] {

        counter-increment: req;

    }

    .crossword td[id]:before {

        content: counter(req);

        font-size: 10px;

        margin: -5px;

        position: absolute;

    }

    .crossword td.sel {

        background-color: #FF9 !important;

        color: #000 !important;

    }

    .crossword td.hsel {

        background-color: #FF9 !important;

        color: #000 !important;

    }

    #radios{

        margin: 15px auto auto;

        width: 18%;

        display: none;

    }

    #deletecrossword{

        margin: 10px;

        display: none;

    }

    #guesses{

        display: none;  

    }

    #deletebtn{

        display: none;  

    }

    #generatebtn{

        display: none;

        text-align: center;

        margin-top: 15px;

    }

</style>

<form class="form-horizontal">

    <div class="row">

        <div class="col-sm-12">

            <div class="panel panel-bd">

                <div class="panel-heading">

                    <div class="panel-title">

                        <h4>Add Crossword</h4>

                    </div>

                </div>

                <div class="panel-heading">

                    <div class="row">

                        <div class="col-sm-4">

                            <select class="form-control" name="school_id" id="schools">

                                <option value="">Select School</option>

                                <option value="2">Deen barneskole 1-3</option>

                                <option value="3">Deen barneskole 4-7</option>

                                <option value="4">Deen ungdomsskole</option>

                            </select>

                        </div>

                        <div class="col-sm-4">

                            <select class="form-control" name="main_category_id" id="categories">

                                <option value="">Select Category</option>

                            </select>

                        </div>

                        <div class="col-sm-4">

                            <select class="form-control" name="category_id" id="subcategories">

                                <option value="">Select Sub-Category</option>

                            </select>

                        </div>

                    </div>

                </div>

                <div class="panel-body">

                    <div class="row" id="crwo" style="display: none">

                        <div class="form-group" style="margin-bottom: 40px">

                            <label class="control-label col-sm-2">No. of Rows</label>

                            <div class="col-sm-2">

                                <input type="number" class="form-control" id="c-row" required="" placeholder="eg: 5">

                            </div>

                            <label class="control-label col-sm-2">No. of Columns</label>

                            <div class="col-sm-2">

                                <input type="number" class="form-control" id="c-col" required="" placeholder="eg: 5">

                            </div>

                            <div class="col-sm-3 text-center">

                                <button type="button" class="btn btn-success" id="c-draw">Draw Crossword Table</button>

                            </div>

                        </div>

                        <div class="clearfix"></div>



                    </div>

                    <div class="row">

                        <div id="crossword">



                        </div>

                        <input type="hidden" id="cwid" value="0">

                    </div>

                    <div class="row">

                        <div id="generatebtn">

                            <button type="button" class="btn btn-success">Generate</button>

                        </div>

                    </div>

                    <div class="row">

                        <div id="radios">

                            <div class="radio radio-inline">

                                <input type="radio" name="dirc" id="vert" value="hor" checked="">

                                <label for="vert">Horizontal</label>

                            </div>

                            <div class="radio radio-inline">

                                <input type="radio" id="hori" name="dirc" value="ver">

                                <label for="hori">Vertical</label>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div id="deletecrossword" class="text-right">

                            <button type="button" id="deletebtn" class="btn btn-danger">Delete Crossword</button>

                        </div>

                    </div>



                    <div id="guesses">

                        <div class="row" style="width: 90%; margin: auto;">

                            <h3>Horizontal Guesses</h3>

                            <div id="horizontal" class="">



                            </div>

                        </div>



                        <div class="row" style="width: 90%; margin: auto;">

                            <h3>Vertical Guesses</h3>

                            <div id="vertical" class="">



                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>



        <div class="col-sm-12" id="submit-btn" style="display: none;">

            <div class="panel panel-bd">

                <div class="panel-body text-center">

                    <div class="form-group">

                        <button type="button" id="submitbtn" style="width: 50%" class="btn btn-primary btn-lg">Save</button>

                    </div>

                </div>

            </div>

        </div>

    </div>

</form>

<script>

    var mystr;

    $(document).ready(function () {

        $(window).keydown(function (event) {

            if (event.keyCode == 13) {

                event.preventDefault();

                return false;

            }

        });

        $('input[type=radio]').change(function () {

            var _dir = $(this).val();

        });

        $('#c-draw').click(function () {

            var tab = $('#crossword');

            var rows = $('#c-row').val();

            var cols = $('#c-col').val();

            var i, j;

            var table = '<table>';

            for (i = 1; i <= rows; i++) {

                table += '<tr>';

                for (j = 1; j <= cols; j++) {

                    table += '<td><input type="text" class="ch-inputs" maxlength="1"></td>';

                }

                table += '</tr>';

            }

            table += '</table><input type="hidden" id="string">';

            tab.html(table);

            tab.show();

            $("#generatebtn").show();

//            $("#submit-btn").show();

        });

        $('#generatebtn').click(function () {

            $('tr').each(function (e) {

                $(this).children('td').children('input').each(function () {

                    $('#string').val($('#string').val() + $(this).val());

                });

                $('#string').val($('#string').val() + "\n");

            });

            var str = $('#string').val();

            mystr = str;

            var table = '<table>';

            table += '<tr>';



            var options = {

                crossword_id: "crossword",

                crossword_val: str,

                hor_val: "hor",

                ver_val: "ver",

                caption: ""

            };

            var defaults = {

                crossword_id: "crossword",

                hor_id: "hor",

                ver_id: "ver",

                bb: "#",

                crossword_val: "",

                hor_val: "",

                ver_val: "",

                prefix_id: "d",

                caption: ""

            };

            var _hor = "hor",

                    _ver = "ver",

                    _rspace = /\s+/,

                    _rreturn = /[\r\n]/g,

                    _rsspace = /[ \t]+/g,

                    D = "#",

                    version = "2.1";

            var res = {

                schema: "",

                def: []

            };

            var opts = $.extend(defaults, options);



            var hor = [], ver = [],

                    c = 0,

                    letters,

                    rows = $.trim(opts.crossword_val).split(_rspace),

                    rows_l = rows.length,

                    cols_l = rows[0].length;

            res.schema = "<table id='" + opts.crossword_id + "' class='crossword'>";

            res.schema += "<tbody>";

            for (h = 0; h < cols_l; h++)

                ver[h] = 0; // posso scrivere

            $.each(rows, function (h, row) {

                if (typeof row === "string" && row != "") {

                    hor[h] = 0; // posso scrivere

                    res.schema += "<tr>";

                    letters = row.split("");

                    $.each(letters, function (v, letter) {

                        if (letter == opts.bb) {

                            ver[v] = hor[h] = 0;

                            res.schema += "<td></td>";

                        } else {

                            res.schema += "<td";

                            if (ver[v] || hor[h]) {

                                data1 = hor[h] ? ("data-" + _hor + "='" + opts.prefix_id + hor[h] + "'") : "";

                                data2 = ver[v] ? ("data-" + _ver + "='" + opts.prefix_id + ver[v] + "'") : "";

                                res.schema += " " + $.trim(data1 + " " + data2);

                            }

                            if ((!hor[h] && (v + 1) < cols_l && rows[h][v + 1] != opts.bb) ||

                                    (!ver[v] && (h + 1) < rows_l && rows[h + 1][v] != opts.bb)) {

                                res.schema += " id='" + opts.prefix_id + (++c) + "'";

                                hor[h] = hor[h] || c;

                                ver[v] = ver[v] || c;

                            }

                            res.schema += "><input type='text' class='ch-inputs' maxlength='1' value='" + letter + "'></td>";

                        }

                    });

                    res.schema += "</tr>";

                }

            });

            res.schema += "</tbody></table>";

            table = res.schema;

            $("#crwo").hide();

            $('#cwid').val('0');

            $("#crossword").html(table);

            $('.ch-inputs').parent('td').css('background-color', '#2C3136');

            $("#submitbtn").html('Save');

            $("#crossword").append('<input type="hidden" id="string" val="' + mystr + '">');

            $('#horizontal').html('');

            $('#vertical').html('');

            $('td').each(function (e) {

                var i;

                if (typeof $(this).attr('data-hor') !== 'undefined') {

                    i = 'hint' + $(this).attr('data-hor').replace('d', "");

                    var inp = $('#horizontal').find('#' + i).attr('id');

                    if (typeof inp === 'undefined') {

                        $('#horizontal').append('<div class="form-group"><div class="input-group"><span class="input-group-addon" id="' + i + '">' + i.replace("hint", "") + '</span><input type="text" class="form-control hintss hor-hint" required name="' + i.replace("hint", "") + '" id="hor" aria-describedby="' + i + '"></div>');

                    }

                }

                if (typeof $(this).attr('data-ver') !== 'undefined') {

                    i = 'hint' + $(this).attr('data-ver').replace('d', "");

                    var inp = $('#vertical').find('#' + i).attr('id');

                    if (typeof inp === 'undefined') {

                        $('#vertical').append('<div class="form-group"><div class="input-group"><span class="input-group-addon" id="' + i + '">' + i.replace("hint", "") + '</span><input type="text" class="form-control hintss ver-hint" required name="' + i.replace("hint", "") + '" id="ver" aria-describedby="' + i + '"></div>');

                    }

                }



            });

            var options = {

                crossword_id: "crossword",

                hor_val: "hor",

                ver_val: "ver",

                caption: ""

            };



            var defaults = {

                cross_class: "crossword",

                td_sel: "sel",

                hor_id: "hor",

                ver_id: "ver",

                tooltip_id: "tooltip",

                prefix_id: "d",

                pointer: "pointer",

                tooltip_top: -40,

                tooltip_left: 40

            };

            var _hor = "hor",

                    _ver = "ver",

                    _rspace = /\s+/,

                    _rreturn = /[\r\n]/g,

                    _rsspace = /[ \t]+/g,

                    D = "#",

                    version = "2.1";

            var res = {

                schema: "",

                def: []

            };

            var opts = $.extend(defaults, options);

            var _$input = $('.ch-inputs');

            var _dir = _hor;

            var number;

            var _$td = $("td");

            var $td = $("td");

            var $first;

            _$input.focus(function (event, dir) {

                if (event.type == "click") {

                    return false;

                }

                if (typeof dir === 'undefined') {

                    dir = $("input[type='radio']:checked").val();

                }

                var $input = $(this),

                        $td = $input.closest("td"),

                        id = $td.attr("data-" + dir);

                if (!id)

                    id = $td.attr("id");

                number = id.replace(opts.prefix_id, "");

                $input.select();

                var $first = selectWord(number, dir, $td);

                var first_pos = $first.position()



            });

            _$input.blur(function () {

                _$td.removeClass(opts.td_sel);

            });

            $('input[type=radio]').change(function () {

                _dir = $(this).val();

            });

            function selectWord(number, dir, $td) {

                var $word;

                _$td.removeClass(opts.td_sel);

                _$td.removeClass('hsel');

                if (dir != _hor && dir != _ver)

                    return false;

                $word = _$td.filter("td[data-" + dir + "='" + opts.prefix_id + number + "'], td[id='" + opts.prefix_id + number + "']");

                _dir = dir;

                if ($word.length <= 1) {

                    $td.addClass(opts.td_sel);

                    return $();

                }

                $word.addClass(opts.td_sel);

                $first = $word.eq(0);

                return $first;

            }

            $('.hintss').click(function (event) {

                var inp = $(this),

                        dir, number;

                dir = inp.attr("id");

                number = inp.siblings('span').html();

                var $input = $('#d' + number).find("input"),

                        $td = $input.closest("td"),

                        id = $td.attr("data-" + dir);

                if (!id)

                    id = $td.attr("id");

                number = id.replace(opts.prefix_id, "");

                var _$td = $('td'),

                        $word;

                _$td.removeClass('hsel');

                $word = _$td.filter("td[data-" + dir + "='" + opts.prefix_id + number + "'], td[id='" + opts.prefix_id + number + "']");

                if ($word.length <= 1) {

                    $td.addClass('hsel');

                    return $();

                }

                $word.addClass('hsel');

            });

            $('.hintss').blur(function () {

                _$td.removeClass('hsel');

            });

            $("#generatebtn").hide();

            $("#guesses").show();

            $("#radios").show();

            $("#submit-btn").show();

        });

        $(document).on('keyup', '.ch-inputs', function () {

            if (this.value.length == this.maxLength) {

                v = $(this).closest('td').next('td').find('input');

                if (v.length > 0)

                {

                    v.focus();

                } else

                {

                    v2 = $(this).closest('tr').next('tr').find('input:first');

                    if (v2.length > 0) {

                        v2.focus();

                    }

                }

            }

        });

    });



    $('#schools').change(function () {

        handlePreloader();

        var school_id = $('#schools').val();

        $("#categories").html("");

        $("#categories").append('<option value="">Select Category</option>');

        $.post("<?= base_url() ?>admin/home/getcategories",

                {school_id: school_id},

                function (data, status) {

                    $("#categories").append(data);

                    $("#preloader").removeClass('preloader');

                });



    });



    $('#categories').change(function () {

        handlePreloader();

        var cat_id = $('#categories').val();

        $("#subcategories").html("");

        $("#subcategories").append('<option value="">Select Sub-Category</option>');

        $.post("<?= base_url() ?>admin/home/getsubcategories",

                {cat_id: cat_id},

                function (data, status) {

                    $("#subcategories").append(data);

                    $("#preloader").removeClass('preloader');

                });

    });



    $('#subcategories').change(function () {

        handlePreloader();

        scount();

    });



    function scount() {

        var school_id = $('#schools').val();

        var cat_id = $('#categories').val();

        var subcat_id = $('#subcategories').val();

        $('#crossword').hide();

        $('#deletecrossword').hide();

        $('#deletebtn').hide();

        $('#guesses').hide();

        $('#submit-btn').hide();

        $('#radios').hide();

        $('#horizontal').html('');

        $('#vertical').html('');

        $.post("<?= base_url() ?>admin/home/getcrosswordcount",

                {school_id: school_id, cat_id: cat_id, subcat_id: subcat_id},

                function (data, status) {

                    if (!data) {

                        $("#crossword").html('');

                        $('#cwid').val('0');

                        $("#submitbtn").html('Save');

                        $("#crwo").show();

                    } else {

                        var table = '<table>';

                        table += '<tr>';

                        data = $.parseJSON(data);

                        var str = data.string.toString();

                        mystr = str;

                        var e_hori = {};

                        var e_verti = {};

                        var e_hints = data.hints;

                        for (var key in e_hints) {

                            if (e_hints[key].direction === 'hori') {

                                e_hori[e_hints[key].hint_no] = e_hints[key].hint;

                            } else {

                                e_verti[e_hints[key].hint_no] = e_hints[key].hint;

                            }

                        }



                        var options = {

                            crossword_id: "crossword",

                            crossword_val: str,

                            hor_val: "hor",

                            ver_val: "ver",

                            caption: ""

                        };

                        var defaults = {

                            crossword_id: "crossword",

                            hor_id: "hor",

                            ver_id: "ver",

                            bb: "#",

                            crossword_val: "",

                            hor_val: "",

                            ver_val: "",

                            prefix_id: "d",

                            caption: ""

                        };

                        var _hor = "hor",

                                _ver = "ver",

                                _rspace = /\s+/,

                                _rreturn = /[\r\n]/g,

                                _rsspace = /[ \t]+/g,

                                D = "#",

                                version = "2.1";

                        var res = {

                            schema: "",

                            def: []

                        };

                        var opts = $.extend(defaults, options);



                        var hor = [], ver = [],

                                c = 0,

                                letters,

                                rows = $.trim(opts.crossword_val).split(_rspace),

                                rows_l = rows.length,

                                cols_l = rows[0].length;

                        res.schema = "<table id='" + opts.crossword_id + "' class='crossword'>";

                        res.schema += "<tbody>";

                        for (h = 0; h < cols_l; h++)

                            ver[h] = 0; // posso scrivere

                        $.each(rows, function (h, row) {

                            if (typeof row === "string" && row != "") {

                                hor[h] = 0; // posso scrivere

                                res.schema += "<tr>";

                                letters = row.split("");

                                $.each(letters, function (v, letter) {

                                    if (letter == opts.bb) {

                                        ver[v] = hor[h] = 0;

                                        res.schema += "<td></td>";

                                    } else {

                                        res.schema += "<td";

                                        if (ver[v] || hor[h]) {

                                            data1 = hor[h] ? ("data-" + _hor + "='" + opts.prefix_id + hor[h] + "'") : "";

                                            data2 = ver[v] ? ("data-" + _ver + "='" + opts.prefix_id + ver[v] + "'") : "";

                                            res.schema += " " + $.trim(data1 + " " + data2);

                                        }

                                        if ((!hor[h] && (v + 1) < cols_l && rows[h][v + 1] != opts.bb) ||

                                                (!ver[v] && (h + 1) < rows_l && rows[h + 1][v] != opts.bb)) {

                                            res.schema += " id='" + opts.prefix_id + (++c) + "'";

                                            hor[h] = hor[h] || c;

                                            ver[v] = ver[v] || c;

                                        }

                                        res.schema += "><input type='text' class='ch-inputs' maxlength='1' value='" + letter + "'></td>";

                                    }

                                });

                                res.schema += "</tr>";

                            }

                        });

                        res.schema += "</tbody></table>";

                        table = res.schema;

                        $("#crwo").hide();

                        $('#cwid').val(data.id);

                        $("#crossword").html(table);

                        $('.ch-inputs').parent('td').css('background-color', '#2C3136');

                        $("#submitbtn").html('Update');

                        $("#crossword").append('<input type="hidden" id="string">');



                        $('td').each(function (e) {

                            var i;

                            if (typeof $(this).attr('data-hor') !== 'undefined') {

                                i = 'hint' + $(this).attr('data-hor').replace('d', "");

                                var inp = $('#horizontal').find('#' + i).attr('id');

                                if (typeof inp === 'undefined') {

                                    $('#horizontal').append('<div class="form-group"><div class="input-group"><span class="input-group-addon" id="' + i + '">' + i.replace("hint", "") + '</span><input type="text" class="form-control hintss hor-hint" name="' + i.replace("hint", "") + '" value="' + e_hori[i.replace("hint", "")] + '" id="hor" aria-describedby="' + i + '"></div>');

                                }

                            }

                            if (typeof $(this).attr('data-ver') !== 'undefined') {

                                i = 'hint' + $(this).attr('data-ver').replace('d', "");

                                var inp = $('#vertical').find('#' + i).attr('id');

                                if (typeof inp === 'undefined') {

                                    $('#vertical').append('<div class="form-group"><div class="input-group"><span class="input-group-addon" id="' + i + '">' + i.replace("hint", "") + '</span><input type="text" class="form-control hintss ver-hint" name="' + i.replace("hint", "") + '" id="ver" value="' + e_verti[i.replace("hint", "")] + '" aria-describedby="' + i + '"></div>');

                                }

                            }

                        });

                        var options = {

                            crossword_id: "crossword",

                            hor_val: "hor",

                            ver_val: "ver",

                            caption: ""

                        };



                        var defaults = {

                            cross_class: "crossword",

                            td_sel: "sel",

                            hor_id: "hor",

                            ver_id: "ver",

                            tooltip_id: "tooltip",

                            prefix_id: "d",

                            pointer: "pointer",

                            tooltip_top: -40,

                            tooltip_left: 40

                        };

                        var _hor = "hor",

                                _ver = "ver",

                                _rspace = /\s+/,

                                _rreturn = /[\r\n]/g,

                                _rsspace = /[ \t]+/g,

                                D = "#",

                                version = "2.1";

                        var res = {

                            schema: "",

                            def: []

                        };

                        var opts = $.extend(defaults, options);

                        var _$input = $('.ch-inputs');

                        var _dir = _hor;

                        var number;

                        var _$td = $("td");

                        var $td = $("td");

                        var $first;

                        _$input.focus(function (event, dir) {

                            if (event.type == "click") {

                                return false;

                            }

                            if (typeof dir === 'undefined') {

                                dir = $("input[type='radio']:checked").val();

                            }

                            var $input = $(this),

                                    $td = $input.closest("td"),

                                    id = $td.attr("data-" + dir);

                            if (!id)

                                id = $td.attr("id");

                            number = id.replace(opts.prefix_id, "");

                            $input.select();

                            var $first = selectWord(number, dir, $td);

                            var first_pos = $first.position()



                        });

                        _$input.blur(function () {

                            _$td.removeClass(opts.td_sel);

                        });

                        $('input[type=radio]').change(function () {

                            _dir = $(this).val();

                        });

                        function selectWord(number, dir, $td) {

                            var $word;

                            _$td.removeClass(opts.td_sel);

                            _$td.removeClass('hsel');

                            if (dir != _hor && dir != _ver)

                                return false;

                            $word = _$td.filter("td[data-" + dir + "='" + opts.prefix_id + number + "'], td[id='" + opts.prefix_id + number + "']");

                            _dir = dir;

                            if ($word.length <= 1) {

                                $td.addClass(opts.td_sel);

                                return $();

                            }

                            $word.addClass(opts.td_sel);

                            $first = $word.eq(0);

                            return $first;

                        }

                        $('.hintss').click(function (event) {

                            var inp = $(this),

                                    dir, number;

                            dir = inp.attr("id");

                            number = inp.siblings('span').html();

                            var $input = $('#d' + number).find("input"),

                                    $td = $input.closest("td"),

                                    id = $td.attr("data-" + dir);

                            if (!id)

                                id = $td.attr("id");

                            number = id.replace(opts.prefix_id, "");

                            var _$td = $('td'),

                                    $word;

                            _$td.removeClass('hsel');

                            $word = _$td.filter("td[data-" + dir + "='" + opts.prefix_id + number + "'], td[id='" + opts.prefix_id + number + "']");

                            if ($word.length <= 1) {

                                $td.addClass('hsel');

                                return $();

                            }

                            $word.addClass('hsel');

                        });

                        $('.hintss').blur(function () {

                            _$td.removeClass('hsel');

                        });

                        $('#crossword').show();

                        $('#guesses').show();

                        $('#deletecrossword').show();

                        $("#submit-btn").show();

                        $("#radios").show();

                        $('#deletebtn').show();

                    }



//                    $("#submit-btn").show();

                    $("#preloader").removeClass('preloader');

                });

    }

    $("#submit-btn").click(function (event) {

        handlePreloader();

        var school_id = $('#schools').val();

        var cat_id = $('#categories').val();

        var subcat_id = $('#subcategories').val();

        var cwid = $('#cwid').val();

        var str = mystr;

        var hori = {};

        var verti = {};

        $('#horizontal').find('input').each(function () {

            hori[$(this).attr("name")] = $(this).val();

        });

        $('#vertical').find('input').each(function () {

            verti[$(this).attr("name")] = $(this).val();

        });

        hori = JSON.stringify(hori);

        verti = JSON.stringify(verti);

        $.post("<?= base_url() ?>admin/quiz/crossword/add/save",

                {main_category_id: cat_id, school_id: school_id, category_id: subcat_id, string: str, id: cwid, hori: hori, verti: verti},

                function (data, status) {

                    scount();

                    $("#preloader").removeClass('preloader');

                    toaster("Crossword Created Successfully!");

                    $('#crossword').html('');

                });

    });



    $('#deletebtn').click(function () {

        swal({

            title: 'Are you sure?',

            text: "You won't be able to revert this!",

            type: 'warning',

            showCancelButton: true,

            confirmButtonColor: '#d33',

            cancelButtonColor: '#3085d6',

            confirmButtonText: 'Yes, delete it!'

        }).then(function () {

            handlePreloader();

            var id = $('#cwid').val();

            $.post("<?= base_url() ?>admin/home/deletecrossword",

                    {id: id},

                    function (data, status) {

                        scount();

                        $("#preloader").removeClass('preloader');

                        toaster("Crossword Deleted Successfully!");

                    });



        });

    });



    //preloader function

    function handlePreloader() {

        $("#preloader").addClass('preloader');

        if ($('.preloader').length) {

            $('.preloader').show();

        }

    }



    toastr.options.closeButton = true;

    toastr.options.progressBar = true;

    toastr.options.showMethod = 'slideDown';

    toastr.options.closeDuration = 300;

    toastr.options.closeEasing = 'swing';

    toastr.options.timeOut = 3000;

    function toaster(msg) {

        toastr.success(msg);

    }

</script>