<!DOCTYPE html>
<html lang="en">
    <?php
    $this->load->helper('language');
//    setcookie('googtrans', '/no/en');
//    setcookie('googtrans', '/en/no');
    ?>
    <head>
        <meta charset="UTF-8">
        <title><?= $page_title ?></title>
        <!-- mobile responsive meta -->
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">


        <link rel="stylesheet" href="<?= base_url(); ?>css/style.css">
        <link rel="stylesheet" href="<?= base_url(); ?>css/responsive.css">
        <link rel="stylesheet" href="<?= base_url(); ?>fonts/flaticon.css" />
        <link rel="stylesheet" href="<?= base_url(); ?>css/language.css" />
        <!--favicon-->
        <link rel="apple-touch-icon" sizes="180x180" href="<?= base_url(); ?>images/favicon/deen-favicon.png">
        <link rel="icon" type="image/png" href="<?= base_url(); ?>images/favicon/deen-favicon.png" sizes="32x32">
        <link rel="icon" type="image/png" href="<?= base_url(); ?>images/favicon/deen-favicon.png" sizes="16x16">
        <!-- jQuery js -->
        <script src="<?= base_url(); ?>js/jquery.js"></script>
        <script src="<?= base_url(); ?>js/jquery.cookie.js"></script>
        <script src="<?= base_url(); ?>js/sweetalert2.js"></script>
        <!-- owl carousel js -->
        <script src="<?= base_url(); ?>js/owl.carousel.min.js"></script>
        <script type="text/javascript">
            $.cookie('language' , '');
        </script>


    </head>

    <body>
        <div class="boxed_wrapper">
            <div class="header-top" style="min-height: 37px;">
                <div class="container clearfix">
                    <!--Top Left-->

                    <!--Top Right-->
                    <div class="top-right pull-right">


                        <!-- Code provided by Google -->

                        <div class="dropdown language">
                            <button class="btn btn-default dropdown-toggle" type="button" id="languageDrop" data-toggle="dropdown" aria-haspopup="true"
                                    aria-expanded="true">
                                <i class="fa fa-language"></i> <?= lang('msg_language'); ?>
                                <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="languageDrop">
                                <li class="active">
                                    <a href="javascript:;" id="English" class="en" onclick="translateLanguage(this.id)">English</a>
                                </li>
                                <li>
                                    <a href="javascript:;" id="Norwegian" class="no" onclick="translateLanguage(this.id)">Norwegian</a>
                                </li>
                            </ul>


                            <div id="google_translate_element" style="display: none">
                            </div>

                            <script type="text/javascript">
                                function googleTranslateElementInit() {
                                    new google.translate.TranslateElement({pageLanguage: 'no', includedLanguages: 'en,no', layout: google.translate.TranslateElement.InlineLayout.SIMPLE, autoDisplay: false, multilanguagePage: true}, 'google_translate_element');
                                }
                            </script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
                            <script>
                                function translateLanguage(lang) {
                                    // $(id).closest('ul').find('li').removeClass("active");
                                    // $(id).closest('li').addClass('active');
                                    // if (lang === "English") {
                                    //     $.cookie("googtrans", '/no/en');
                                    // } else {
                                    //     $.cookie("googtrans", '/en/no');
                                    // }
                                    // var $frame = $('.goog-te-menu-frame:first');
                                    // if (!$frame.size()) {
                                    //     alert("Error: Could not find Google translate frame.");
                                    //     return false;
                                    // }
                                    // $frame.contents().find('.goog-te-menu2-item span.text:contains(' + lang + ')').get(0).click();
                                    // return false;

                                    if(lang != 'English'){
                                
                                     $.cookie("language", '?lang=no');

                                     tempurl = $(location).attr("href");
                                     var incStr = tempurl.includes("?lang=en");
                                     var incStr2 = tempurl.includes('&lang=en');
                                     var incStr3 = tempurl.includes('?plan=');

                                     if(incStr == true){
                                        url = tempurl.replace('?lang=en' , $.cookie("language"));
                                     }
                                     else if(incStr2 == true){
                                        url = tempurl.replace('&lang=en' , '&lang=no');
                                     }
                                     else if(incStr3 == true ){
                                        url = tempurl + '&lang=no';
                                     }
                                     else{
                                        url = tempurl + $.cookie('language');
                                     }    
                                     
                                     // url = tempurl.replace('?lang=en' , $.cookie("lang"));
                                     // alert(url);
                                     window.location.href = url;

                                }



                                }
                            </script>

                        </div>

                    </div>
                </div>
            </div>
            <!-- Header Top End -->

            <section class="mainmenu-area stricky">
                <div class="container">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="main-logo">
                                <a href="<?= site_url(); ?>">
                                    <img src="https://www.placehold.it/250x61/EFEFEF/AAAAAA&amp;text=Logo" alt="">
                                </a>
                            </div>
                        </div>
                        <div class="col-md-8 menu-column">
                            <nav class="main-menu">
                                <div class="navbar-header">
                                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                    </button>
                                </div>
                                <div class="navbar-collapse collapse clearfix">
                                    <ul class="navigation clearfix">
                                        <li <?= active_menu(base_url()) ?>>
                                            <a href="<?= site_url() ; ?>" ><?= lang('msg_home'); ?></a>
                                        </li>
                                        <li <?= active_menu(base_url() . "about") ?>>
                                            <a href="<?= site_url('about'); ?>"><?= lang('msg_about_title'); ?></a>
                                        </li>
                                        <li <?= active_menu(base_url() . "donate") ?>>
                                            <a href="<?= site_url('donate'); ?>"><?= lang('msg_donate_title'); ?></a>
                                        </li>
                                        <li <?= active_menu(base_url() . "membership") ?>>
                                            <a href="<?= site_url('membership'); ?>"><?= lang('msg_membership_title'); ?></a>
                                        </li>
                                        <li <?= active_menu(base_url() . "contact") ?>>
                                            <a href="<?= site_url('contact'); ?>"><?= lang('msg_contact_title'); ?></a>
                                        </li>
                                        <?php if (!$this->session->userdata('logged_in')) { ?>
                                            <li <?= active_menu(base_url() . "login", "pull-right") ?>>
                                                <a href="<?= site_url('login'); ?>"><?= lang('msg_login_title'); ?></a>
                                            </li>
                                        <?php } else { ?>
                                            <li <?= active_menu(base_url() . "dashboard", "pull-right") ?>>
                                                <a href="<?= site_url('dashboard'); ?>">Dashboard</a>
                                            </li>
                                        <?php } ?>
                                    </ul>

                                    <ul class="mobile-menu clearfix">
                                        <li <?= active_menu(base_url()) ?>>
                                            <a href="<?= site_url(); ?>" ><?= lang('msg_home'); ?></a>
                                        </li>
                                        <li <?= active_menu(base_url() . "about") ?>>
                                            <a href="<?= site_url('about'); ?>"><?= lang('msg_home'); ?></a>
                                        </li>
                                        <li <?= active_menu(base_url() . "membership") ?>>
                                            <a href="<?= site_url('membership'); ?>"><?= lang('msg_home'); ?></a>
                                        </li>
                                        <li <?= active_menu(base_url() . "contact") ?>>
                                            <a href="<?= site_url('contact'); ?>"><?= lang('msg_home'); ?></a>
                                        </li>
                                        <?php if (!$this->session->userdata('logged_in')) { ?>
                                            <li <?= active_menu(base_url() . "login") ?>>
                                                <a href="<?= site_url('login'); ?>"><?= lang('msg_login_title'); ?></a>
                                            </li>
                                        <?php } else { ?>
                                            <li <?= active_menu(base_url() . "dashboard") ?>>
                                                <a href="<?= site_url('dashboard'); ?>">Dashboard</a>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            </nav>
                        </div>

                    </div>

                </div>
            </section>


            <?php if (isset($show_page_header)) { ?>
                <section class="page-title">
                    <div class="container">
                        <div class="row clearfix">
                            <div class="col-md-6 col-sm-6 col-xs-12 pull-left">
                                <h1><?= $page_title_header ?></h1>
                            </div>
                            <div class="col-md-6 col-sm-6 col-xs-12 pull-right text-right path">
                                <?= $breadcrumbs ?>
                            </div>
                            <div class="overlay"></div>
                        </div>
                    </div>
                </section>
            <?php } ?>





            <?php $this->load->view($main_view); ?>





            <!--footer start-->
            <footer class="footer bg-style">
                <div class="container">
                    <div class="footer-upper">

                        <div class="row">
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="footer-widget about-widget">

                                    <p><?= lang('msg_newsletter_title'); ?></p>
                                    <div class="input-group">
                                        <input type="text" class="form-control">
                                        <span class="input-group-btn">
                                            <button class="btn btn-default" type="button">
                                                <i class="fa fa-paper-plane"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <!-- /input-group -->
                                    <br>

                                </div>
                            </div>
                            <div class="col-md-2 col-sm-6 col-xs-12">
                                <div class="footer-widget quick-links">
                                    <br>
                                    <ul>
                                        <li>
                                            <a href="#"><?= lang('msg_faq'); ?></a>
                                        </li>
                                        <li>
                                            <a href="<?= site_url('membership'); ?>"><?= lang('msg_membership_title'); ?></a>
                                        </li>
                                        <li>
                                            <a href="<?= site_url('terms-conditions'); ?>"><?= lang('msg_terms_conditions_title'); ?></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12 social">
                                <ul style="padding: 25px;">
                                    <li>
                                        <a href="#">
                                            <i class="fa fa-facebook fa-2x"></i>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#">
                                            <i class="fa fa-twitter fa-2x"></i>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#">
                                            <i class="fa fa-youtube fa-2x"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-4 col-sm-6 col-xs-12">
                                <div class="footer-widget contact">

                                    <div class="widget-content">
                                        <div class="playstore-container">
                                            <a href="#">
                                                <img src="<?= base_url(); ?>images/footer/apple-store.png" alt="store"> </a>
                                            <a href="#">
                                                <img src="<?= base_url(); ?>images/footer/android-store.png" alt="store">
                                            </a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <!--Footer Bottom-->
                <div class="footer-bottom text-center">
                    <div class="container">
                        <div class="copyright-text">© Content on this site is protected by copyright.</div>
                    </div>
                </div>
            </footer>
            <!--footer end-->

            <script>
                $('document').ready(function () {
                    $('#google_translate_element').on("click", function () {

                        // Change font family and color
                        $("iframe").contents().find(".goog-te-menu2-item div, .goog-te-menu2-item:link div, .goog-te-menu2-item:visited div, .goog-te-menu2-item:active div") //, .goog-te-menu2 *
                                .css({
                                    'color': '#544F4B',
                                    'background-color': '#e3e3ff',
                                    'font-family': '"Open Sans",Helvetica,Arial,sans-serif'
                                });

                        // Change hover effects  #e3e3ff = white
                        $("iframe").contents().find(".goog-te-menu2-item div").hover(function () {
                            $(this).css('background-color', '#17548d').find('span.text').css('color', '#e3e3ff');
                        }, function () {
                            $(this).css('background-color', '#e3e3ff').find('span.text').css('color', '#544F4B');
                        });

                        // Change Google's default blue border
                        $("iframe").contents().find('.goog-te-menu2').css('border', '1px solid #17548d');

                        $("iframe").contents().find('.goog-te-menu2').css('background-color', '#e3e3ff');

                        // Change the iframe's box shadow
                        $(".goog-te-menu-frame").css({
                            '-moz-box-shadow': '0 3px 8px 2px #666666',
                            '-webkit-box-shadow': '0 3px 8px 2px #666',
                            'box-shadow': '0 3px 8px 2px #666'
                        });
                    });
                });
            </script>


            <!-- Scroll Top Button -->
            <button class="scroll-top tran3s color2_bg">
                <span class="fa fa-angle-up"></span>
            </button>
            <!-- pre loader  -->
            <div class="preloader"></div>


            <!-- bootstrap js -->
            <script src="<?= base_url(); ?>js/bootstrap.min.js"></script>
            <!-- jQuery ui js -->
            <script src="<?= base_url(); ?>js/jquery-ui.js"></script>

            <!-- jQuery validation -->
            <script src="<?= base_url(); ?>js/jquery.validate.min.js"></script>
            <!-- google map -->
            <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCRvBPo3-t31YFk588DpMYS6EqKf-oGBSI"></script>
            <script src="<?= base_url(); ?>js/gmap.js"></script>
            <!-- mixit up -->
            <script src="<?= base_url(); ?>js/wow.js"></script>
            <script src="<?= base_url(); ?>js/jquery.mixitup.min.js"></script>
            <script src="<?= base_url(); ?>js/jquery.fitvids.js"></script>
            <script src="<?= base_url(); ?>js/bootstrap-select.min.js"></script>


            <!-- revolution slider js -->
            <script src="<?= base_url(); ?>assets/revolution/js/jquery.themepunch.tools.min.js"></script>
            <script src="<?= base_url(); ?>assets/revolution/js/jquery.themepunch.revolution.min.js"></script>
            <script src="<?= base_url(); ?>assets/revolution/js/extensions/revolution.extension.actions.min.js"></script>
            <script src="<?= base_url(); ?>assets/revolution/js/extensions/revolution.extension.carousel.min.js"></script>
            <script src="<?= base_url(); ?>assets/revolution/js/extensions/revolution.extension.kenburn.min.js"></script>
            <script src="<?= base_url(); ?>assets/revolution/js/extensions/revolution.extension.layeranimation.min.js"></script>
            <script src="<?= base_url(); ?>assets/revolution/js/extensions/revolution.extension.migration.min.js"></script>
            <script src="<?= base_url(); ?>assets/revolution/js/extensions/revolution.extension.navigation.min.js"></script>
            <script src="<?= base_url(); ?>assets/revolution/js/extensions/revolution.extension.parallax.min.js"></script>
            <script src="<?= base_url(); ?>assets/revolution/js/extensions/revolution.extension.slideanims.min.js"></script>
            <script src="<?= base_url(); ?>assets/revolution/js/extensions/revolution.extension.video.min.js"></script>

            <!--- Scroll reveal -->
            <script src="https://unpkg.com/scrollreveal/dist/scrollreveal.min.js"></script>


            <!-- fancy box -->
            <script src="<?= base_url(); ?>js/jquery.fancybox.pack.js"></script>
            <script src="<?= base_url(); ?>js/jquery.polyglot.language.switcher.js"></script>
            <script src="<?= base_url(); ?>js/nouislider.js"></script>
            <script src="<?= base_url(); ?>js/jquery.bootstrap-touchspin.js"></script>
            <script src="<?= base_url(); ?>js/SmoothScroll.js"></script>
            <script src="<?= base_url(); ?>js/jquery.appear.js"></script>
            <script src="<?= base_url(); ?>js/jquery.countTo.js"></script>
            <script src="<?= base_url(); ?>js/jquery.flexslider.js"></script>
            <script src="<?= base_url(); ?>js/imagezoom.js"></script>
            <script src="<?= base_url(); ?>js/validation.js"></script>
            <script id="map-script" src="<?= base_url(); ?>js/default-map.js"></script>
            <script src="<?= base_url(); ?>js/custom.js"></script>


        </div>
    </body>
    <style>
        body>:nth-last-child(2) {
            display: none !important;
        }
    </style>

</html>