<style>
    td{
        font-size: 20px;
        text-align: center;
        text-transform: uppercase;
        background-color: transparent;
        border-bottom: 1px solid #FFF;
        border-right: 1px solid #FFF;
        height: 40px;
        padding: 6px;
        vertical-align: top;
        width: 40px;
    }
    tr:first-child td {
        border-top: 1px solid #FFF
    }
    tr td:first-child {
        border-left: 1px solid #FFF
    }
    table{
        margin: 0 auto;
    }
</style>
<div class="row">
    <div class="col-sm-12">
        <a href="<?= base_url() ?>admin/quiz/crossword/add" class="pull-right btn btn-success mb-15">Add Crossword</a>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-bd">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-sm-4">
                        <select class="form-control" name="school_id" id="schools">
                            <option value="">Select School</option>
                            <option value="2">Deen barneskole 1-3</option>
                            <option value="3">Deen barneskole 4-7</option>
                            <option value="4">Deen ungdomsskole</option>
                        </select>
                    </div>
                    <div class="col-sm-4">
                        <select class="form-control" name="main_category_id" id="categories">
                            <option value="">Select Category</option>

                        </select>
                    </div>
                    <div class="col-sm-4">
                        <select class="form-control" name="category_id" id="subcategories">
                            <option value="">Select Sub-Category</option>

                        </select>
                    </div>
                </div>
            </div>
            <div class="panel-body">

                <div id="cross-word">

                </div>

            </div>
        </div>
    </div>
</div>

<script>
    $('#schools').change(function () {
        $("#cross-word").html('');
        handlePreloader();
        var school_id = $('#schools').val();
        $("#categories").html("");
        $("#categories").append('<option value="">Select Category</option>');
        $.post("<?= base_url() ?>admin/home/getcategories",
                {school_id: school_id},
                function (data, status) {
                    $("#categories").append(data);
                    $("#preloader").removeClass('preloader');
                });
    });
    $('#categories').change(function () {
        $("#cross-word").html('');
        handlePreloader();
        var cat_id = $('#categories').val();
        $("#subcategories").html("");
        $("#subcategories").append('<option value="">Select Sub-Category</option>');
        $.post("<?= base_url() ?>admin/home/getsubcategories",
                {cat_id: cat_id},
                function (data, status) {
                    $("#subcategories").append(data);
                    $("#preloader").removeClass('preloader');
                });
    });
    $('#subcategories').change(function () {
        $("#cross-word").html('');
        handlePreloader();
        loadcrossword();
    });

    function loadcrossword() {
        $("#cross-word").html('');
        var school_id = $('#schools').val();
        var cat_id = $('#categories').val();
        var subcat_id = $('#subcategories').val();
        var table = '<table>';
        table += '<tr>';
        $.post("<?= base_url() ?>admin/home/getcrossword",
                {school_id: school_id, cat_id: cat_id, subcat_id: subcat_id},
                function (data, status) {
                    data = $.parseJSON(data);
                    var str = data.string.toString();
                    var i;
                    for (i = 0; i < str.length; i++) {
                        if (str[i] === '\n') {
                            table += '<tr>';
                        } else {
                            table += '<td>' + str[i] + '</td>';
                        }
                        if (str[i] === '\n') {
                            table += '</tr>';
                        }
                    }
                    $("#cross-word").html(table);
                    $("#preloader").removeClass('preloader');
                });
    }
    function deletesequence(id) {
        swal({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then(function () {
            handlePreloader();
            $.post("<?= base_url() ?>admin/quiz/sequence/delete",
                    {id: id},
                    function (data, status) {
                        swal(
                                'Success!',
                                'The question has been deleted!',
                                'success'
                                );
                        loadcrossword();
                        $("#preloader").removeClass('preloader');
                    });
        });
    }

    function handlePreloader() {
        $("#preloader").addClass('preloader');
        if ($('.preloader').length) {
            $('.preloader').show();
            //$('.preloader').fadeOut(500);
        }
    }

</script>