<div class="row">
    <div class="col-sm-12">
        <a href="<?= base_url() ?>admin/quiz/true-false/add" class="pull-right btn btn-success mb-15">Add Question</a>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-bd">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-sm-4">
                        <select class="form-control" name="school_id" id="schools">
                            <option value="">Select School</option>
                            <option value="2">Deen barneskole 1-3</option>
                            <option value="3">Deen barneskole 4-7</option>
                            <option value="4">Deen ungdomsskole</option>
                        </select>
                    </div>
                    <div class="col-sm-4">
                        <select class="form-control" name="main_category_id" id="categories">
                            <option value="">Select Category</option>

                        </select>
                    </div>
                    <div class="col-sm-4">
                        <select class="form-control" name="category_id" id="subcategories">
                            <option value="">Select Sub-Category</option>

                        </select>
                    </div>
                </div>
            </div>
            <div class="panel-body">

                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Sr.#</th>
                                <th>Question</th>
                                <th>Answer</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="questions-list">

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $('#schools').change(function () {
        $("#questions-list").html('');
        handlePreloader();
        var school_id = $('#schools').val();
        $("#categories").html("");
        $("#categories").append('<option value="">Select Category</option>');
        $.post("<?= base_url() ?>admin/home/getcategories",
                {school_id: school_id},
                function (data, status) {
                    $("#categories").append(data);
                    $("#preloader").removeClass('preloader');
                });
    });
    $('#categories').change(function () {
        $("#questions-list").html('');
        handlePreloader();
        var cat_id = $('#categories').val();
        $("#subcategories").html("");
        $("#subcategories").append('<option value="">Select Sub-Category</option>');
        $.post("<?= base_url() ?>admin/home/getsubcategories",
                {cat_id: cat_id},
                function (data, status) {
                    $("#subcategories").append(data);
                    $("#preloader").removeClass('preloader');
                });
    });
    $('#subcategories').change(function () {
        $("#questions-list").html('');
        handlePreloader();
        loadtruefalse();
    });

    function loadtruefalse() {
        $("#questions-list").html('');
        var school_id = $('#schools').val();
        var cat_id = $('#categories').val();
        var subcat_id = $('#subcategories').val();
        $.post("<?= base_url() ?>admin/home/getquestions",
                {school_id: school_id, cat_id: cat_id, subcat_id: subcat_id, quiz: 'truefalse'},
                function (data, status) {
                    data = $.parseJSON(data);
                    var count = 1;
                    $.each(data, function (i) {
                        $('#questions-list').append('<tr><td>' + (count++) + '</td><td>' + data[i].question + '</td><td>' + data[i].answer + '</td><td><input type="hidden" value="' + data[i].id + ' id="qid"><a href="<?= base_url() ?>admin/quiz/true-false/edit/' + data[i].id + '" class="btn btn-info btn-sm" data-toggle="tooltip" data-placement="left" title="Update"><i class="fa fa-pencil" aria-hidden="true"></i></a><a class="btn btn-danger btn-sm" onclick=deletetruefalse("' + data[i].id + '") data-toggle="tooltip" data-placement="right" title="Delete "><i class="fa fa-trash-o" aria-hidden="true"></i></a></td></tr>');
                    });
                    $("#preloader").removeClass('preloader');
                });
    }
    function deletetruefalse(id) {
        swal({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then(function () {
            handlePreloader();
            $.post("<?= base_url() ?>admin/quiz/true-false/delete",
                    {id: id},
                    function (data, status) {
                        swal(
                                'Success!',
                                'The question has been deleted!',
                                'success'
                                );
                        loadtruefalse();
                        $("#preloader").removeClass('preloader');
                    });
        });
    }

    function handlePreloader() {
        $("#preloader").addClass('preloader');
        if ($('.preloader').length) {
            $('.preloader').show();
            //$('.preloader').fadeOut(500);
        }
    }

</script>